/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_6.Duration;
import io.fabric8.kubernetes.api.model.v6_6.rbac.Subject;
import io.fabric8.openshift.api.model.v6_6.hive.v1.ClusterClaimSpec;
import io.fabric8.openshift.api.model.v6_6.hive.v1.ClusterClaimSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterClaimSpecFluentImpl<A extends ClusterClaimSpecFluent<A>>
extends BaseFluent<A>
implements ClusterClaimSpecFluent<A> {
    private String clusterPoolName;
    private Duration lifetime;
    private String namespace;
    private List<Subject> subjects = new ArrayList<Subject>();
    private Map<String, Object> additionalProperties;

    public ClusterClaimSpecFluentImpl() {
    }

    public ClusterClaimSpecFluentImpl(ClusterClaimSpec instance) {
        this.withClusterPoolName(instance.getClusterPoolName());
        this.withLifetime(instance.getLifetime());
        this.withNamespace(instance.getNamespace());
        this.withSubjects(instance.getSubjects());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getClusterPoolName() {
        return this.clusterPoolName;
    }

    @Override
    public A withClusterPoolName(String clusterPoolName) {
        this.clusterPoolName = clusterPoolName;
        return (A)this;
    }

    @Override
    public Boolean hasClusterPoolName() {
        return this.clusterPoolName != null;
    }

    @Override
    public Duration getLifetime() {
        return this.lifetime;
    }

    @Override
    public A withLifetime(Duration lifetime) {
        this.lifetime = lifetime;
        return (A)this;
    }

    @Override
    public Boolean hasLifetime() {
        return this.lifetime != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public A addToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        this.subjects.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        this.subjects.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        for (Subject item : items) {
            this.subjects.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        for (Subject item : items) {
            this.subjects.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(Subject ... items) {
        for (Subject item : items) {
            if (this.subjects == null) continue;
            this.subjects.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<Subject> items) {
        for (Subject item : items) {
            if (this.subjects == null) continue;
            this.subjects.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Subject> getSubjects() {
        return this.subjects;
    }

    @Override
    public Subject getSubject(Integer index) {
        return this.subjects.get(index);
    }

    @Override
    public Subject getFirstSubject() {
        return this.subjects.get(0);
    }

    @Override
    public Subject getLastSubject() {
        return this.subjects.get(this.subjects.size() - 1);
    }

    @Override
    public Subject getMatchingSubject(Predicate<Subject> predicate) {
        for (Subject item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<Subject> predicate) {
        for (Subject item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<Subject> subjects) {
        if (subjects != null) {
            this.subjects = new ArrayList<Subject>();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public A addNewSubject(String apiGroup, String kind, String name, String namespace) {
        return this.addToSubjects(new Subject(apiGroup, kind, name, namespace));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterClaimSpecFluentImpl that = (ClusterClaimSpecFluentImpl)o;
        if (this.clusterPoolName != null ? !this.clusterPoolName.equals(that.clusterPoolName) : that.clusterPoolName != null) {
            return false;
        }
        if (this.lifetime != null ? !this.lifetime.equals(that.lifetime) : that.lifetime != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterPoolName, this.lifetime, this.namespace, this.subjects, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterPoolName != null) {
            sb.append("clusterPoolName:");
            sb.append(this.clusterPoolName + ",");
        }
        if (this.lifetime != null) {
            sb.append("lifetime:");
            sb.append(this.lifetime + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

