/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.openshift.api.model.v6_6.hive.aws.v1.PrivateLinkAccessStatus;
import io.fabric8.openshift.api.model.v6_6.hive.aws.v1.PrivateLinkAccessStatusFluent;
import io.fabric8.openshift.api.model.v6_6.hive.aws.v1.VPCEndpointService;
import io.fabric8.openshift.api.model.v6_6.hive.aws.v1.VPCEndpointServiceBuilder;
import io.fabric8.openshift.api.model.v6_6.hive.aws.v1.VPCEndpointServiceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PrivateLinkAccessStatusFluentImpl<A extends PrivateLinkAccessStatusFluent<A>>
extends BaseFluent<A>
implements PrivateLinkAccessStatusFluent<A> {
    private String hostedZoneID;
    private String vpcEndpointID;
    private VPCEndpointServiceBuilder vpcEndpointService;
    private Map<String, Object> additionalProperties;

    public PrivateLinkAccessStatusFluentImpl() {
    }

    public PrivateLinkAccessStatusFluentImpl(PrivateLinkAccessStatus instance) {
        this.withHostedZoneID(instance.getHostedZoneID());
        this.withVpcEndpointID(instance.getVpcEndpointID());
        this.withVpcEndpointService(instance.getVpcEndpointService());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getHostedZoneID() {
        return this.hostedZoneID;
    }

    @Override
    public A withHostedZoneID(String hostedZoneID) {
        this.hostedZoneID = hostedZoneID;
        return (A)this;
    }

    @Override
    public Boolean hasHostedZoneID() {
        return this.hostedZoneID != null;
    }

    @Override
    public String getVpcEndpointID() {
        return this.vpcEndpointID;
    }

    @Override
    public A withVpcEndpointID(String vpcEndpointID) {
        this.vpcEndpointID = vpcEndpointID;
        return (A)this;
    }

    @Override
    public Boolean hasVpcEndpointID() {
        return this.vpcEndpointID != null;
    }

    @Override
    @Deprecated
    public VPCEndpointService getVpcEndpointService() {
        return this.vpcEndpointService != null ? this.vpcEndpointService.build() : null;
    }

    @Override
    public VPCEndpointService buildVpcEndpointService() {
        return this.vpcEndpointService != null ? this.vpcEndpointService.build() : null;
    }

    @Override
    public A withVpcEndpointService(VPCEndpointService vpcEndpointService) {
        this._visitables.get("vpcEndpointService").remove(this.vpcEndpointService);
        if (vpcEndpointService != null) {
            this.vpcEndpointService = new VPCEndpointServiceBuilder(vpcEndpointService);
            this._visitables.get("vpcEndpointService").add(this.vpcEndpointService);
        } else {
            this.vpcEndpointService = null;
            this._visitables.get("vpcEndpointService").remove(this.vpcEndpointService);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVpcEndpointService() {
        return this.vpcEndpointService != null;
    }

    @Override
    public A withNewVpcEndpointService(String id, String name) {
        return this.withVpcEndpointService(new VPCEndpointService(id, name));
    }

    @Override
    public PrivateLinkAccessStatusFluent.VpcEndpointServiceNested<A> withNewVpcEndpointService() {
        return new VpcEndpointServiceNestedImpl();
    }

    @Override
    public PrivateLinkAccessStatusFluent.VpcEndpointServiceNested<A> withNewVpcEndpointServiceLike(VPCEndpointService item) {
        return new VpcEndpointServiceNestedImpl(item);
    }

    @Override
    public PrivateLinkAccessStatusFluent.VpcEndpointServiceNested<A> editVpcEndpointService() {
        return this.withNewVpcEndpointServiceLike(this.getVpcEndpointService());
    }

    @Override
    public PrivateLinkAccessStatusFluent.VpcEndpointServiceNested<A> editOrNewVpcEndpointService() {
        return this.withNewVpcEndpointServiceLike(this.getVpcEndpointService() != null ? this.getVpcEndpointService() : new VPCEndpointServiceBuilder().build());
    }

    @Override
    public PrivateLinkAccessStatusFluent.VpcEndpointServiceNested<A> editOrNewVpcEndpointServiceLike(VPCEndpointService item) {
        return this.withNewVpcEndpointServiceLike(this.getVpcEndpointService() != null ? this.getVpcEndpointService() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivateLinkAccessStatusFluentImpl that = (PrivateLinkAccessStatusFluentImpl)o;
        if (this.hostedZoneID != null ? !this.hostedZoneID.equals(that.hostedZoneID) : that.hostedZoneID != null) {
            return false;
        }
        if (this.vpcEndpointID != null ? !this.vpcEndpointID.equals(that.vpcEndpointID) : that.vpcEndpointID != null) {
            return false;
        }
        if (this.vpcEndpointService != null ? !this.vpcEndpointService.equals(that.vpcEndpointService) : that.vpcEndpointService != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostedZoneID, this.vpcEndpointID, this.vpcEndpointService, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostedZoneID != null) {
            sb.append("hostedZoneID:");
            sb.append(this.hostedZoneID + ",");
        }
        if (this.vpcEndpointID != null) {
            sb.append("vpcEndpointID:");
            sb.append(this.vpcEndpointID + ",");
        }
        if (this.vpcEndpointService != null) {
            sb.append("vpcEndpointService:");
            sb.append(this.vpcEndpointService + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class VpcEndpointServiceNestedImpl<N>
    extends VPCEndpointServiceFluentImpl<PrivateLinkAccessStatusFluent.VpcEndpointServiceNested<N>>
    implements PrivateLinkAccessStatusFluent.VpcEndpointServiceNested<N>,
    Nested<N> {
        VPCEndpointServiceBuilder builder;

        VpcEndpointServiceNestedImpl(VPCEndpointService item) {
            this.builder = new VPCEndpointServiceBuilder(this, item);
        }

        VpcEndpointServiceNestedImpl() {
            this.builder = new VPCEndpointServiceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PrivateLinkAccessStatusFluentImpl.this.withVpcEndpointService(this.builder.build());
        }

        @Override
        public N endVpcEndpointService() {
            return this.and();
        }
    }
}

