/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.config.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.openshift.api.model.v6_6.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_6.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_6.config.v1.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_6.config.v1.ImageSpec;
import io.fabric8.openshift.api.model.v6_6.config.v1.ImageSpecFluent;
import io.fabric8.openshift.api.model.v6_6.config.v1.RegistryLocation;
import io.fabric8.openshift.api.model.v6_6.config.v1.RegistryLocationBuilder;
import io.fabric8.openshift.api.model.v6_6.config.v1.RegistryLocationFluentImpl;
import io.fabric8.openshift.api.model.v6_6.config.v1.RegistrySources;
import io.fabric8.openshift.api.model.v6_6.config.v1.RegistrySourcesBuilder;
import io.fabric8.openshift.api.model.v6_6.config.v1.RegistrySourcesFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageSpecFluentImpl<A extends ImageSpecFluent<A>>
extends BaseFluent<A>
implements ImageSpecFluent<A> {
    private ConfigMapNameReferenceBuilder additionalTrustedCA;
    private ArrayList<RegistryLocationBuilder> allowedRegistriesForImport = new ArrayList();
    private List<String> externalRegistryHostnames = new ArrayList<String>();
    private RegistrySourcesBuilder registrySources;
    private Map<String, Object> additionalProperties;

    public ImageSpecFluentImpl() {
    }

    public ImageSpecFluentImpl(ImageSpec instance) {
        this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
        this.withAllowedRegistriesForImport(instance.getAllowedRegistriesForImport());
        this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
        this.withRegistrySources(instance.getRegistrySources());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getAdditionalTrustedCA() {
        return this.additionalTrustedCA != null ? this.additionalTrustedCA.build() : null;
    }

    @Override
    public ConfigMapNameReference buildAdditionalTrustedCA() {
        return this.additionalTrustedCA != null ? this.additionalTrustedCA.build() : null;
    }

    @Override
    public A withAdditionalTrustedCA(ConfigMapNameReference additionalTrustedCA) {
        this._visitables.get("additionalTrustedCA").remove(this.additionalTrustedCA);
        if (additionalTrustedCA != null) {
            this.additionalTrustedCA = new ConfigMapNameReferenceBuilder(additionalTrustedCA);
            this._visitables.get("additionalTrustedCA").add(this.additionalTrustedCA);
        } else {
            this.additionalTrustedCA = null;
            this._visitables.get("additionalTrustedCA").remove(this.additionalTrustedCA);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalTrustedCA() {
        return this.additionalTrustedCA != null;
    }

    @Override
    public A withNewAdditionalTrustedCA(String name) {
        return this.withAdditionalTrustedCA(new ConfigMapNameReference(name));
    }

    @Override
    public ImageSpecFluent.AdditionalTrustedCANested<A> withNewAdditionalTrustedCA() {
        return new AdditionalTrustedCANestedImpl();
    }

    @Override
    public ImageSpecFluent.AdditionalTrustedCANested<A> withNewAdditionalTrustedCALike(ConfigMapNameReference item) {
        return new AdditionalTrustedCANestedImpl(item);
    }

    @Override
    public ImageSpecFluent.AdditionalTrustedCANested<A> editAdditionalTrustedCA() {
        return this.withNewAdditionalTrustedCALike(this.getAdditionalTrustedCA());
    }

    @Override
    public ImageSpecFluent.AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCA() {
        return this.withNewAdditionalTrustedCALike(this.getAdditionalTrustedCA() != null ? this.getAdditionalTrustedCA() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public ImageSpecFluent.AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCALike(ConfigMapNameReference item) {
        return this.withNewAdditionalTrustedCALike(this.getAdditionalTrustedCA() != null ? this.getAdditionalTrustedCA() : item);
    }

    @Override
    public A addToAllowedRegistriesForImport(Integer index, RegistryLocation item) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
        this._visitables.get("allowedRegistriesForImport").add(index >= 0 ? index.intValue() : this._visitables.get("allowedRegistriesForImport").size(), builder);
        this.allowedRegistriesForImport.add(index >= 0 ? index.intValue() : this.allowedRegistriesForImport.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedRegistriesForImport(Integer index, RegistryLocation item) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
        if (index < 0 || index >= this._visitables.get("allowedRegistriesForImport").size()) {
            this._visitables.get("allowedRegistriesForImport").add(builder);
        } else {
            this._visitables.get("allowedRegistriesForImport").set(index, builder);
        }
        if (index < 0 || index >= this.allowedRegistriesForImport.size()) {
            this.allowedRegistriesForImport.add(builder);
        } else {
            this.allowedRegistriesForImport.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedRegistriesForImport(RegistryLocation ... items) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").add(builder);
            this.allowedRegistriesForImport.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedRegistriesForImport(Collection<RegistryLocation> items) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").add(builder);
            this.allowedRegistriesForImport.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedRegistriesForImport(RegistryLocation ... items) {
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").remove(builder);
            if (this.allowedRegistriesForImport == null) continue;
            this.allowedRegistriesForImport.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedRegistriesForImport(Collection<RegistryLocation> items) {
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").remove(builder);
            if (this.allowedRegistriesForImport == null) continue;
            this.allowedRegistriesForImport.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        if (this.allowedRegistriesForImport == null) {
            return (A)this;
        }
        Iterator<RegistryLocationBuilder> each = this.allowedRegistriesForImport.iterator();
        Object visitables = this._visitables.get("allowedRegistriesForImport");
        while (each.hasNext()) {
            RegistryLocationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RegistryLocation> getAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport != null ? ImageSpecFluentImpl.build(this.allowedRegistriesForImport) : null;
    }

    @Override
    public List<RegistryLocation> buildAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport != null ? ImageSpecFluentImpl.build(this.allowedRegistriesForImport) : null;
    }

    @Override
    public RegistryLocation buildAllowedRegistriesForImport(Integer index) {
        return this.allowedRegistriesForImport.get(index).build();
    }

    @Override
    public RegistryLocation buildFirstAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport.get(0).build();
    }

    @Override
    public RegistryLocation buildLastAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport.get(this.allowedRegistriesForImport.size() - 1).build();
    }

    @Override
    public RegistryLocation buildMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        for (RegistryLocationBuilder item : this.allowedRegistriesForImport) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        for (RegistryLocationBuilder item : this.allowedRegistriesForImport) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedRegistriesForImport(List<RegistryLocation> allowedRegistriesForImport) {
        if (this.allowedRegistriesForImport != null) {
            this._visitables.get("allowedRegistriesForImport").removeAll(this.allowedRegistriesForImport);
        }
        if (allowedRegistriesForImport != null) {
            this.allowedRegistriesForImport = new ArrayList();
            for (RegistryLocation item : allowedRegistriesForImport) {
                this.addToAllowedRegistriesForImport(item);
            }
        } else {
            this.allowedRegistriesForImport = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedRegistriesForImport(RegistryLocation ... allowedRegistriesForImport) {
        if (this.allowedRegistriesForImport != null) {
            this.allowedRegistriesForImport.clear();
        }
        if (allowedRegistriesForImport != null) {
            for (RegistryLocation item : allowedRegistriesForImport) {
                this.addToAllowedRegistriesForImport(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport != null && !this.allowedRegistriesForImport.isEmpty();
    }

    @Override
    public A addNewAllowedRegistriesForImport(String domainName, Boolean insecure) {
        return this.addToAllowedRegistriesForImport(new RegistryLocation(domainName, insecure));
    }

    @Override
    public ImageSpecFluent.AllowedRegistriesForImportNested<A> addNewAllowedRegistriesForImport() {
        return new AllowedRegistriesForImportNestedImpl();
    }

    @Override
    public ImageSpecFluent.AllowedRegistriesForImportNested<A> addNewAllowedRegistriesForImportLike(RegistryLocation item) {
        return new AllowedRegistriesForImportNestedImpl(-1, item);
    }

    @Override
    public ImageSpecFluent.AllowedRegistriesForImportNested<A> setNewAllowedRegistriesForImportLike(Integer index, RegistryLocation item) {
        return new AllowedRegistriesForImportNestedImpl(index, item);
    }

    @Override
    public ImageSpecFluent.AllowedRegistriesForImportNested<A> editAllowedRegistriesForImport(Integer index) {
        if (this.allowedRegistriesForImport.size() <= index) {
            throw new RuntimeException("Can't edit allowedRegistriesForImport. Index exceeds size.");
        }
        return this.setNewAllowedRegistriesForImportLike(index, this.buildAllowedRegistriesForImport(index));
    }

    @Override
    public ImageSpecFluent.AllowedRegistriesForImportNested<A> editFirstAllowedRegistriesForImport() {
        if (this.allowedRegistriesForImport.size() == 0) {
            throw new RuntimeException("Can't edit first allowedRegistriesForImport. The list is empty.");
        }
        return this.setNewAllowedRegistriesForImportLike(0, this.buildAllowedRegistriesForImport(0));
    }

    @Override
    public ImageSpecFluent.AllowedRegistriesForImportNested<A> editLastAllowedRegistriesForImport() {
        int index = this.allowedRegistriesForImport.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedRegistriesForImport. The list is empty.");
        }
        return this.setNewAllowedRegistriesForImportLike(index, this.buildAllowedRegistriesForImport(index));
    }

    @Override
    public ImageSpecFluent.AllowedRegistriesForImportNested<A> editMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedRegistriesForImport.size(); ++i) {
            if (!predicate.test(this.allowedRegistriesForImport.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedRegistriesForImport. No match found.");
        }
        return this.setNewAllowedRegistriesForImportLike(index, this.buildAllowedRegistriesForImport(index));
    }

    @Override
    public A addToExternalRegistryHostnames(Integer index, String item) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        this.externalRegistryHostnames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExternalRegistryHostnames(Integer index, String item) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        this.externalRegistryHostnames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExternalRegistryHostnames(String ... items) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalRegistryHostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExternalRegistryHostnames(Collection<String> items) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalRegistryHostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalRegistryHostnames(String ... items) {
        for (String item : items) {
            if (this.externalRegistryHostnames == null) continue;
            this.externalRegistryHostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExternalRegistryHostnames(Collection<String> items) {
        for (String item : items) {
            if (this.externalRegistryHostnames == null) continue;
            this.externalRegistryHostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExternalRegistryHostnames() {
        return this.externalRegistryHostnames;
    }

    @Override
    public String getExternalRegistryHostname(Integer index) {
        return this.externalRegistryHostnames.get(index);
    }

    @Override
    public String getFirstExternalRegistryHostname() {
        return this.externalRegistryHostnames.get(0);
    }

    @Override
    public String getLastExternalRegistryHostname() {
        return this.externalRegistryHostnames.get(this.externalRegistryHostnames.size() - 1);
    }

    @Override
    public String getMatchingExternalRegistryHostname(Predicate<String> predicate) {
        for (String item : this.externalRegistryHostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExternalRegistryHostname(Predicate<String> predicate) {
        for (String item : this.externalRegistryHostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExternalRegistryHostnames(List<String> externalRegistryHostnames) {
        if (externalRegistryHostnames != null) {
            this.externalRegistryHostnames = new ArrayList<String>();
            for (String item : externalRegistryHostnames) {
                this.addToExternalRegistryHostnames(item);
            }
        } else {
            this.externalRegistryHostnames = null;
        }
        return (A)this;
    }

    @Override
    public A withExternalRegistryHostnames(String ... externalRegistryHostnames) {
        if (this.externalRegistryHostnames != null) {
            this.externalRegistryHostnames.clear();
        }
        if (externalRegistryHostnames != null) {
            for (String item : externalRegistryHostnames) {
                this.addToExternalRegistryHostnames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalRegistryHostnames() {
        return this.externalRegistryHostnames != null && !this.externalRegistryHostnames.isEmpty();
    }

    @Override
    @Deprecated
    public RegistrySources getRegistrySources() {
        return this.registrySources != null ? this.registrySources.build() : null;
    }

    @Override
    public RegistrySources buildRegistrySources() {
        return this.registrySources != null ? this.registrySources.build() : null;
    }

    @Override
    public A withRegistrySources(RegistrySources registrySources) {
        this._visitables.get("registrySources").remove(this.registrySources);
        if (registrySources != null) {
            this.registrySources = new RegistrySourcesBuilder(registrySources);
            this._visitables.get("registrySources").add(this.registrySources);
        } else {
            this.registrySources = null;
            this._visitables.get("registrySources").remove(this.registrySources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRegistrySources() {
        return this.registrySources != null;
    }

    @Override
    public ImageSpecFluent.RegistrySourcesNested<A> withNewRegistrySources() {
        return new RegistrySourcesNestedImpl();
    }

    @Override
    public ImageSpecFluent.RegistrySourcesNested<A> withNewRegistrySourcesLike(RegistrySources item) {
        return new RegistrySourcesNestedImpl(item);
    }

    @Override
    public ImageSpecFluent.RegistrySourcesNested<A> editRegistrySources() {
        return this.withNewRegistrySourcesLike(this.getRegistrySources());
    }

    @Override
    public ImageSpecFluent.RegistrySourcesNested<A> editOrNewRegistrySources() {
        return this.withNewRegistrySourcesLike(this.getRegistrySources() != null ? this.getRegistrySources() : new RegistrySourcesBuilder().build());
    }

    @Override
    public ImageSpecFluent.RegistrySourcesNested<A> editOrNewRegistrySourcesLike(RegistrySources item) {
        return this.withNewRegistrySourcesLike(this.getRegistrySources() != null ? this.getRegistrySources() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageSpecFluentImpl that = (ImageSpecFluentImpl)o;
        if (this.additionalTrustedCA != null ? !this.additionalTrustedCA.equals(that.additionalTrustedCA) : that.additionalTrustedCA != null) {
            return false;
        }
        if (this.allowedRegistriesForImport != null ? !this.allowedRegistriesForImport.equals(that.allowedRegistriesForImport) : that.allowedRegistriesForImport != null) {
            return false;
        }
        if (this.externalRegistryHostnames != null ? !this.externalRegistryHostnames.equals(that.externalRegistryHostnames) : that.externalRegistryHostnames != null) {
            return false;
        }
        if (this.registrySources != null ? !this.registrySources.equals(that.registrySources) : that.registrySources != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalTrustedCA, this.allowedRegistriesForImport, this.externalRegistryHostnames, this.registrySources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalTrustedCA != null) {
            sb.append("additionalTrustedCA:");
            sb.append(this.additionalTrustedCA + ",");
        }
        if (this.allowedRegistriesForImport != null && !this.allowedRegistriesForImport.isEmpty()) {
            sb.append("allowedRegistriesForImport:");
            sb.append(this.allowedRegistriesForImport + ",");
        }
        if (this.externalRegistryHostnames != null && !this.externalRegistryHostnames.isEmpty()) {
            sb.append("externalRegistryHostnames:");
            sb.append(this.externalRegistryHostnames + ",");
        }
        if (this.registrySources != null) {
            sb.append("registrySources:");
            sb.append(this.registrySources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RegistrySourcesNestedImpl<N>
    extends RegistrySourcesFluentImpl<ImageSpecFluent.RegistrySourcesNested<N>>
    implements ImageSpecFluent.RegistrySourcesNested<N>,
    Nested<N> {
        RegistrySourcesBuilder builder;

        RegistrySourcesNestedImpl(RegistrySources item) {
            this.builder = new RegistrySourcesBuilder(this, item);
        }

        RegistrySourcesNestedImpl() {
            this.builder = new RegistrySourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSpecFluentImpl.this.withRegistrySources(this.builder.build());
        }

        @Override
        public N endRegistrySources() {
            return this.and();
        }
    }

    class AllowedRegistriesForImportNestedImpl<N>
    extends RegistryLocationFluentImpl<ImageSpecFluent.AllowedRegistriesForImportNested<N>>
    implements ImageSpecFluent.AllowedRegistriesForImportNested<N>,
    Nested<N> {
        RegistryLocationBuilder builder;
        Integer index;

        AllowedRegistriesForImportNestedImpl(Integer index, RegistryLocation item) {
            this.index = index;
            this.builder = new RegistryLocationBuilder(this, item);
        }

        AllowedRegistriesForImportNestedImpl() {
            this.index = -1;
            this.builder = new RegistryLocationBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSpecFluentImpl.this.setToAllowedRegistriesForImport(this.index, this.builder.build());
        }

        @Override
        public N endAllowedRegistriesForImport() {
            return this.and();
        }
    }

    class AdditionalTrustedCANestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<ImageSpecFluent.AdditionalTrustedCANested<N>>
    implements ImageSpecFluent.AdditionalTrustedCANested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        AdditionalTrustedCANestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        AdditionalTrustedCANestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSpecFluentImpl.this.withAdditionalTrustedCA(this.builder.build());
        }

        @Override
        public N endAdditionalTrustedCA() {
            return this.and();
        }
    }
}

