/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.openshift.api.model.v6_6.RouteIngress;
import io.fabric8.openshift.api.model.v6_6.RouteIngressCondition;
import io.fabric8.openshift.api.model.v6_6.RouteIngressConditionBuilder;
import io.fabric8.openshift.api.model.v6_6.RouteIngressConditionFluentImpl;
import io.fabric8.openshift.api.model.v6_6.RouteIngressFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteIngressFluentImpl<A extends RouteIngressFluent<A>>
extends BaseFluent<A>
implements RouteIngressFluent<A> {
    private ArrayList<RouteIngressConditionBuilder> conditions = new ArrayList();
    private String host;
    private String routerCanonicalHostname;
    private String routerName;
    private String wildcardPolicy;
    private Map<String, Object> additionalProperties;

    public RouteIngressFluentImpl() {
    }

    public RouteIngressFluentImpl(RouteIngress instance) {
        this.withConditions(instance.getConditions());
        this.withHost(instance.getHost());
        this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
        this.withRouterName(instance.getRouterName());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(RouteIngressCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<RouteIngressCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(RouteIngressCondition ... items) {
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<RouteIngressCondition> items) {
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<RouteIngressConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<RouteIngressConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            RouteIngressConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteIngressCondition> getConditions() {
        return this.conditions != null ? RouteIngressFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<RouteIngressCondition> buildConditions() {
        return this.conditions != null ? RouteIngressFluentImpl.build(this.conditions) : null;
    }

    @Override
    public RouteIngressCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public RouteIngressCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public RouteIngressCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public RouteIngressCondition buildMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<RouteIngressCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(RouteIngressCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> addNewConditionLike(RouteIngressCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> setNewConditionLike(Integer index, RouteIngressCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public String getRouterCanonicalHostname() {
        return this.routerCanonicalHostname;
    }

    @Override
    public A withRouterCanonicalHostname(String routerCanonicalHostname) {
        this.routerCanonicalHostname = routerCanonicalHostname;
        return (A)this;
    }

    @Override
    public Boolean hasRouterCanonicalHostname() {
        return this.routerCanonicalHostname != null;
    }

    @Override
    public String getRouterName() {
        return this.routerName;
    }

    @Override
    public A withRouterName(String routerName) {
        this.routerName = routerName;
        return (A)this;
    }

    @Override
    public Boolean hasRouterName() {
        return this.routerName != null;
    }

    @Override
    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    @Override
    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteIngressFluentImpl that = (RouteIngressFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.routerCanonicalHostname != null ? !this.routerCanonicalHostname.equals(that.routerCanonicalHostname) : that.routerCanonicalHostname != null) {
            return false;
        }
        if (this.routerName != null ? !this.routerName.equals(that.routerName) : that.routerName != null) {
            return false;
        }
        if (this.wildcardPolicy != null ? !this.wildcardPolicy.equals(that.wildcardPolicy) : that.wildcardPolicy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.host, this.routerCanonicalHostname, this.routerName, this.wildcardPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.routerCanonicalHostname != null) {
            sb.append("routerCanonicalHostname:");
            sb.append(this.routerCanonicalHostname + ",");
        }
        if (this.routerName != null) {
            sb.append("routerName:");
            sb.append(this.routerName + ",");
        }
        if (this.wildcardPolicy != null) {
            sb.append("wildcardPolicy:");
            sb.append(this.wildcardPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends RouteIngressConditionFluentImpl<RouteIngressFluent.ConditionsNested<N>>
    implements RouteIngressFluent.ConditionsNested<N>,
    Nested<N> {
        RouteIngressConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, RouteIngressCondition item) {
            this.index = index;
            this.builder = new RouteIngressConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new RouteIngressConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteIngressFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

