/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_6.dsl.internal.batch.v1;

import io.fabric8.kubernetes.api.model.v6_6.batch.v1.Job;
import io.fabric8.kubernetes.api.model.v6_6.batch.v1.JobList;
import io.fabric8.kubernetes.clnt.v6_6.Client;
import io.fabric8.kubernetes.clnt.v6_6.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_6.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_6.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v6_6.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_6.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_6.dsl.ScalableResource;
import io.fabric8.kubernetes.clnt.v6_6.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_6.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_6.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_6.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_6.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_6.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v6_6.utils.internal.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, ScalableResource<Job>>
implements ScalableResource<Job> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);
    private final PodOperationContext podControllerOperationContext;

    public JobOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public JobOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs"), Job.class, JobList.class);
        this.podControllerOperationContext = context;
    }

    @Override
    public JobOperationsImpl newInstance(OperationContext context) {
        return new JobOperationsImpl(this.podControllerOperationContext, context);
    }

    @Override
    public Job scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Job scale(int count, boolean wait) {
        Job res = (Job)this.accept(b -> b.getSpec().setParallelism(count));
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getItemOrRequireFromServer();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        AtomicReference atomicJob = new AtomicReference();
        this.waitUntilCondition(job -> {
            atomicJob.set(job);
            Integer activeJobs = job.getStatus().getActive();
            if (activeJobs == null) {
                activeJobs = 0;
            }
            if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                return true;
            }
            LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", new Object[]{job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), this.namespace});
            return false;
        }, this.getRequestConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
    }

    public String getLog() {
        return this.getLog(this.podControllerOperationContext.isPrettyOutput());
    }

    public String getLog(boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource> podOperationList = this.doGetLog();
        for (PodResource podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource> doGetLog() {
        Job job = (Job)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, this.podControllerOperationContext, job.getMetadata().getUid(), JobOperationsImpl.getJobPodLabels(job));
    }

    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog());
    }

    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog());
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(), out);
    }

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return this.withReadyWaitTimeout(logWaitTimeout);
    }

    public Loggable withReadyWaitTimeout(Integer timeout) {
        return new JobOperationsImpl(this.podControllerOperationContext.withReadyWaitTimeout(timeout), this.context);
    }

    @Override
    protected Job modifyItemForReplaceOrPatch(Supplier<Job> current, Job job) {
        Job jobFromServer = current.get();
        if (job.getSpec().getSelector() == null) {
            job.getSpec().setSelector(jobFromServer.getSpec().getSelector());
        }
        if (job.getSpec().getTemplate().getMetadata() != null) {
            job.getSpec().getTemplate().getMetadata().setLabels(jobFromServer.getSpec().getTemplate().getMetadata().getLabels());
        } else {
            job.getSpec().getTemplate().setMetadata(jobFromServer.getSpec().getTemplate().getMetadata());
        }
        return job;
    }

    static Map<String, String> getJobPodLabels(Job job) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (job != null && job.getMetadata() != null && job.getMetadata().getUid() != null) {
            labels.put("controller-uid", job.getMetadata().getUid());
        }
        return labels;
    }

    public Loggable inContainer(String id) {
        return new JobOperationsImpl(this.podControllerOperationContext.withContainerId(id), this.context);
    }

    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new JobOperationsImpl(this.podControllerOperationContext.withLimitBytes(limitBytes), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new JobOperationsImpl(this.podControllerOperationContext.withTerminatedStatus(true), this.context);
    }

    public Loggable withPrettyOutput() {
        return new JobOperationsImpl(this.podControllerOperationContext.withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int lines) {
        return new JobOperationsImpl(this.podControllerOperationContext.withTailingLines(lines), this.context);
    }

    public TailPrettyLoggable sinceTime(String timestamp) {
        return new JobOperationsImpl(this.podControllerOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new JobOperationsImpl(this.podControllerOperationContext.withSinceSeconds(seconds), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new JobOperationsImpl(this.podControllerOperationContext.withTimestamps(true), this.context);
    }
}

