/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_6.resource.v1alpha1.PodSchedulingSpec;
import io.fabric8.kubernetes.api.model.v6_6.resource.v1alpha1.PodSchedulingSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSchedulingSpecFluentImpl<A extends PodSchedulingSpecFluent<A>>
extends BaseFluent<A>
implements PodSchedulingSpecFluent<A> {
    private List<String> potentialNodes = new ArrayList<String>();
    private String selectedNode;
    private Map<String, Object> additionalProperties;

    public PodSchedulingSpecFluentImpl() {
    }

    public PodSchedulingSpecFluentImpl(PodSchedulingSpec instance) {
        this.withPotentialNodes(instance.getPotentialNodes());
        this.withSelectedNode(instance.getSelectedNode());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToPotentialNodes(Integer index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPotentialNodes(Integer index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPotentialNodes(String ... items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPotentialNodes(Collection<String> items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPotentialNodes(String ... items) {
        for (String item : items) {
            if (this.potentialNodes == null) continue;
            this.potentialNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPotentialNodes(Collection<String> items) {
        for (String item : items) {
            if (this.potentialNodes == null) continue;
            this.potentialNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPotentialNodes() {
        return this.potentialNodes;
    }

    @Override
    public String getPotentialNode(Integer index) {
        return this.potentialNodes.get(index);
    }

    @Override
    public String getFirstPotentialNode() {
        return this.potentialNodes.get(0);
    }

    @Override
    public String getLastPotentialNode() {
        return this.potentialNodes.get(this.potentialNodes.size() - 1);
    }

    @Override
    public String getMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPotentialNodes(List<String> potentialNodes) {
        if (potentialNodes != null) {
            this.potentialNodes = new ArrayList<String>();
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        } else {
            this.potentialNodes = null;
        }
        return (A)this;
    }

    @Override
    public A withPotentialNodes(String ... potentialNodes) {
        if (this.potentialNodes != null) {
            this.potentialNodes.clear();
        }
        if (potentialNodes != null) {
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPotentialNodes() {
        return this.potentialNodes != null && !this.potentialNodes.isEmpty();
    }

    @Override
    public String getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public A withSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
        return (A)this;
    }

    @Override
    public Boolean hasSelectedNode() {
        return this.selectedNode != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSchedulingSpecFluentImpl that = (PodSchedulingSpecFluentImpl)o;
        if (this.potentialNodes != null ? !this.potentialNodes.equals(that.potentialNodes) : that.potentialNodes != null) {
            return false;
        }
        if (this.selectedNode != null ? !this.selectedNode.equals(that.selectedNode) : that.selectedNode != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.potentialNodes, this.selectedNode, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.potentialNodes != null && !this.potentialNodes.isEmpty()) {
            sb.append("potentialNodes:");
            sb.append(this.potentialNodes + ",");
        }
        if (this.selectedNode != null) {
            sb.append("selectedNode:");
            sb.append(this.selectedNode + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

