/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_6.Condition;
import io.fabric8.kubernetes.api.model.v6_6.policy.v1beta1.PodDisruptionBudgetStatus;
import io.fabric8.kubernetes.api.model.v6_6.policy.v1beta1.PodDisruptionBudgetStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodDisruptionBudgetStatusFluentImpl<A extends PodDisruptionBudgetStatusFluent<A>>
extends BaseFluent<A>
implements PodDisruptionBudgetStatusFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private Integer currentHealthy;
    private Integer desiredHealthy;
    private Map<String, String> disruptedPods;
    private Integer disruptionsAllowed;
    private Integer expectedPods;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public PodDisruptionBudgetStatusFluentImpl() {
    }

    public PodDisruptionBudgetStatusFluentImpl(PodDisruptionBudgetStatus instance) {
        this.withConditions(instance.getConditions());
        this.withCurrentHealthy(instance.getCurrentHealthy());
        this.withDesiredHealthy(instance.getDesiredHealthy());
        this.withDisruptedPods(instance.getDisruptedPods());
        this.withDisruptionsAllowed(instance.getDisruptionsAllowed());
        this.withExpectedPods(instance.getExpectedPods());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    @Override
    public A withCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentHealthy() {
        return this.currentHealthy != null;
    }

    @Override
    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    @Override
    public A withDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredHealthy() {
        return this.desiredHealthy != null;
    }

    @Override
    public A addToDisruptedPods(String key, String value) {
        if (this.disruptedPods == null && key != null && value != null) {
            this.disruptedPods = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.disruptedPods.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDisruptedPods(Map<String, String> map) {
        if (this.disruptedPods == null && map != null) {
            this.disruptedPods = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.disruptedPods.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDisruptedPods(String key) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (key != null && this.disruptedPods != null) {
            this.disruptedPods.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDisruptedPods(Map<String, String> map) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.disruptedPods == null) continue;
                this.disruptedPods.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDisruptedPods() {
        return this.disruptedPods;
    }

    @Override
    public <K, V> A withDisruptedPods(Map<String, String> disruptedPods) {
        this.disruptedPods = disruptedPods == null ? null : new LinkedHashMap<String, String>(disruptedPods);
        return (A)this;
    }

    @Override
    public Boolean hasDisruptedPods() {
        return this.disruptedPods != null;
    }

    @Override
    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    @Override
    public A withDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return (A)this;
    }

    @Override
    public Boolean hasDisruptionsAllowed() {
        return this.disruptionsAllowed != null;
    }

    @Override
    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    @Override
    public A withExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return (A)this;
    }

    @Override
    public Boolean hasExpectedPods() {
        return this.expectedPods != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodDisruptionBudgetStatusFluentImpl that = (PodDisruptionBudgetStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentHealthy != null ? !this.currentHealthy.equals(that.currentHealthy) : that.currentHealthy != null) {
            return false;
        }
        if (this.desiredHealthy != null ? !this.desiredHealthy.equals(that.desiredHealthy) : that.desiredHealthy != null) {
            return false;
        }
        if (this.disruptedPods != null ? !this.disruptedPods.equals(that.disruptedPods) : that.disruptedPods != null) {
            return false;
        }
        if (this.disruptionsAllowed != null ? !this.disruptionsAllowed.equals(that.disruptionsAllowed) : that.disruptionsAllowed != null) {
            return false;
        }
        if (this.expectedPods != null ? !this.expectedPods.equals(that.expectedPods) : that.expectedPods != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHealthy, this.desiredHealthy, this.disruptedPods, this.disruptionsAllowed, this.expectedPods, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentHealthy != null) {
            sb.append("currentHealthy:");
            sb.append(this.currentHealthy + ",");
        }
        if (this.desiredHealthy != null) {
            sb.append("desiredHealthy:");
            sb.append(this.desiredHealthy + ",");
        }
        if (this.disruptedPods != null && !this.disruptedPods.isEmpty()) {
            sb.append("disruptedPods:");
            sb.append(this.disruptedPods + ",");
        }
        if (this.disruptionsAllowed != null) {
            sb.append("disruptionsAllowed:");
            sb.append(this.disruptionsAllowed + ",");
        }
        if (this.expectedPods != null) {
            sb.append("expectedPods:");
            sb.append(this.expectedPods + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

