/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.Duration;
import io.fabric8.kubernetes.api.model.v6_6.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_6.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_6.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.metrics.v1beta1.ContainerMetrics;
import io.fabric8.kubernetes.api.model.v6_6.metrics.v1beta1.ContainerMetricsBuilder;
import io.fabric8.kubernetes.api.model.v6_6.metrics.v1beta1.ContainerMetricsFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.metrics.v1beta1.PodMetrics;
import io.fabric8.kubernetes.api.model.v6_6.metrics.v1beta1.PodMetricsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodMetricsFluentImpl<A extends PodMetricsFluent<A>>
extends BaseFluent<A>
implements PodMetricsFluent<A> {
    private String apiVersion;
    private ArrayList<ContainerMetricsBuilder> containers = new ArrayList();
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private Duration window;
    private Map<String, Object> additionalProperties;

    public PodMetricsFluentImpl() {
    }

    public PodMetricsFluentImpl(PodMetrics instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withContainers(instance.getContainers());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTimestamp(instance.getTimestamp());
        this.withWindow(instance.getWindow());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToContainers(Integer index, ContainerMetrics item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
        this._visitables.get("containers").add(index >= 0 ? index.intValue() : this._visitables.get("containers").size(), builder);
        this.containers.add(index >= 0 ? index.intValue() : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(Integer index, ContainerMetrics item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
        if (index < 0 || index >= this._visitables.get("containers").size()) {
            this._visitables.get("containers").add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(ContainerMetrics ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<ContainerMetrics> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(ContainerMetrics ... items) {
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<ContainerMetrics> items) {
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerMetricsBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerMetricsBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            ContainerMetricsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerMetrics> getContainers() {
        return this.containers != null ? PodMetricsFluentImpl.build(this.containers) : null;
    }

    @Override
    public List<ContainerMetrics> buildContainers() {
        return this.containers != null ? PodMetricsFluentImpl.build(this.containers) : null;
    }

    @Override
    public ContainerMetrics buildContainer(Integer index) {
        return this.containers.get(index).build();
    }

    @Override
    public ContainerMetrics buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public ContainerMetrics buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public ContainerMetrics buildMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        for (ContainerMetricsBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        for (ContainerMetricsBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<ContainerMetrics> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (ContainerMetrics item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(ContainerMetrics ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (ContainerMetrics item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> addNewContainerLike(ContainerMetrics item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> setNewContainerLike(Integer index, ContainerMetrics item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editContainer(Integer index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public A withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return (A)this;
    }

    @Override
    public Boolean hasTimestamp() {
        return this.timestamp != null;
    }

    @Override
    public Duration getWindow() {
        return this.window;
    }

    @Override
    public A withWindow(Duration window) {
        this.window = window;
        return (A)this;
    }

    @Override
    public Boolean hasWindow() {
        return this.window != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodMetricsFluentImpl that = (PodMetricsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        if (this.window != null ? !this.window.equals(that.window) : that.window != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.containers, this.kind, this.metadata, this.timestamp, this.window, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.timestamp != null) {
            sb.append("timestamp:");
            sb.append(this.timestamp + ",");
        }
        if (this.window != null) {
            sb.append("window:");
            sb.append(this.window + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PodMetricsFluent.MetadataNested<N>>
    implements PodMetricsFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class ContainersNestedImpl<N>
    extends ContainerMetricsFluentImpl<PodMetricsFluent.ContainersNested<N>>
    implements PodMetricsFluent.ContainersNested<N>,
    Nested<N> {
        ContainerMetricsBuilder builder;
        Integer index;

        ContainersNestedImpl(Integer index, ContainerMetrics item) {
            this.index = index;
            this.builder = new ContainerMetricsBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerMetricsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

