/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.HTTPRouteRule;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.HTTPRouteRuleBuilder;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.HTTPRouteRuleFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.HTTPRouteSpec;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.HTTPRouteSpecFluent;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.ParentReference;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_6.gatewayapi.v1beta1.ParentReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteSpecFluentImpl<A extends HTTPRouteSpecFluent<A>>
extends BaseFluent<A>
implements HTTPRouteSpecFluent<A> {
    private List<String> hostnames = new ArrayList<String>();
    private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList();
    private ArrayList<HTTPRouteRuleBuilder> rules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteSpecFluentImpl() {
    }

    public HTTPRouteSpecFluentImpl(HTTPRouteSpec instance) {
        this.withHostnames(instance.getHostnames());
        this.withParentRefs(instance.getParentRefs());
        this.withRules(instance.getRules());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToHostnames(Integer index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostnames(Integer index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostnames(String ... items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostnames(Collection<String> items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHostnames() {
        return this.hostnames;
    }

    @Override
    public String getHostname(Integer index) {
        return this.hostnames.get(index);
    }

    @Override
    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    @Override
    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    @Override
    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostnames(List<String> hostnames) {
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = null;
        }
        return (A)this;
    }

    @Override
    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    @Override
    public A addToParentRefs(Integer index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        this._visitables.get("parentRefs").add(index >= 0 ? index.intValue() : this._visitables.get("parentRefs").size(), builder);
        this.parentRefs.add(index >= 0 ? index.intValue() : this.parentRefs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToParentRefs(Integer index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("parentRefs").size()) {
            this._visitables.get("parentRefs").add(builder);
        } else {
            this._visitables.get("parentRefs").set(index, builder);
        }
        if (index < 0 || index >= this.parentRefs.size()) {
            this.parentRefs.add(builder);
        } else {
            this.parentRefs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParentRefs(ParentReference ... items) {
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").remove(builder);
            if (this.parentRefs == null) continue;
            this.parentRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromParentRefs(Collection<ParentReference> items) {
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").remove(builder);
            if (this.parentRefs == null) continue;
            this.parentRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
        if (this.parentRefs == null) {
            return (A)this;
        }
        Iterator<ParentReferenceBuilder> each = this.parentRefs.iterator();
        Object visitables = this._visitables.get("parentRefs");
        while (each.hasNext()) {
            ParentReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ParentReference> getParentRefs() {
        return this.parentRefs != null ? HTTPRouteSpecFluentImpl.build(this.parentRefs) : null;
    }

    @Override
    public List<ParentReference> buildParentRefs() {
        return this.parentRefs != null ? HTTPRouteSpecFluentImpl.build(this.parentRefs) : null;
    }

    @Override
    public ParentReference buildParentRef(Integer index) {
        return this.parentRefs.get(index).build();
    }

    @Override
    public ParentReference buildFirstParentRef() {
        return this.parentRefs.get(0).build();
    }

    @Override
    public ParentReference buildLastParentRef() {
        return this.parentRefs.get(this.parentRefs.size() - 1).build();
    }

    @Override
    public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withParentRefs(List<ParentReference> parentRefs) {
        if (this.parentRefs != null) {
            this._visitables.get("parentRefs").removeAll(this.parentRefs);
        }
        if (parentRefs != null) {
            this.parentRefs = new ArrayList();
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        } else {
            this.parentRefs = null;
        }
        return (A)this;
    }

    @Override
    public A withParentRefs(ParentReference ... parentRefs) {
        if (this.parentRefs != null) {
            this.parentRefs.clear();
        }
        if (parentRefs != null) {
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasParentRefs() {
        return this.parentRefs != null && !this.parentRefs.isEmpty();
    }

    @Override
    public HTTPRouteSpecFluent.ParentRefsNested<A> addNewParentRef() {
        return new ParentRefsNestedImpl();
    }

    @Override
    public HTTPRouteSpecFluent.ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
        return new ParentRefsNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteSpecFluent.ParentRefsNested<A> setNewParentRefLike(Integer index, ParentReference item) {
        return new ParentRefsNestedImpl(index, item);
    }

    @Override
    public HTTPRouteSpecFluent.ParentRefsNested<A> editParentRef(Integer index) {
        if (this.parentRefs.size() <= index) {
            throw new RuntimeException("Can't edit parentRefs. Index exceeds size.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    @Override
    public HTTPRouteSpecFluent.ParentRefsNested<A> editFirstParentRef() {
        if (this.parentRefs.size() == 0) {
            throw new RuntimeException("Can't edit first parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(0, this.buildParentRef(0));
    }

    @Override
    public HTTPRouteSpecFluent.ParentRefsNested<A> editLastParentRef() {
        int index = this.parentRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    @Override
    public HTTPRouteSpecFluent.ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parentRefs.size(); ++i) {
            if (!predicate.test(this.parentRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parentRefs. No match found.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    @Override
    public A addToRules(Integer index, HTTPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
        this._visitables.get("rules").add(index >= 0 ? index.intValue() : this._visitables.get("rules").size(), builder);
        this.rules.add(index >= 0 ? index.intValue() : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(Integer index, HTTPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("rules").size()) {
            this._visitables.get("rules").add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(HTTPRouteRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<HTTPRouteRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(HTTPRouteRule ... items) {
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<HTTPRouteRule> items) {
        for (HTTPRouteRule item : items) {
            HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<HTTPRouteRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<HTTPRouteRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            HTTPRouteRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPRouteRule> getRules() {
        return this.rules != null ? HTTPRouteSpecFluentImpl.build(this.rules) : null;
    }

    @Override
    public List<HTTPRouteRule> buildRules() {
        return this.rules != null ? HTTPRouteSpecFluentImpl.build(this.rules) : null;
    }

    @Override
    public HTTPRouteRule buildRule(Integer index) {
        return this.rules.get(index).build();
    }

    @Override
    public HTTPRouteRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public HTTPRouteRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public HTTPRouteRule buildMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
        for (HTTPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
        for (HTTPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<HTTPRouteRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (HTTPRouteRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(HTTPRouteRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (HTTPRouteRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public HTTPRouteSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public HTTPRouteSpecFluent.RulesNested<A> addNewRuleLike(HTTPRouteRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteSpecFluent.RulesNested<A> setNewRuleLike(Integer index, HTTPRouteRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public HTTPRouteSpecFluent.RulesNested<A> editRule(Integer index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public HTTPRouteSpecFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public HTTPRouteSpecFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public HTTPRouteSpecFluent.RulesNested<A> editMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPRouteSpecFluentImpl that = (HTTPRouteSpecFluentImpl)o;
        if (this.hostnames != null ? !this.hostnames.equals(that.hostnames) : that.hostnames != null) {
            return false;
        }
        if (this.parentRefs != null ? !this.parentRefs.equals(that.parentRefs) : that.parentRefs != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostnames, this.parentRefs, this.rules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostnames != null && !this.hostnames.isEmpty()) {
            sb.append("hostnames:");
            sb.append(this.hostnames + ",");
        }
        if (this.parentRefs != null && !this.parentRefs.isEmpty()) {
            sb.append("parentRefs:");
            sb.append(this.parentRefs + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RulesNestedImpl<N>
    extends HTTPRouteRuleFluentImpl<HTTPRouteSpecFluent.RulesNested<N>>
    implements HTTPRouteSpecFluent.RulesNested<N>,
    Nested<N> {
        HTTPRouteRuleBuilder builder;
        Integer index;

        RulesNestedImpl(Integer index, HTTPRouteRule item) {
            this.index = index;
            this.builder = new HTTPRouteRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new HTTPRouteRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteSpecFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    class ParentRefsNestedImpl<N>
    extends ParentReferenceFluentImpl<HTTPRouteSpecFluent.ParentRefsNested<N>>
    implements HTTPRouteSpecFluent.ParentRefsNested<N>,
    Nested<N> {
        ParentReferenceBuilder builder;
        Integer index;

        ParentRefsNestedImpl(Integer index, ParentReference item) {
            this.index = index;
            this.builder = new ParentReferenceBuilder(this, item);
        }

        ParentRefsNestedImpl() {
            this.index = -1;
            this.builder = new ParentReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteSpecFluentImpl.this.setToParentRefs(this.index, this.builder.build());
        }

        @Override
        public N endParentRef() {
            return this.and();
        }
    }
}

