/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionRequest;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionRequestBuilder;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionRequestFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionResponse;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionResponseBuilder;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionResponseFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionReview;
import io.fabric8.kubernetes.api.model.v6_6.apiextensions.v1.ConversionReviewFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ConversionReviewFluentImpl<A extends ConversionReviewFluent<A>>
extends BaseFluent<A>
implements ConversionReviewFluent<A> {
    private String apiVersion;
    private String kind;
    private ConversionRequestBuilder request;
    private ConversionResponseBuilder response;
    private Map<String, Object> additionalProperties;

    public ConversionReviewFluentImpl() {
    }

    public ConversionReviewFluentImpl(ConversionReview instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withRequest(instance.getRequest());
        this.withResponse(instance.getResponse());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ConversionRequest getRequest() {
        return this.request != null ? this.request.build() : null;
    }

    @Override
    public ConversionRequest buildRequest() {
        return this.request != null ? this.request.build() : null;
    }

    @Override
    public A withRequest(ConversionRequest request) {
        this._visitables.get("request").remove(this.request);
        if (request != null) {
            this.request = new ConversionRequestBuilder(request);
            this._visitables.get("request").add(this.request);
        } else {
            this.request = null;
            this._visitables.get("request").remove(this.request);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null;
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> withNewRequest() {
        return new RequestNestedImpl();
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> withNewRequestLike(ConversionRequest item) {
        return new RequestNestedImpl(item);
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> editRequest() {
        return this.withNewRequestLike(this.getRequest());
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> editOrNewRequest() {
        return this.withNewRequestLike(this.getRequest() != null ? this.getRequest() : new ConversionRequestBuilder().build());
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> editOrNewRequestLike(ConversionRequest item) {
        return this.withNewRequestLike(this.getRequest() != null ? this.getRequest() : item);
    }

    @Override
    @Deprecated
    public ConversionResponse getResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public ConversionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public A withResponse(ConversionResponse response) {
        this._visitables.get("response").remove(this.response);
        if (response != null) {
            this.response = new ConversionResponseBuilder(response);
            this._visitables.get("response").add(this.response);
        } else {
            this.response = null;
            this._visitables.get("response").remove(this.response);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResponse() {
        return this.response != null;
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> withNewResponse() {
        return new ResponseNestedImpl();
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> withNewResponseLike(ConversionResponse item) {
        return new ResponseNestedImpl(item);
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> editResponse() {
        return this.withNewResponseLike(this.getResponse());
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : new ConversionResponseBuilder().build());
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> editOrNewResponseLike(ConversionResponse item) {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionReviewFluentImpl that = (ConversionReviewFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        if (this.response != null ? !this.response.equals(that.response) : that.response != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.request, this.response, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.response != null) {
            sb.append("response:");
            sb.append(this.response + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResponseNestedImpl<N>
    extends ConversionResponseFluentImpl<ConversionReviewFluent.ResponseNested<N>>
    implements ConversionReviewFluent.ResponseNested<N>,
    Nested<N> {
        ConversionResponseBuilder builder;

        ResponseNestedImpl(ConversionResponse item) {
            this.builder = new ConversionResponseBuilder(this, item);
        }

        ResponseNestedImpl() {
            this.builder = new ConversionResponseBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConversionReviewFluentImpl.this.withResponse(this.builder.build());
        }

        @Override
        public N endResponse() {
            return this.and();
        }
    }

    class RequestNestedImpl<N>
    extends ConversionRequestFluentImpl<ConversionReviewFluent.RequestNested<N>>
    implements ConversionReviewFluent.RequestNested<N>,
    Nested<N> {
        ConversionRequestBuilder builder;

        RequestNestedImpl(ConversionRequest item) {
            this.builder = new ConversionRequestBuilder(this, item);
        }

        RequestNestedImpl() {
            this.builder = new ConversionRequestBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConversionReviewFluentImpl.this.withRequest(this.builder.build());
        }

        @Override
        public N endRequest() {
            return this.and();
        }
    }
}

