/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.admission.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.admission.v1beta1.AdmissionRequest;
import io.fabric8.kubernetes.api.model.v6_6.admission.v1beta1.AdmissionResponse;
import io.fabric8.kubernetes.api.model.v6_6.admission.v1beta1.AdmissionResponseBuilder;
import io.fabric8.kubernetes.api.model.v6_6.admission.v1beta1.AdmissionResponseFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.admission.v1beta1.AdmissionReview;
import io.fabric8.kubernetes.api.model.v6_6.admission.v1beta1.AdmissionReviewFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AdmissionReviewFluentImpl<A extends AdmissionReviewFluent<A>>
extends BaseFluent<A>
implements AdmissionReviewFluent<A> {
    private String apiVersion;
    private String kind;
    private AdmissionRequest request;
    private AdmissionResponseBuilder response;
    private Map<String, Object> additionalProperties;

    public AdmissionReviewFluentImpl() {
    }

    public AdmissionReviewFluentImpl(AdmissionReview instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withRequest(instance.getRequest());
        this.withResponse(instance.getResponse());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public AdmissionRequest getRequest() {
        return this.request;
    }

    @Override
    public A withRequest(AdmissionRequest request) {
        this.request = request;
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null;
    }

    @Override
    @Deprecated
    public AdmissionResponse getResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public AdmissionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public A withResponse(AdmissionResponse response) {
        this._visitables.get("response").remove(this.response);
        if (response != null) {
            this.response = new AdmissionResponseBuilder(response);
            this._visitables.get("response").add(this.response);
        } else {
            this.response = null;
            this._visitables.get("response").remove(this.response);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResponse() {
        return this.response != null;
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> withNewResponse() {
        return new ResponseNestedImpl();
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> withNewResponseLike(AdmissionResponse item) {
        return new ResponseNestedImpl(item);
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editResponse() {
        return this.withNewResponseLike(this.getResponse());
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : new AdmissionResponseBuilder().build());
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponseLike(AdmissionResponse item) {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdmissionReviewFluentImpl that = (AdmissionReviewFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        if (this.response != null ? !this.response.equals(that.response) : that.response != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.request, this.response, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.response != null) {
            sb.append("response:");
            sb.append(this.response + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResponseNestedImpl<N>
    extends AdmissionResponseFluentImpl<AdmissionReviewFluent.ResponseNested<N>>
    implements AdmissionReviewFluent.ResponseNested<N>,
    Nested<N> {
        AdmissionResponseBuilder builder;

        ResponseNestedImpl(AdmissionResponse item) {
            this.builder = new AdmissionResponseBuilder(this, item);
        }

        ResponseNestedImpl() {
            this.builder = new AdmissionResponseBuilder(this);
        }

        @Override
        public N and() {
            return (N)AdmissionReviewFluentImpl.this.withResponse(this.builder.build());
        }

        @Override
        public N endResponse() {
            return this.and();
        }
    }
}

