/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_6.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_6.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.v6_6.TopologySpreadConstraintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TopologySpreadConstraintFluentImpl<A extends TopologySpreadConstraintFluent<A>>
extends BaseFluent<A>
implements TopologySpreadConstraintFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private List<String> matchLabelKeys = new ArrayList<String>();
    private Integer maxSkew;
    private Integer minDomains;
    private String nodeAffinityPolicy;
    private String nodeTaintsPolicy;
    private String topologyKey;
    private String whenUnsatisfiable;
    private Map<String, Object> additionalProperties;

    public TopologySpreadConstraintFluentImpl() {
    }

    public TopologySpreadConstraintFluentImpl(TopologySpreadConstraint instance) {
        this.withLabelSelector(instance.getLabelSelector());
        this.withMatchLabelKeys(instance.getMatchLabelKeys());
        this.withMaxSkew(instance.getMaxSkew());
        this.withMinDomains(instance.getMinDomains());
        this.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
        this.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
        this.withTopologyKey(instance.getTopologyKey());
        this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get("labelSelector").remove(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    public A addToMatchLabelKeys(Integer index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMatchLabelKeys(Integer index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMatchLabelKeys(String ... items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchLabelKeys(Collection<String> items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabelKeys(String ... items) {
        for (String item : items) {
            if (this.matchLabelKeys == null) continue;
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchLabelKeys(Collection<String> items) {
        for (String item : items) {
            if (this.matchLabelKeys == null) continue;
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMatchLabelKeys() {
        return this.matchLabelKeys;
    }

    @Override
    public String getMatchLabelKey(Integer index) {
        return this.matchLabelKeys.get(index);
    }

    @Override
    public String getFirstMatchLabelKey() {
        return this.matchLabelKeys.get(0);
    }

    @Override
    public String getLastMatchLabelKey() {
        return this.matchLabelKeys.get(this.matchLabelKeys.size() - 1);
    }

    @Override
    public String getMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatchLabelKeys(List<String> matchLabelKeys) {
        if (matchLabelKeys != null) {
            this.matchLabelKeys = new ArrayList<String>();
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        } else {
            this.matchLabelKeys = null;
        }
        return (A)this;
    }

    @Override
    public A withMatchLabelKeys(String ... matchLabelKeys) {
        if (this.matchLabelKeys != null) {
            this.matchLabelKeys.clear();
        }
        if (matchLabelKeys != null) {
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchLabelKeys() {
        return this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty();
    }

    @Override
    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    @Override
    public A withMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return (A)this;
    }

    @Override
    public Boolean hasMaxSkew() {
        return this.maxSkew != null;
    }

    @Override
    public Integer getMinDomains() {
        return this.minDomains;
    }

    @Override
    public A withMinDomains(Integer minDomains) {
        this.minDomains = minDomains;
        return (A)this;
    }

    @Override
    public Boolean hasMinDomains() {
        return this.minDomains != null;
    }

    @Override
    public String getNodeAffinityPolicy() {
        return this.nodeAffinityPolicy;
    }

    @Override
    public A withNodeAffinityPolicy(String nodeAffinityPolicy) {
        this.nodeAffinityPolicy = nodeAffinityPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasNodeAffinityPolicy() {
        return this.nodeAffinityPolicy != null;
    }

    @Override
    public String getNodeTaintsPolicy() {
        return this.nodeTaintsPolicy;
    }

    @Override
    public A withNodeTaintsPolicy(String nodeTaintsPolicy) {
        this.nodeTaintsPolicy = nodeTaintsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasNodeTaintsPolicy() {
        return this.nodeTaintsPolicy != null;
    }

    @Override
    public String getTopologyKey() {
        return this.topologyKey;
    }

    @Override
    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    @Override
    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    @Override
    public A withWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return (A)this;
    }

    @Override
    public Boolean hasWhenUnsatisfiable() {
        return this.whenUnsatisfiable != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologySpreadConstraintFluentImpl that = (TopologySpreadConstraintFluentImpl)o;
        if (this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null) {
            return false;
        }
        if (this.matchLabelKeys != null ? !this.matchLabelKeys.equals(that.matchLabelKeys) : that.matchLabelKeys != null) {
            return false;
        }
        if (this.maxSkew != null ? !this.maxSkew.equals(that.maxSkew) : that.maxSkew != null) {
            return false;
        }
        if (this.minDomains != null ? !this.minDomains.equals(that.minDomains) : that.minDomains != null) {
            return false;
        }
        if (this.nodeAffinityPolicy != null ? !this.nodeAffinityPolicy.equals(that.nodeAffinityPolicy) : that.nodeAffinityPolicy != null) {
            return false;
        }
        if (this.nodeTaintsPolicy != null ? !this.nodeTaintsPolicy.equals(that.nodeTaintsPolicy) : that.nodeTaintsPolicy != null) {
            return false;
        }
        if (this.topologyKey != null ? !this.topologyKey.equals(that.topologyKey) : that.topologyKey != null) {
            return false;
        }
        if (this.whenUnsatisfiable != null ? !this.whenUnsatisfiable.equals(that.whenUnsatisfiable) : that.whenUnsatisfiable != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labelSelector, this.matchLabelKeys, this.maxSkew, this.minDomains, this.nodeAffinityPolicy, this.nodeTaintsPolicy, this.topologyKey, this.whenUnsatisfiable, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector + ",");
        }
        if (this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty()) {
            sb.append("matchLabelKeys:");
            sb.append(this.matchLabelKeys + ",");
        }
        if (this.maxSkew != null) {
            sb.append("maxSkew:");
            sb.append(this.maxSkew + ",");
        }
        if (this.minDomains != null) {
            sb.append("minDomains:");
            sb.append(this.minDomains + ",");
        }
        if (this.nodeAffinityPolicy != null) {
            sb.append("nodeAffinityPolicy:");
            sb.append(this.nodeAffinityPolicy + ",");
        }
        if (this.nodeTaintsPolicy != null) {
            sb.append("nodeTaintsPolicy:");
            sb.append(this.nodeTaintsPolicy + ",");
        }
        if (this.topologyKey != null) {
            sb.append("topologyKey:");
            sb.append(this.topologyKey + ",");
        }
        if (this.whenUnsatisfiable != null) {
            sb.append("whenUnsatisfiable:");
            sb.append(this.whenUnsatisfiable + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class LabelSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<TopologySpreadConstraintFluent.LabelSelectorNested<N>>
    implements TopologySpreadConstraintFluent.LabelSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)TopologySpreadConstraintFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

