/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.ISCSIPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v6_6.ISCSIPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v6_6.SecretReference;
import io.fabric8.kubernetes.api.model.v6_6.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_6.SecretReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ISCSIPersistentVolumeSourceFluentImpl<A extends ISCSIPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements ISCSIPersistentVolumeSourceFluent<A> {
    private Boolean chapAuthDiscovery;
    private Boolean chapAuthSession;
    private String fsType;
    private String initiatorName;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private List<String> portals = new ArrayList<String>();
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;
    private String targetPortal;
    private Map<String, Object> additionalProperties;

    public ISCSIPersistentVolumeSourceFluentImpl() {
    }

    public ISCSIPersistentVolumeSourceFluentImpl(ISCSIPersistentVolumeSource instance) {
        this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
        this.withChapAuthSession(instance.getChapAuthSession());
        this.withFsType(instance.getFsType());
        this.withInitiatorName(instance.getInitiatorName());
        this.withIqn(instance.getIqn());
        this.withIscsiInterface(instance.getIscsiInterface());
        this.withLun(instance.getLun());
        this.withPortals(instance.getPortals());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withTargetPortal(instance.getTargetPortal());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    @Override
    public A withChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthDiscovery() {
        return this.chapAuthDiscovery != null;
    }

    @Override
    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    @Override
    public A withChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthSession() {
        return this.chapAuthSession != null;
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public A withInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
        return (A)this;
    }

    @Override
    public Boolean hasInitiatorName() {
        return this.initiatorName != null;
    }

    @Override
    public String getIqn() {
        return this.iqn;
    }

    @Override
    public A withIqn(String iqn) {
        this.iqn = iqn;
        return (A)this;
    }

    @Override
    public Boolean hasIqn() {
        return this.iqn != null;
    }

    @Override
    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    @Override
    public A withIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return (A)this;
    }

    @Override
    public Boolean hasIscsiInterface() {
        return this.iscsiInterface != null;
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    @Override
    public Boolean hasLun() {
        return this.lun != null;
    }

    @Override
    public A addToPortals(Integer index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPortals(Integer index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPortals(String ... items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPortals(Collection<String> items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortals(String ... items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPortals(Collection<String> items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPortals() {
        return this.portals;
    }

    @Override
    public String getPortal(Integer index) {
        return this.portals.get(index);
    }

    @Override
    public String getFirstPortal() {
        return this.portals.get(0);
    }

    @Override
    public String getLastPortal() {
        return this.portals.get(this.portals.size() - 1);
    }

    @Override
    public String getMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPortals(List<String> portals) {
        if (portals != null) {
            this.portals = new ArrayList<String>();
            for (String item : portals) {
                this.addToPortals(item);
            }
        } else {
            this.portals = null;
        }
        return (A)this;
    }

    @Override
    public A withPortals(String ... portals) {
        if (this.portals != null) {
            this.portals.clear();
        }
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPortals() {
        return this.portals != null && !this.portals.isEmpty();
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getTargetPortal() {
        return this.targetPortal;
    }

    @Override
    public A withTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return (A)this;
    }

    @Override
    public Boolean hasTargetPortal() {
        return this.targetPortal != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISCSIPersistentVolumeSourceFluentImpl that = (ISCSIPersistentVolumeSourceFluentImpl)o;
        if (this.chapAuthDiscovery != null ? !this.chapAuthDiscovery.equals(that.chapAuthDiscovery) : that.chapAuthDiscovery != null) {
            return false;
        }
        if (this.chapAuthSession != null ? !this.chapAuthSession.equals(that.chapAuthSession) : that.chapAuthSession != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.initiatorName != null ? !this.initiatorName.equals(that.initiatorName) : that.initiatorName != null) {
            return false;
        }
        if (this.iqn != null ? !this.iqn.equals(that.iqn) : that.iqn != null) {
            return false;
        }
        if (this.iscsiInterface != null ? !this.iscsiInterface.equals(that.iscsiInterface) : that.iscsiInterface != null) {
            return false;
        }
        if (this.lun != null ? !this.lun.equals(that.lun) : that.lun != null) {
            return false;
        }
        if (this.portals != null ? !this.portals.equals(that.portals) : that.portals != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.targetPortal != null ? !this.targetPortal.equals(that.targetPortal) : that.targetPortal != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.chapAuthDiscovery, this.chapAuthSession, this.fsType, this.initiatorName, this.iqn, this.iscsiInterface, this.lun, this.portals, this.readOnly, this.secretRef, this.targetPortal, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.chapAuthDiscovery != null) {
            sb.append("chapAuthDiscovery:");
            sb.append(this.chapAuthDiscovery + ",");
        }
        if (this.chapAuthSession != null) {
            sb.append("chapAuthSession:");
            sb.append(this.chapAuthSession + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.initiatorName != null) {
            sb.append("initiatorName:");
            sb.append(this.initiatorName + ",");
        }
        if (this.iqn != null) {
            sb.append("iqn:");
            sb.append(this.iqn + ",");
        }
        if (this.iscsiInterface != null) {
            sb.append("iscsiInterface:");
            sb.append(this.iscsiInterface + ",");
        }
        if (this.lun != null) {
            sb.append("lun:");
            sb.append(this.lun + ",");
        }
        if (this.portals != null && !this.portals.isEmpty()) {
            sb.append("portals:");
            sb.append(this.portals + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.targetPortal != null) {
            sb.append("targetPortal:");
            sb.append(this.targetPortal + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withChapAuthDiscovery() {
        return this.withChapAuthDiscovery(true);
    }

    @Override
    public A withChapAuthSession() {
        return this.withChapAuthSession(true);
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<ISCSIPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements ISCSIPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ISCSIPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

