/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.HTTPGetAction;
import io.fabric8.kubernetes.api.model.v6_6.HTTPGetActionFluent;
import io.fabric8.kubernetes.api.model.v6_6.HTTPHeader;
import io.fabric8.kubernetes.api.model.v6_6.HTTPHeaderBuilder;
import io.fabric8.kubernetes.api.model.v6_6.HTTPHeaderFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.IntOrString;
import io.fabric8.kubernetes.api.model.v6_6.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.v6_6.IntOrStringFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPGetActionFluentImpl<A extends HTTPGetActionFluent<A>>
extends BaseFluent<A>
implements HTTPGetActionFluent<A> {
    private String host;
    private ArrayList<HTTPHeaderBuilder> httpHeaders = new ArrayList();
    private String path;
    private IntOrStringBuilder port;
    private String scheme;
    private Map<String, Object> additionalProperties;

    public HTTPGetActionFluentImpl() {
    }

    public HTTPGetActionFluentImpl(HTTPGetAction instance) {
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public A addToHttpHeaders(Integer index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        this._visitables.get("httpHeaders").add(index >= 0 ? index.intValue() : this._visitables.get("httpHeaders").size(), builder);
        this.httpHeaders.add(index >= 0 ? index.intValue() : this.httpHeaders.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHttpHeaders(Integer index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this._visitables.get("httpHeaders").size()) {
            this._visitables.get("httpHeaders").add(builder);
        } else {
            this._visitables.get("httpHeaders").set(index, builder);
        }
        if (index < 0 || index >= this.httpHeaders.size()) {
            this.httpHeaders.add(builder);
        } else {
            this.httpHeaders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttpHeaders(HTTPHeader ... items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        Iterator<HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        Object visitables = this._visitables.get("httpHeaders");
        while (each.hasNext()) {
            HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPHeader> getHttpHeaders() {
        return this.httpHeaders != null ? HTTPGetActionFluentImpl.build(this.httpHeaders) : null;
    }

    @Override
    public List<HTTPHeader> buildHttpHeaders() {
        return this.httpHeaders != null ? HTTPGetActionFluentImpl.build(this.httpHeaders) : null;
    }

    @Override
    public HTTPHeader buildHttpHeader(Integer index) {
        return this.httpHeaders.get(index).build();
    }

    @Override
    public HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    @Override
    public HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    @Override
    public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get("httpHeaders").removeAll(this.httpHeaders);
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList();
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withHttpHeaders(HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
        }
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    @Override
    public A addNewHttpHeader(String name, String value) {
        return this.addToHttpHeaders(new HTTPHeader(name, value));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNestedImpl();
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
        return new HttpHeadersNestedImpl(-1, item);
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> setNewHttpHeaderLike(Integer index, HTTPHeader item) {
        return new HttpHeadersNestedImpl(index, item);
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editHttpHeader(Integer index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public IntOrString getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(IntOrString port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(Object value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNestedImpl(item);
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new IntOrStringBuilder().build());
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    @Override
    public Boolean hasScheme() {
        return this.scheme != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPGetActionFluentImpl that = (HTTPGetActionFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.httpHeaders != null ? !this.httpHeaders.equals(that.httpHeaders) : that.httpHeaders != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpHeaders != null && !this.httpHeaders.isEmpty()) {
            sb.append("httpHeaders:");
            sb.append(this.httpHeaders + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PortNestedImpl<N>
    extends IntOrStringFluentImpl<HTTPGetActionFluent.PortNested<N>>
    implements HTTPGetActionFluent.PortNested<N>,
    Nested<N> {
        IntOrStringBuilder builder;

        PortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    class HttpHeadersNestedImpl<N>
    extends HTTPHeaderFluentImpl<HTTPGetActionFluent.HttpHeadersNested<N>>
    implements HTTPGetActionFluent.HttpHeadersNested<N>,
    Nested<N> {
        HTTPHeaderBuilder builder;
        Integer index;

        HttpHeadersNestedImpl(Integer index, HTTPHeader item) {
            this.index = index;
            this.builder = new HTTPHeaderBuilder(this, item);
        }

        HttpHeadersNestedImpl() {
            this.index = -1;
            this.builder = new HTTPHeaderBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluentImpl.this.setToHttpHeaders(this.index, this.builder.build());
        }

        @Override
        public N endHttpHeader() {
            return this.and();
        }
    }
}

