/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_6.ContainerImage;
import io.fabric8.kubernetes.api.model.v6_6.ContainerImageFluent;
import io.fabric8.kubernetes.api.model.v6_6.ContainerImageFluentImpl;

public class ContainerImageBuilder
extends ContainerImageFluentImpl<ContainerImageBuilder>
implements VisitableBuilder<ContainerImage, ContainerImageBuilder> {
    ContainerImageFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerImageBuilder() {
        this(false);
    }

    public ContainerImageBuilder(Boolean validationEnabled) {
        this(new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance) {
        this(fluent, instance, false);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNames(instance.getNames());
        fluent.withSizeBytes(instance.getSizeBytes());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ContainerImageBuilder(ContainerImage instance) {
        this(instance, (Boolean)false);
    }

    public ContainerImageBuilder(ContainerImage instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerImage build() {
        ContainerImage buildable = new ContainerImage(this.fluent.getNames(), this.fluent.getSizeBytes());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

