/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.Audit;
import io.fabric8.openshift.api.model.config.v1.AuditCustomRule;
import io.fabric8.openshift.api.model.config.v1.AuditCustomRuleBuilder;
import io.fabric8.openshift.api.model.config.v1.AuditCustomRuleFluentImpl;
import io.fabric8.openshift.api.model.config.v1.AuditFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AuditFluentImpl<A extends AuditFluent<A>>
extends BaseFluent<A>
implements AuditFluent<A> {
    private ArrayList<AuditCustomRuleBuilder> customRules = new ArrayList();
    private String profile;
    private Map<String, Object> additionalProperties;

    public AuditFluentImpl() {
    }

    public AuditFluentImpl(Audit instance) {
        this.withCustomRules(instance.getCustomRules());
        this.withProfile(instance.getProfile());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToCustomRules(Integer index, AuditCustomRule item) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
        this._visitables.get("customRules").add(index >= 0 ? index.intValue() : this._visitables.get("customRules").size(), builder);
        this.customRules.add(index >= 0 ? index.intValue() : this.customRules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCustomRules(Integer index, AuditCustomRule item) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("customRules").size()) {
            this._visitables.get("customRules").add(builder);
        } else {
            this._visitables.get("customRules").set(index, builder);
        }
        if (index < 0 || index >= this.customRules.size()) {
            this.customRules.add(builder);
        } else {
            this.customRules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCustomRules(AuditCustomRule ... items) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").add(builder);
            this.customRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCustomRules(Collection<AuditCustomRule> items) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").add(builder);
            this.customRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomRules(AuditCustomRule ... items) {
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").remove(builder);
            if (this.customRules == null) continue;
            this.customRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCustomRules(Collection<AuditCustomRule> items) {
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").remove(builder);
            if (this.customRules == null) continue;
            this.customRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCustomRules(Predicate<AuditCustomRuleBuilder> predicate) {
        if (this.customRules == null) {
            return (A)this;
        }
        Iterator<AuditCustomRuleBuilder> each = this.customRules.iterator();
        Object visitables = this._visitables.get("customRules");
        while (each.hasNext()) {
            AuditCustomRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AuditCustomRule> getCustomRules() {
        return this.customRules != null ? AuditFluentImpl.build(this.customRules) : null;
    }

    @Override
    public List<AuditCustomRule> buildCustomRules() {
        return this.customRules != null ? AuditFluentImpl.build(this.customRules) : null;
    }

    @Override
    public AuditCustomRule buildCustomRule(Integer index) {
        return this.customRules.get(index).build();
    }

    @Override
    public AuditCustomRule buildFirstCustomRule() {
        return this.customRules.get(0).build();
    }

    @Override
    public AuditCustomRule buildLastCustomRule() {
        return this.customRules.get(this.customRules.size() - 1).build();
    }

    @Override
    public AuditCustomRule buildMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
        for (AuditCustomRuleBuilder item : this.customRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
        for (AuditCustomRuleBuilder item : this.customRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCustomRules(List<AuditCustomRule> customRules) {
        if (this.customRules != null) {
            this._visitables.get("customRules").removeAll(this.customRules);
        }
        if (customRules != null) {
            this.customRules = new ArrayList();
            for (AuditCustomRule item : customRules) {
                this.addToCustomRules(item);
            }
        } else {
            this.customRules = null;
        }
        return (A)this;
    }

    @Override
    public A withCustomRules(AuditCustomRule ... customRules) {
        if (this.customRules != null) {
            this.customRules.clear();
        }
        if (customRules != null) {
            for (AuditCustomRule item : customRules) {
                this.addToCustomRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCustomRules() {
        return this.customRules != null && !this.customRules.isEmpty();
    }

    @Override
    public A addNewCustomRule(String group, String profile) {
        return this.addToCustomRules(new AuditCustomRule(group, profile));
    }

    @Override
    public AuditFluent.CustomRulesNested<A> addNewCustomRule() {
        return new CustomRulesNestedImpl();
    }

    @Override
    public AuditFluent.CustomRulesNested<A> addNewCustomRuleLike(AuditCustomRule item) {
        return new CustomRulesNestedImpl(-1, item);
    }

    @Override
    public AuditFluent.CustomRulesNested<A> setNewCustomRuleLike(Integer index, AuditCustomRule item) {
        return new CustomRulesNestedImpl(index, item);
    }

    @Override
    public AuditFluent.CustomRulesNested<A> editCustomRule(Integer index) {
        if (this.customRules.size() <= index) {
            throw new RuntimeException("Can't edit customRules. Index exceeds size.");
        }
        return this.setNewCustomRuleLike(index, this.buildCustomRule(index));
    }

    @Override
    public AuditFluent.CustomRulesNested<A> editFirstCustomRule() {
        if (this.customRules.size() == 0) {
            throw new RuntimeException("Can't edit first customRules. The list is empty.");
        }
        return this.setNewCustomRuleLike(0, this.buildCustomRule(0));
    }

    @Override
    public AuditFluent.CustomRulesNested<A> editLastCustomRule() {
        int index = this.customRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customRules. The list is empty.");
        }
        return this.setNewCustomRuleLike(index, this.buildCustomRule(index));
    }

    @Override
    public AuditFluent.CustomRulesNested<A> editMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customRules.size(); ++i) {
            if (!predicate.test(this.customRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customRules. No match found.");
        }
        return this.setNewCustomRuleLike(index, this.buildCustomRule(index));
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditFluentImpl that = (AuditFluentImpl)o;
        if (this.customRules != null ? !this.customRules.equals(that.customRules) : that.customRules != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.customRules, this.profile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.customRules != null && !this.customRules.isEmpty()) {
            sb.append("customRules:");
            sb.append(this.customRules + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class CustomRulesNestedImpl<N>
    extends AuditCustomRuleFluentImpl<AuditFluent.CustomRulesNested<N>>
    implements AuditFluent.CustomRulesNested<N>,
    Nested<N> {
        AuditCustomRuleBuilder builder;
        Integer index;

        CustomRulesNestedImpl(Integer index, AuditCustomRule item) {
            this.index = index;
            this.builder = new AuditCustomRuleBuilder(this, item);
        }

        CustomRulesNestedImpl() {
            this.index = -1;
            this.builder = new AuditCustomRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuditFluentImpl.this.setToCustomRules(this.index, this.builder.build());
        }

        @Override
        public N endCustomRule() {
            return this.and();
        }
    }
}

