/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.StageInfo;
import io.fabric8.openshift.api.model.StageInfoFluent;
import io.fabric8.openshift.api.model.StepInfo;
import io.fabric8.openshift.api.model.StepInfoBuilder;
import io.fabric8.openshift.api.model.StepInfoFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StageInfoFluentImpl<A extends StageInfoFluent<A>>
extends BaseFluent<A>
implements StageInfoFluent<A> {
    private Long durationMilliseconds;
    private String name;
    private String startTime;
    private ArrayList<StepInfoBuilder> steps = new ArrayList();
    private Map<String, Object> additionalProperties;

    public StageInfoFluentImpl() {
    }

    public StageInfoFluentImpl(StageInfo instance) {
        this.withDurationMilliseconds(instance.getDurationMilliseconds());
        this.withName(instance.getName());
        this.withStartTime(instance.getStartTime());
        this.withSteps(instance.getSteps());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    @Override
    public A withDurationMilliseconds(Long durationMilliseconds) {
        this.durationMilliseconds = durationMilliseconds;
        return (A)this;
    }

    @Override
    public Boolean hasDurationMilliseconds() {
        return this.durationMilliseconds != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public A addToSteps(Integer index, StepInfo item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepInfoBuilder builder = new StepInfoBuilder(item);
        this._visitables.get("steps").add(index >= 0 ? index.intValue() : this._visitables.get("steps").size(), builder);
        this.steps.add(index >= 0 ? index.intValue() : this.steps.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSteps(Integer index, StepInfo item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepInfoBuilder builder = new StepInfoBuilder(item);
        if (index < 0 || index >= this._visitables.get("steps").size()) {
            this._visitables.get("steps").add(builder);
        } else {
            this._visitables.get("steps").set(index, builder);
        }
        if (index < 0 || index >= this.steps.size()) {
            this.steps.add(builder);
        } else {
            this.steps.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSteps(StepInfo ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<StepInfo> items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(StepInfo ... items) {
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<StepInfo> items) {
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSteps(Predicate<StepInfoBuilder> predicate) {
        if (this.steps == null) {
            return (A)this;
        }
        Iterator<StepInfoBuilder> each = this.steps.iterator();
        Object visitables = this._visitables.get("steps");
        while (each.hasNext()) {
            StepInfoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StepInfo> getSteps() {
        return this.steps != null ? StageInfoFluentImpl.build(this.steps) : null;
    }

    @Override
    public List<StepInfo> buildSteps() {
        return this.steps != null ? StageInfoFluentImpl.build(this.steps) : null;
    }

    @Override
    public StepInfo buildStep(Integer index) {
        return this.steps.get(index).build();
    }

    @Override
    public StepInfo buildFirstStep() {
        return this.steps.get(0).build();
    }

    @Override
    public StepInfo buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    @Override
    public StepInfo buildMatchingStep(Predicate<StepInfoBuilder> predicate) {
        for (StepInfoBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<StepInfoBuilder> predicate) {
        for (StepInfoBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<StepInfo> steps) {
        if (this.steps != null) {
            this._visitables.get("steps").removeAll(this.steps);
        }
        if (steps != null) {
            this.steps = new ArrayList();
            for (StepInfo item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)this;
    }

    @Override
    public A withSteps(StepInfo ... steps) {
        if (this.steps != null) {
            this.steps.clear();
        }
        if (steps != null) {
            for (StepInfo item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    @Override
    public A addNewStep(Long durationMilliseconds, String name, String startTime) {
        return this.addToSteps(new StepInfo(durationMilliseconds, name, startTime));
    }

    @Override
    public StageInfoFluent.StepsNested<A> addNewStep() {
        return new StepsNestedImpl();
    }

    @Override
    public StageInfoFluent.StepsNested<A> addNewStepLike(StepInfo item) {
        return new StepsNestedImpl(-1, item);
    }

    @Override
    public StageInfoFluent.StepsNested<A> setNewStepLike(Integer index, StepInfo item) {
        return new StepsNestedImpl(index, item);
    }

    @Override
    public StageInfoFluent.StepsNested<A> editStep(Integer index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public StageInfoFluent.StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    @Override
    public StageInfoFluent.StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public StageInfoFluent.StepsNested<A> editMatchingStep(Predicate<StepInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.test(this.steps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageInfoFluentImpl that = (StageInfoFluentImpl)o;
        if (this.durationMilliseconds != null ? !this.durationMilliseconds.equals(that.durationMilliseconds) : that.durationMilliseconds != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.durationMilliseconds, this.name, this.startTime, this.steps, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.durationMilliseconds != null) {
            sb.append("durationMilliseconds:");
            sb.append(this.durationMilliseconds + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class StepsNestedImpl<N>
    extends StepInfoFluentImpl<StageInfoFluent.StepsNested<N>>
    implements StageInfoFluent.StepsNested<N>,
    Nested<N> {
        StepInfoBuilder builder;
        Integer index;

        StepsNestedImpl(Integer index, StepInfo item) {
            this.index = index;
            this.builder = new StepInfoBuilder(this, item);
        }

        StepsNestedImpl() {
            this.index = -1;
            this.builder = new StepInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)StageInfoFluentImpl.this.setToSteps(this.index, this.builder.build());
        }

        @Override
        public N endStep() {
            return this.and();
        }
    }
}

