/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.InhibitRule;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.Matcher;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.MatcherBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.MatcherFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class InhibitRuleFluent<A extends InhibitRuleFluent<A>>
extends BaseFluent<A> {
    private List<String> equal = new ArrayList<String>();
    private ArrayList<MatcherBuilder> sourceMatch = new ArrayList();
    private ArrayList<MatcherBuilder> targetMatch = new ArrayList();
    private Map<String, Object> additionalProperties;

    public InhibitRuleFluent() {
    }

    public InhibitRuleFluent(InhibitRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(InhibitRule instance) {
        InhibitRule inhibitRule = instance = instance != null ? instance : new InhibitRule();
        if (instance != null) {
            this.withEqual(instance.getEqual());
            this.withSourceMatch(instance.getSourceMatch());
            this.withTargetMatch(instance.getTargetMatch());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEqual(int index, String item) {
        if (this.equal == null) {
            this.equal = new ArrayList<String>();
        }
        this.equal.add(index, item);
        return (A)this;
    }

    public A setToEqual(int index, String item) {
        if (this.equal == null) {
            this.equal = new ArrayList<String>();
        }
        this.equal.set(index, item);
        return (A)this;
    }

    public A addToEqual(String ... items) {
        if (this.equal == null) {
            this.equal = new ArrayList<String>();
        }
        for (String item : items) {
            this.equal.add(item);
        }
        return (A)this;
    }

    public A addAllToEqual(Collection<String> items) {
        if (this.equal == null) {
            this.equal = new ArrayList<String>();
        }
        for (String item : items) {
            this.equal.add(item);
        }
        return (A)this;
    }

    public A removeFromEqual(String ... items) {
        if (this.equal == null) {
            return (A)this;
        }
        for (String item : items) {
            this.equal.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEqual(Collection<String> items) {
        if (this.equal == null) {
            return (A)this;
        }
        for (String item : items) {
            this.equal.remove(item);
        }
        return (A)this;
    }

    public List<String> getEqual() {
        return this.equal;
    }

    public String getEqual(int index) {
        return this.equal.get(index);
    }

    public String getFirstEqual() {
        return this.equal.get(0);
    }

    public String getLastEqual() {
        return this.equal.get(this.equal.size() - 1);
    }

    public String getMatchingEqual(Predicate<String> predicate) {
        for (String item : this.equal) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEqual(Predicate<String> predicate) {
        for (String item : this.equal) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEqual(List<String> equal) {
        if (equal != null) {
            this.equal = new ArrayList<String>();
            for (String item : equal) {
                this.addToEqual(item);
            }
        } else {
            this.equal = null;
        }
        return (A)this;
    }

    public A withEqual(String ... equal) {
        if (this.equal != null) {
            this.equal.clear();
            this._visitables.remove("equal");
        }
        if (equal != null) {
            for (String item : equal) {
                this.addToEqual(item);
            }
        }
        return (A)this;
    }

    public boolean hasEqual() {
        return this.equal != null && !this.equal.isEmpty();
    }

    public A addToSourceMatch(int index, Matcher item) {
        if (this.sourceMatch == null) {
            this.sourceMatch = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= this.sourceMatch.size()) {
            this._visitables.get("sourceMatch").add(builder);
            this.sourceMatch.add(builder);
        } else {
            this._visitables.get("sourceMatch").add(index, builder);
            this.sourceMatch.add(index, builder);
        }
        return (A)this;
    }

    public A setToSourceMatch(int index, Matcher item) {
        if (this.sourceMatch == null) {
            this.sourceMatch = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= this.sourceMatch.size()) {
            this._visitables.get("sourceMatch").add(builder);
            this.sourceMatch.add(builder);
        } else {
            this._visitables.get("sourceMatch").set(index, builder);
            this.sourceMatch.set(index, builder);
        }
        return (A)this;
    }

    public A addToSourceMatch(Matcher ... items) {
        if (this.sourceMatch == null) {
            this.sourceMatch = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("sourceMatch").add(builder);
            this.sourceMatch.add(builder);
        }
        return (A)this;
    }

    public A addAllToSourceMatch(Collection<Matcher> items) {
        if (this.sourceMatch == null) {
            this.sourceMatch = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("sourceMatch").add(builder);
            this.sourceMatch.add(builder);
        }
        return (A)this;
    }

    public A removeFromSourceMatch(Matcher ... items) {
        if (this.sourceMatch == null) {
            return (A)this;
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("sourceMatch").remove(builder);
            this.sourceMatch.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSourceMatch(Collection<Matcher> items) {
        if (this.sourceMatch == null) {
            return (A)this;
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("sourceMatch").remove(builder);
            this.sourceMatch.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSourceMatch(Predicate<MatcherBuilder> predicate) {
        if (this.sourceMatch == null) {
            return (A)this;
        }
        Iterator<MatcherBuilder> each = this.sourceMatch.iterator();
        Object visitables = this._visitables.get("sourceMatch");
        while (each.hasNext()) {
            MatcherBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Matcher> buildSourceMatch() {
        return this.sourceMatch != null ? InhibitRuleFluent.build(this.sourceMatch) : null;
    }

    public Matcher buildSourceMatch(int index) {
        return this.sourceMatch.get(index).build();
    }

    public Matcher buildFirstSourceMatch() {
        return this.sourceMatch.get(0).build();
    }

    public Matcher buildLastSourceMatch() {
        return this.sourceMatch.get(this.sourceMatch.size() - 1).build();
    }

    public Matcher buildMatchingSourceMatch(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.sourceMatch) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSourceMatch(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.sourceMatch) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSourceMatch(List<Matcher> sourceMatch) {
        if (this.sourceMatch != null) {
            this._visitables.get("sourceMatch").clear();
        }
        if (sourceMatch != null) {
            this.sourceMatch = new ArrayList();
            for (Matcher item : sourceMatch) {
                this.addToSourceMatch(item);
            }
        } else {
            this.sourceMatch = null;
        }
        return (A)this;
    }

    public A withSourceMatch(Matcher ... sourceMatch) {
        if (this.sourceMatch != null) {
            this.sourceMatch.clear();
            this._visitables.remove("sourceMatch");
        }
        if (sourceMatch != null) {
            for (Matcher item : sourceMatch) {
                this.addToSourceMatch(item);
            }
        }
        return (A)this;
    }

    public boolean hasSourceMatch() {
        return this.sourceMatch != null && !this.sourceMatch.isEmpty();
    }

    public A addNewSourceMatch(String matchType, String name, Boolean regex, String value) {
        return this.addToSourceMatch(new Matcher(matchType, name, regex, value));
    }

    public SourceMatchNested<A> addNewSourceMatch() {
        return new SourceMatchNested(-1, null);
    }

    public SourceMatchNested<A> addNewSourceMatchLike(Matcher item) {
        return new SourceMatchNested(-1, item);
    }

    public SourceMatchNested<A> setNewSourceMatchLike(int index, Matcher item) {
        return new SourceMatchNested(index, item);
    }

    public SourceMatchNested<A> editSourceMatch(int index) {
        if (this.sourceMatch.size() <= index) {
            throw new RuntimeException("Can't edit sourceMatch. Index exceeds size.");
        }
        return this.setNewSourceMatchLike(index, this.buildSourceMatch(index));
    }

    public SourceMatchNested<A> editFirstSourceMatch() {
        if (this.sourceMatch.size() == 0) {
            throw new RuntimeException("Can't edit first sourceMatch. The list is empty.");
        }
        return this.setNewSourceMatchLike(0, this.buildSourceMatch(0));
    }

    public SourceMatchNested<A> editLastSourceMatch() {
        int index = this.sourceMatch.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sourceMatch. The list is empty.");
        }
        return this.setNewSourceMatchLike(index, this.buildSourceMatch(index));
    }

    public SourceMatchNested<A> editMatchingSourceMatch(Predicate<MatcherBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sourceMatch.size(); ++i) {
            if (!predicate.test(this.sourceMatch.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sourceMatch. No match found.");
        }
        return this.setNewSourceMatchLike(index, this.buildSourceMatch(index));
    }

    public A addToTargetMatch(int index, Matcher item) {
        if (this.targetMatch == null) {
            this.targetMatch = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= this.targetMatch.size()) {
            this._visitables.get("targetMatch").add(builder);
            this.targetMatch.add(builder);
        } else {
            this._visitables.get("targetMatch").add(index, builder);
            this.targetMatch.add(index, builder);
        }
        return (A)this;
    }

    public A setToTargetMatch(int index, Matcher item) {
        if (this.targetMatch == null) {
            this.targetMatch = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= this.targetMatch.size()) {
            this._visitables.get("targetMatch").add(builder);
            this.targetMatch.add(builder);
        } else {
            this._visitables.get("targetMatch").set(index, builder);
            this.targetMatch.set(index, builder);
        }
        return (A)this;
    }

    public A addToTargetMatch(Matcher ... items) {
        if (this.targetMatch == null) {
            this.targetMatch = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("targetMatch").add(builder);
            this.targetMatch.add(builder);
        }
        return (A)this;
    }

    public A addAllToTargetMatch(Collection<Matcher> items) {
        if (this.targetMatch == null) {
            this.targetMatch = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("targetMatch").add(builder);
            this.targetMatch.add(builder);
        }
        return (A)this;
    }

    public A removeFromTargetMatch(Matcher ... items) {
        if (this.targetMatch == null) {
            return (A)this;
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("targetMatch").remove(builder);
            this.targetMatch.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTargetMatch(Collection<Matcher> items) {
        if (this.targetMatch == null) {
            return (A)this;
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("targetMatch").remove(builder);
            this.targetMatch.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTargetMatch(Predicate<MatcherBuilder> predicate) {
        if (this.targetMatch == null) {
            return (A)this;
        }
        Iterator<MatcherBuilder> each = this.targetMatch.iterator();
        Object visitables = this._visitables.get("targetMatch");
        while (each.hasNext()) {
            MatcherBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Matcher> buildTargetMatch() {
        return this.targetMatch != null ? InhibitRuleFluent.build(this.targetMatch) : null;
    }

    public Matcher buildTargetMatch(int index) {
        return this.targetMatch.get(index).build();
    }

    public Matcher buildFirstTargetMatch() {
        return this.targetMatch.get(0).build();
    }

    public Matcher buildLastTargetMatch() {
        return this.targetMatch.get(this.targetMatch.size() - 1).build();
    }

    public Matcher buildMatchingTargetMatch(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.targetMatch) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTargetMatch(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.targetMatch) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetMatch(List<Matcher> targetMatch) {
        if (this.targetMatch != null) {
            this._visitables.get("targetMatch").clear();
        }
        if (targetMatch != null) {
            this.targetMatch = new ArrayList();
            for (Matcher item : targetMatch) {
                this.addToTargetMatch(item);
            }
        } else {
            this.targetMatch = null;
        }
        return (A)this;
    }

    public A withTargetMatch(Matcher ... targetMatch) {
        if (this.targetMatch != null) {
            this.targetMatch.clear();
            this._visitables.remove("targetMatch");
        }
        if (targetMatch != null) {
            for (Matcher item : targetMatch) {
                this.addToTargetMatch(item);
            }
        }
        return (A)this;
    }

    public boolean hasTargetMatch() {
        return this.targetMatch != null && !this.targetMatch.isEmpty();
    }

    public A addNewTargetMatch(String matchType, String name, Boolean regex, String value) {
        return this.addToTargetMatch(new Matcher(matchType, name, regex, value));
    }

    public TargetMatchNested<A> addNewTargetMatch() {
        return new TargetMatchNested(-1, null);
    }

    public TargetMatchNested<A> addNewTargetMatchLike(Matcher item) {
        return new TargetMatchNested(-1, item);
    }

    public TargetMatchNested<A> setNewTargetMatchLike(int index, Matcher item) {
        return new TargetMatchNested(index, item);
    }

    public TargetMatchNested<A> editTargetMatch(int index) {
        if (this.targetMatch.size() <= index) {
            throw new RuntimeException("Can't edit targetMatch. Index exceeds size.");
        }
        return this.setNewTargetMatchLike(index, this.buildTargetMatch(index));
    }

    public TargetMatchNested<A> editFirstTargetMatch() {
        if (this.targetMatch.size() == 0) {
            throw new RuntimeException("Can't edit first targetMatch. The list is empty.");
        }
        return this.setNewTargetMatchLike(0, this.buildTargetMatch(0));
    }

    public TargetMatchNested<A> editLastTargetMatch() {
        int index = this.targetMatch.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last targetMatch. The list is empty.");
        }
        return this.setNewTargetMatchLike(index, this.buildTargetMatch(index));
    }

    public TargetMatchNested<A> editMatchingTargetMatch(Predicate<MatcherBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.targetMatch.size(); ++i) {
            if (!predicate.test(this.targetMatch.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching targetMatch. No match found.");
        }
        return this.setNewTargetMatchLike(index, this.buildTargetMatch(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InhibitRuleFluent that = (InhibitRuleFluent)o;
        if (!Objects.equals(this.equal, that.equal)) {
            return false;
        }
        if (!Objects.equals(this.sourceMatch, that.sourceMatch)) {
            return false;
        }
        if (!Objects.equals(this.targetMatch, that.targetMatch)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.equal, this.sourceMatch, this.targetMatch, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.equal != null && !this.equal.isEmpty()) {
            sb.append("equal:");
            sb.append(this.equal + ",");
        }
        if (this.sourceMatch != null && !this.sourceMatch.isEmpty()) {
            sb.append("sourceMatch:");
            sb.append(this.sourceMatch + ",");
        }
        if (this.targetMatch != null && !this.targetMatch.isEmpty()) {
            sb.append("targetMatch:");
            sb.append(this.targetMatch + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetMatchNested<N>
    extends MatcherFluent<TargetMatchNested<N>>
    implements Nested<N> {
        MatcherBuilder builder;
        int index;

        TargetMatchNested(int index, Matcher item) {
            this.index = index;
            this.builder = new MatcherBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InhibitRuleFluent.this.setToTargetMatch(this.index, this.builder.build());
        }

        public N endTargetMatch() {
            return this.and();
        }
    }

    public class SourceMatchNested<N>
    extends MatcherFluent<SourceMatchNested<N>>
    implements Nested<N> {
        MatcherBuilder builder;
        int index;

        SourceMatchNested(int index, Matcher item) {
            this.index = index;
            this.builder = new MatcherBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InhibitRuleFluent.this.setToSourceMatch(this.index, this.builder.build());
        }

        public N endSourceMatch() {
            return this.and();
        }
    }
}

