/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.GlobalSMTPConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.HostPort;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.HostPortBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.HostPortFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GlobalSMTPConfigFluent<A extends GlobalSMTPConfigFluent<A>>
extends BaseFluent<A> {
    private String authIdentity;
    private SecretKeySelector authPassword;
    private SecretKeySelector authSecret;
    private String authUsername;
    private String from;
    private String hello;
    private Boolean requireTLS;
    private HostPortBuilder smartHost;
    private Map<String, Object> additionalProperties;

    public GlobalSMTPConfigFluent() {
    }

    public GlobalSMTPConfigFluent(GlobalSMTPConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GlobalSMTPConfig instance) {
        GlobalSMTPConfig globalSMTPConfig = instance = instance != null ? instance : new GlobalSMTPConfig();
        if (instance != null) {
            this.withAuthIdentity(instance.getAuthIdentity());
            this.withAuthPassword(instance.getAuthPassword());
            this.withAuthSecret(instance.getAuthSecret());
            this.withAuthUsername(instance.getAuthUsername());
            this.withFrom(instance.getFrom());
            this.withHello(instance.getHello());
            this.withRequireTLS(instance.getRequireTLS());
            this.withSmartHost(instance.getSmartHost());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAuthIdentity() {
        return this.authIdentity;
    }

    public A withAuthIdentity(String authIdentity) {
        this.authIdentity = authIdentity;
        return (A)this;
    }

    public boolean hasAuthIdentity() {
        return this.authIdentity != null;
    }

    public SecretKeySelector getAuthPassword() {
        return this.authPassword;
    }

    public A withAuthPassword(SecretKeySelector authPassword) {
        this.authPassword = authPassword;
        return (A)this;
    }

    public boolean hasAuthPassword() {
        return this.authPassword != null;
    }

    public A withNewAuthPassword(String key, String name, Boolean optional) {
        return this.withAuthPassword(new SecretKeySelector(key, name, optional));
    }

    public SecretKeySelector getAuthSecret() {
        return this.authSecret;
    }

    public A withAuthSecret(SecretKeySelector authSecret) {
        this.authSecret = authSecret;
        return (A)this;
    }

    public boolean hasAuthSecret() {
        return this.authSecret != null;
    }

    public A withNewAuthSecret(String key, String name, Boolean optional) {
        return this.withAuthSecret(new SecretKeySelector(key, name, optional));
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public A withAuthUsername(String authUsername) {
        this.authUsername = authUsername;
        return (A)this;
    }

    public boolean hasAuthUsername() {
        return this.authUsername != null;
    }

    public String getFrom() {
        return this.from;
    }

    public A withFrom(String from) {
        this.from = from;
        return (A)this;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public String getHello() {
        return this.hello;
    }

    public A withHello(String hello) {
        this.hello = hello;
        return (A)this;
    }

    public boolean hasHello() {
        return this.hello != null;
    }

    public Boolean getRequireTLS() {
        return this.requireTLS;
    }

    public A withRequireTLS(Boolean requireTLS) {
        this.requireTLS = requireTLS;
        return (A)this;
    }

    public boolean hasRequireTLS() {
        return this.requireTLS != null;
    }

    public HostPort buildSmartHost() {
        return this.smartHost != null ? this.smartHost.build() : null;
    }

    public A withSmartHost(HostPort smartHost) {
        this._visitables.remove("smartHost");
        if (smartHost != null) {
            this.smartHost = new HostPortBuilder(smartHost);
            this._visitables.get("smartHost").add(this.smartHost);
        } else {
            this.smartHost = null;
            this._visitables.get("smartHost").remove(this.smartHost);
        }
        return (A)this;
    }

    public boolean hasSmartHost() {
        return this.smartHost != null;
    }

    public A withNewSmartHost(String host, String port) {
        return this.withSmartHost(new HostPort(host, port));
    }

    public SmartHostNested<A> withNewSmartHost() {
        return new SmartHostNested(null);
    }

    public SmartHostNested<A> withNewSmartHostLike(HostPort item) {
        return new SmartHostNested(item);
    }

    public SmartHostNested<A> editSmartHost() {
        return this.withNewSmartHostLike(Optional.ofNullable(this.buildSmartHost()).orElse(null));
    }

    public SmartHostNested<A> editOrNewSmartHost() {
        return this.withNewSmartHostLike(Optional.ofNullable(this.buildSmartHost()).orElse(new HostPortBuilder().build()));
    }

    public SmartHostNested<A> editOrNewSmartHostLike(HostPort item) {
        return this.withNewSmartHostLike(Optional.ofNullable(this.buildSmartHost()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GlobalSMTPConfigFluent that = (GlobalSMTPConfigFluent)o;
        if (!Objects.equals(this.authIdentity, that.authIdentity)) {
            return false;
        }
        if (!Objects.equals(this.authPassword, that.authPassword)) {
            return false;
        }
        if (!Objects.equals(this.authSecret, that.authSecret)) {
            return false;
        }
        if (!Objects.equals(this.authUsername, that.authUsername)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.hello, that.hello)) {
            return false;
        }
        if (!Objects.equals(this.requireTLS, that.requireTLS)) {
            return false;
        }
        if (!Objects.equals(this.smartHost, that.smartHost)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authIdentity, this.authPassword, this.authSecret, this.authUsername, this.from, this.hello, this.requireTLS, this.smartHost, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authIdentity != null) {
            sb.append("authIdentity:");
            sb.append(this.authIdentity + ",");
        }
        if (this.authPassword != null) {
            sb.append("authPassword:");
            sb.append(this.authPassword + ",");
        }
        if (this.authSecret != null) {
            sb.append("authSecret:");
            sb.append(this.authSecret + ",");
        }
        if (this.authUsername != null) {
            sb.append("authUsername:");
            sb.append(this.authUsername + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.hello != null) {
            sb.append("hello:");
            sb.append(this.hello + ",");
        }
        if (this.requireTLS != null) {
            sb.append("requireTLS:");
            sb.append(this.requireTLS + ",");
        }
        if (this.smartHost != null) {
            sb.append("smartHost:");
            sb.append(this.smartHost + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withRequireTLS() {
        return this.withRequireTLS(true);
    }

    public class SmartHostNested<N>
    extends HostPortFluent<SmartHostNested<N>>
    implements Nested<N> {
        HostPortBuilder builder;

        SmartHostNested(HostPort item) {
            this.builder = new HostPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GlobalSMTPConfigFluent.this.withSmartHost(this.builder.build());
        }

        public N endSmartHost() {
            return this.and();
        }
    }
}

