/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.APIServerConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.Authorization;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.AuthorizationBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.AuthorizationFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.TLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class APIServerConfigFluent<A extends APIServerConfigFluent<A>>
extends BaseFluent<A> {
    private AuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private String host;
    private TLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public APIServerConfigFluent() {
    }

    public APIServerConfigFluent(APIServerConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIServerConfig instance) {
        APIServerConfig aPIServerConfig = instance = instance != null ? instance : new APIServerConfig();
        if (instance != null) {
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerToken(instance.getBearerToken());
            this.withBearerTokenFile(instance.getBearerTokenFile());
            this.withHost(instance.getHost());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Authorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(Authorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new AuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new AuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove("basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get("basicAuth").remove(this.basicAuth);
        }
        return (A)this;
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public A withBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return (A)this;
    }

    public boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return (A)this;
    }

    public boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServerConfigFluent that = (APIServerConfigFluent)o;
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.basicAuth, that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.bearerToken, that.bearerToken)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenFile, that.bearerTokenFile)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authorization, this.basicAuth, this.bearerToken, this.bearerTokenFile, this.host, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(this.basicAuth + ",");
        }
        if (this.bearerToken != null) {
            sb.append("bearerToken:");
            sb.append(this.bearerToken + ",");
        }
        if (this.bearerTokenFile != null) {
            sb.append("bearerTokenFile:");
            sb.append(this.bearerTokenFile + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIServerConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIServerConfigFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends AuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        AuthorizationBuilder builder;

        AuthorizationNested(Authorization item) {
            this.builder = new AuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIServerConfigFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

