/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_13.Quantity;
import io.fabric8.openshift.api.model.v6_13.machineconfig.v1.ContainerRuntimeConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ContainerRuntimeConfigurationFluent<A extends ContainerRuntimeConfigurationFluent<A>>
extends BaseFluent<A> {
    private String defaultRuntime;
    private String logLevel;
    private Quantity logSizeMax;
    private Quantity overlaySize;
    private Long pidsLimit;
    private Map<String, Object> additionalProperties;

    public ContainerRuntimeConfigurationFluent() {
    }

    public ContainerRuntimeConfigurationFluent(ContainerRuntimeConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerRuntimeConfiguration instance) {
        ContainerRuntimeConfiguration containerRuntimeConfiguration = instance = instance != null ? instance : new ContainerRuntimeConfiguration();
        if (instance != null) {
            this.withDefaultRuntime(instance.getDefaultRuntime());
            this.withLogLevel(instance.getLogLevel());
            this.withLogSizeMax(instance.getLogSizeMax());
            this.withOverlaySize(instance.getOverlaySize());
            this.withPidsLimit(instance.getPidsLimit());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDefaultRuntime() {
        return this.defaultRuntime;
    }

    public A withDefaultRuntime(String defaultRuntime) {
        this.defaultRuntime = defaultRuntime;
        return (A)this;
    }

    public boolean hasDefaultRuntime() {
        return this.defaultRuntime != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Quantity getLogSizeMax() {
        return this.logSizeMax;
    }

    public A withLogSizeMax(Quantity logSizeMax) {
        this.logSizeMax = logSizeMax;
        return (A)this;
    }

    public boolean hasLogSizeMax() {
        return this.logSizeMax != null;
    }

    public A withNewLogSizeMax(String amount, String format) {
        return this.withLogSizeMax(new Quantity(amount, format));
    }

    public A withNewLogSizeMax(String amount) {
        return this.withLogSizeMax(new Quantity(amount));
    }

    public Quantity getOverlaySize() {
        return this.overlaySize;
    }

    public A withOverlaySize(Quantity overlaySize) {
        this.overlaySize = overlaySize;
        return (A)this;
    }

    public boolean hasOverlaySize() {
        return this.overlaySize != null;
    }

    public A withNewOverlaySize(String amount, String format) {
        return this.withOverlaySize(new Quantity(amount, format));
    }

    public A withNewOverlaySize(String amount) {
        return this.withOverlaySize(new Quantity(amount));
    }

    public Long getPidsLimit() {
        return this.pidsLimit;
    }

    public A withPidsLimit(Long pidsLimit) {
        this.pidsLimit = pidsLimit;
        return (A)this;
    }

    public boolean hasPidsLimit() {
        return this.pidsLimit != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerRuntimeConfigurationFluent that = (ContainerRuntimeConfigurationFluent)o;
        if (!Objects.equals(this.defaultRuntime, that.defaultRuntime)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.logSizeMax, that.logSizeMax)) {
            return false;
        }
        if (!Objects.equals(this.overlaySize, that.overlaySize)) {
            return false;
        }
        if (!Objects.equals(this.pidsLimit, that.pidsLimit)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultRuntime, this.logLevel, this.logSizeMax, this.overlaySize, this.pidsLimit, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultRuntime != null) {
            sb.append("defaultRuntime:");
            sb.append(this.defaultRuntime + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.logSizeMax != null) {
            sb.append("logSizeMax:");
            sb.append(this.logSizeMax + ",");
        }
        if (this.overlaySize != null) {
            sb.append("overlaySize:");
            sb.append(this.overlaySize + ",");
        }
        if (this.pidsLimit != null) {
            sb.append("pidsLimit:");
            sb.append(this.pidsLimit + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

