/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1.BootVolume;
import io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1.BootVolumeBuilder;
import io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1.BootVolumeFluent;
import io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1.DedicatedHost;
import io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1.DedicatedHostBuilder;
import io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1.DedicatedHostFluent;
import io.fabric8.openshift.api.model.v6_13.installer.ibmcloud.v1.MachinePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private BootVolumeBuilder bootVolume;
    private ArrayList<DedicatedHostBuilder> dedicatedHosts = new ArrayList();
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withBootVolume(instance.getBootVolume());
            this.withDedicatedHosts(instance.getDedicatedHosts());
            this.withType(instance.getType());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BootVolume buildBootVolume() {
        return this.bootVolume != null ? this.bootVolume.build() : null;
    }

    public A withBootVolume(BootVolume bootVolume) {
        this._visitables.remove("bootVolume");
        if (bootVolume != null) {
            this.bootVolume = new BootVolumeBuilder(bootVolume);
            this._visitables.get("bootVolume").add(this.bootVolume);
        } else {
            this.bootVolume = null;
            this._visitables.get("bootVolume").remove(this.bootVolume);
        }
        return (A)this;
    }

    public boolean hasBootVolume() {
        return this.bootVolume != null;
    }

    public A withNewBootVolume(String encryptionKey) {
        return this.withBootVolume(new BootVolume(encryptionKey));
    }

    public BootVolumeNested<A> withNewBootVolume() {
        return new BootVolumeNested(null);
    }

    public BootVolumeNested<A> withNewBootVolumeLike(BootVolume item) {
        return new BootVolumeNested(item);
    }

    public BootVolumeNested<A> editBootVolume() {
        return this.withNewBootVolumeLike(Optional.ofNullable(this.buildBootVolume()).orElse(null));
    }

    public BootVolumeNested<A> editOrNewBootVolume() {
        return this.withNewBootVolumeLike(Optional.ofNullable(this.buildBootVolume()).orElse(new BootVolumeBuilder().build()));
    }

    public BootVolumeNested<A> editOrNewBootVolumeLike(BootVolume item) {
        return this.withNewBootVolumeLike(Optional.ofNullable(this.buildBootVolume()).orElse(item));
    }

    public A addToDedicatedHosts(int index, DedicatedHost item) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList();
        }
        DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
        if (index < 0 || index >= this.dedicatedHosts.size()) {
            this._visitables.get("dedicatedHosts").add(builder);
            this.dedicatedHosts.add(builder);
        } else {
            this._visitables.get("dedicatedHosts").add(index, builder);
            this.dedicatedHosts.add(index, builder);
        }
        return (A)this;
    }

    public A setToDedicatedHosts(int index, DedicatedHost item) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList();
        }
        DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
        if (index < 0 || index >= this.dedicatedHosts.size()) {
            this._visitables.get("dedicatedHosts").add(builder);
            this.dedicatedHosts.add(builder);
        } else {
            this._visitables.get("dedicatedHosts").set(index, builder);
            this.dedicatedHosts.set(index, builder);
        }
        return (A)this;
    }

    public A addToDedicatedHosts(DedicatedHost ... items) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList();
        }
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").add(builder);
            this.dedicatedHosts.add(builder);
        }
        return (A)this;
    }

    public A addAllToDedicatedHosts(Collection<DedicatedHost> items) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList();
        }
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").add(builder);
            this.dedicatedHosts.add(builder);
        }
        return (A)this;
    }

    public A removeFromDedicatedHosts(DedicatedHost ... items) {
        if (this.dedicatedHosts == null) {
            return (A)this;
        }
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").remove(builder);
            this.dedicatedHosts.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDedicatedHosts(Collection<DedicatedHost> items) {
        if (this.dedicatedHosts == null) {
            return (A)this;
        }
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").remove(builder);
            this.dedicatedHosts.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDedicatedHosts(Predicate<DedicatedHostBuilder> predicate) {
        if (this.dedicatedHosts == null) {
            return (A)this;
        }
        Iterator<DedicatedHostBuilder> each = this.dedicatedHosts.iterator();
        Object visitables = this._visitables.get("dedicatedHosts");
        while (each.hasNext()) {
            DedicatedHostBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DedicatedHost> buildDedicatedHosts() {
        return this.dedicatedHosts != null ? MachinePoolFluent.build(this.dedicatedHosts) : null;
    }

    public DedicatedHost buildDedicatedHost(int index) {
        return this.dedicatedHosts.get(index).build();
    }

    public DedicatedHost buildFirstDedicatedHost() {
        return this.dedicatedHosts.get(0).build();
    }

    public DedicatedHost buildLastDedicatedHost() {
        return this.dedicatedHosts.get(this.dedicatedHosts.size() - 1).build();
    }

    public DedicatedHost buildMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
        for (DedicatedHostBuilder item : this.dedicatedHosts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
        for (DedicatedHostBuilder item : this.dedicatedHosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDedicatedHosts(List<DedicatedHost> dedicatedHosts) {
        if (this.dedicatedHosts != null) {
            this._visitables.get("dedicatedHosts").clear();
        }
        if (dedicatedHosts != null) {
            this.dedicatedHosts = new ArrayList();
            for (DedicatedHost item : dedicatedHosts) {
                this.addToDedicatedHosts(item);
            }
        } else {
            this.dedicatedHosts = null;
        }
        return (A)this;
    }

    public A withDedicatedHosts(DedicatedHost ... dedicatedHosts) {
        if (this.dedicatedHosts != null) {
            this.dedicatedHosts.clear();
            this._visitables.remove("dedicatedHosts");
        }
        if (dedicatedHosts != null) {
            for (DedicatedHost item : dedicatedHosts) {
                this.addToDedicatedHosts(item);
            }
        }
        return (A)this;
    }

    public boolean hasDedicatedHosts() {
        return this.dedicatedHosts != null && !this.dedicatedHosts.isEmpty();
    }

    public A addNewDedicatedHost(String name, String profile) {
        return this.addToDedicatedHosts(new DedicatedHost(name, profile));
    }

    public DedicatedHostsNested<A> addNewDedicatedHost() {
        return new DedicatedHostsNested(-1, null);
    }

    public DedicatedHostsNested<A> addNewDedicatedHostLike(DedicatedHost item) {
        return new DedicatedHostsNested(-1, item);
    }

    public DedicatedHostsNested<A> setNewDedicatedHostLike(int index, DedicatedHost item) {
        return new DedicatedHostsNested(index, item);
    }

    public DedicatedHostsNested<A> editDedicatedHost(int index) {
        if (this.dedicatedHosts.size() <= index) {
            throw new RuntimeException("Can't edit dedicatedHosts. Index exceeds size.");
        }
        return this.setNewDedicatedHostLike(index, this.buildDedicatedHost(index));
    }

    public DedicatedHostsNested<A> editFirstDedicatedHost() {
        if (this.dedicatedHosts.size() == 0) {
            throw new RuntimeException("Can't edit first dedicatedHosts. The list is empty.");
        }
        return this.setNewDedicatedHostLike(0, this.buildDedicatedHost(0));
    }

    public DedicatedHostsNested<A> editLastDedicatedHost() {
        int index = this.dedicatedHosts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dedicatedHosts. The list is empty.");
        }
        return this.setNewDedicatedHostLike(index, this.buildDedicatedHost(index));
    }

    public DedicatedHostsNested<A> editMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dedicatedHosts.size(); ++i) {
            if (!predicate.test(this.dedicatedHosts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dedicatedHosts. No match found.");
        }
        return this.setNewDedicatedHostLike(index, this.buildDedicatedHost(index));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove("zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.bootVolume, that.bootVolume)) {
            return false;
        }
        if (!Objects.equals(this.dedicatedHosts, that.dedicatedHosts)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bootVolume, this.dedicatedHosts, this.type, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootVolume != null) {
            sb.append("bootVolume:");
            sb.append(this.bootVolume + ",");
        }
        if (this.dedicatedHosts != null && !this.dedicatedHosts.isEmpty()) {
            sb.append("dedicatedHosts:");
            sb.append(this.dedicatedHosts + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DedicatedHostsNested<N>
    extends DedicatedHostFluent<DedicatedHostsNested<N>>
    implements Nested<N> {
        DedicatedHostBuilder builder;
        int index;

        DedicatedHostsNested(int index, DedicatedHost item) {
            this.index = index;
            this.builder = new DedicatedHostBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.setToDedicatedHosts(this.index, this.builder.build());
        }

        public N endDedicatedHost() {
            return this.and();
        }
    }

    public class BootVolumeNested<N>
    extends BootVolumeFluent<BootVolumeNested<N>>
    implements Nested<N> {
        BootVolumeBuilder builder;

        BootVolumeNested(BootVolume item) {
            this.builder = new BootVolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withBootVolume(this.builder.build());
        }

        public N endBootVolume() {
            return this.and();
        }
    }
}

