/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.installer.alibabacloud.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.installer.alibabacloud.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_13.installer.alibabacloud.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_13.installer.alibabacloud.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_13.installer.alibabacloud.v1.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private MachinePoolBuilder defaultMachinePlatform;
    private String privateZoneID;
    private String region;
    private String resourceGroupID;
    private Map<String, String> tags;
    private String vpcID;
    private List<String> vswitchIDs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withPrivateZoneID(instance.getPrivateZoneID());
            this.withRegion(instance.getRegion());
            this.withResourceGroupID(instance.getResourceGroupID());
            this.withTags(instance.getTags());
            this.withVpcID(instance.getVpcID());
            this.withVswitchIDs(instance.getVswitchIDs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove("defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public String getPrivateZoneID() {
        return this.privateZoneID;
    }

    public A withPrivateZoneID(String privateZoneID) {
        this.privateZoneID = privateZoneID;
        return (A)this;
    }

    public boolean hasPrivateZoneID() {
        return this.privateZoneID != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getResourceGroupID() {
        return this.resourceGroupID;
    }

    public A withResourceGroupID(String resourceGroupID) {
        this.resourceGroupID = resourceGroupID;
        return (A)this;
    }

    public boolean hasResourceGroupID() {
        return this.resourceGroupID != null;
    }

    public A addToTags(String key, String value) {
        if (this.tags == null && key != null && value != null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.tags.put(key, value);
        }
        return (A)this;
    }

    public A addToTags(Map<String, String> map) {
        if (this.tags == null && map != null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.tags.putAll(map);
        }
        return (A)this;
    }

    public A removeFromTags(String key) {
        if (this.tags == null) {
            return (A)this;
        }
        if (key != null && this.tags != null) {
            this.tags.remove(key);
        }
        return (A)this;
    }

    public A removeFromTags(Map<String, String> map) {
        if (this.tags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.tags == null) continue;
                this.tags.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public <K, V> A withTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new LinkedHashMap<String, String>(tags);
        return (A)this;
    }

    public boolean hasTags() {
        return this.tags != null;
    }

    public String getVpcID() {
        return this.vpcID;
    }

    public A withVpcID(String vpcID) {
        this.vpcID = vpcID;
        return (A)this;
    }

    public boolean hasVpcID() {
        return this.vpcID != null;
    }

    public A addToVswitchIDs(int index, String item) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        this.vswitchIDs.add(index, item);
        return (A)this;
    }

    public A setToVswitchIDs(int index, String item) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        this.vswitchIDs.set(index, item);
        return (A)this;
    }

    public A addToVswitchIDs(String ... items) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.vswitchIDs.add(item);
        }
        return (A)this;
    }

    public A addAllToVswitchIDs(Collection<String> items) {
        if (this.vswitchIDs == null) {
            this.vswitchIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.vswitchIDs.add(item);
        }
        return (A)this;
    }

    public A removeFromVswitchIDs(String ... items) {
        if (this.vswitchIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.vswitchIDs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVswitchIDs(Collection<String> items) {
        if (this.vswitchIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.vswitchIDs.remove(item);
        }
        return (A)this;
    }

    public List<String> getVswitchIDs() {
        return this.vswitchIDs;
    }

    public String getVswitchID(int index) {
        return this.vswitchIDs.get(index);
    }

    public String getFirstVswitchID() {
        return this.vswitchIDs.get(0);
    }

    public String getLastVswitchID() {
        return this.vswitchIDs.get(this.vswitchIDs.size() - 1);
    }

    public String getMatchingVswitchID(Predicate<String> predicate) {
        for (String item : this.vswitchIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVswitchID(Predicate<String> predicate) {
        for (String item : this.vswitchIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVswitchIDs(List<String> vswitchIDs) {
        if (vswitchIDs != null) {
            this.vswitchIDs = new ArrayList<String>();
            for (String item : vswitchIDs) {
                this.addToVswitchIDs(item);
            }
        } else {
            this.vswitchIDs = null;
        }
        return (A)this;
    }

    public A withVswitchIDs(String ... vswitchIDs) {
        if (this.vswitchIDs != null) {
            this.vswitchIDs.clear();
            this._visitables.remove("vswitchIDs");
        }
        if (vswitchIDs != null) {
            for (String item : vswitchIDs) {
                this.addToVswitchIDs(item);
            }
        }
        return (A)this;
    }

    public boolean hasVswitchIDs() {
        return this.vswitchIDs != null && !this.vswitchIDs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.privateZoneID, that.privateZoneID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroupID, that.resourceGroupID)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.vpcID, that.vpcID)) {
            return false;
        }
        if (!Objects.equals(this.vswitchIDs, that.vswitchIDs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMachinePlatform, this.privateZoneID, this.region, this.resourceGroupID, this.tags, this.vpcID, this.vswitchIDs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.privateZoneID != null) {
            sb.append("privateZoneID:");
            sb.append(this.privateZoneID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceGroupID != null) {
            sb.append("resourceGroupID:");
            sb.append(this.resourceGroupID + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.vpcID != null) {
            sb.append("vpcID:");
            sb.append(this.vpcID + ",");
        }
        if (this.vswitchIDs != null && !this.vswitchIDs.isEmpty()) {
            sb.append("vswitchIDs:");
            sb.append(this.vswitchIDs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

