/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.hive.vsphere.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.hive.vsphere.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_13.hive.vsphere.v1.OSDisk;
import io.fabric8.openshift.api.model.v6_13.hive.vsphere.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.v6_13.hive.vsphere.v1.OSDiskFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private Integer coresPerSocket;
    private Integer cpus;
    private Long memoryMB;
    private OSDiskBuilder osDisk;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withCoresPerSocket(instance.getCoresPerSocket());
            this.withCpus(instance.getCpus());
            this.withMemoryMB(instance.getMemoryMB());
            this.withOsDisk(instance.getOsDisk());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public A withCoresPerSocket(Integer coresPerSocket) {
        this.coresPerSocket = coresPerSocket;
        return (A)this;
    }

    public boolean hasCoresPerSocket() {
        return this.coresPerSocket != null;
    }

    public Integer getCpus() {
        return this.cpus;
    }

    public A withCpus(Integer cpus) {
        this.cpus = cpus;
        return (A)this;
    }

    public boolean hasCpus() {
        return this.cpus != null;
    }

    public Long getMemoryMB() {
        return this.memoryMB;
    }

    public A withMemoryMB(Long memoryMB) {
        this.memoryMB = memoryMB;
        return (A)this;
    }

    public boolean hasMemoryMB() {
        return this.memoryMB != null;
    }

    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public A withOsDisk(OSDisk osDisk) {
        this._visitables.remove("osDisk");
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get("osDisk").remove(this.osDisk);
        }
        return (A)this;
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public A withNewOsDisk(Integer diskSizeGB) {
        return this.withOsDisk(new OSDisk(diskSizeGB));
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNested(item);
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new OSDiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.coresPerSocket, that.coresPerSocket)) {
            return false;
        }
        if (!Objects.equals(this.cpus, that.cpus)) {
            return false;
        }
        if (!Objects.equals(this.memoryMB, that.memoryMB)) {
            return false;
        }
        if (!Objects.equals(this.osDisk, that.osDisk)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coresPerSocket, this.cpus, this.memoryMB, this.osDisk, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.coresPerSocket != null) {
            sb.append("coresPerSocket:");
            sb.append(this.coresPerSocket + ",");
        }
        if (this.cpus != null) {
            sb.append("cpus:");
            sb.append(this.cpus + ",");
        }
        if (this.memoryMB != null) {
            sb.append("memoryMB:");
            sb.append(this.memoryMB + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(this.osDisk + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OsDiskNested<N>
    extends OSDiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        OSDiskBuilder builder;

        OsDiskNested(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }
}

