/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_13.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_13.ResourceRequirementsFluent;
import io.fabric8.openshift.api.model.v6_13.hive.v1.DeploymentConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeploymentConfigFluent<A extends DeploymentConfigFluent<A>>
extends BaseFluent<A> {
    private String deploymentName;
    private ResourceRequirementsBuilder resources;
    private Map<String, Object> additionalProperties;

    public DeploymentConfigFluent() {
    }

    public DeploymentConfigFluent(DeploymentConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeploymentConfig instance) {
        DeploymentConfig deploymentConfig = instance = instance != null ? instance : new DeploymentConfig();
        if (instance != null) {
            this.withDeploymentName(instance.getDeploymentName());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public A withDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return (A)this;
    }

    public boolean hasDeploymentName() {
        return this.deploymentName != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove("resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigFluent that = (DeploymentConfigFluent)o;
        if (!Objects.equals(this.deploymentName, that.deploymentName)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deploymentName, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentName != null) {
            sb.append("deploymentName:");
            sb.append(this.deploymentName + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }
}

