/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.hive.gcp.v1.EncryptionKeyReference;
import io.fabric8.openshift.api.model.v6_13.hive.gcp.v1.EncryptionKeyReferenceBuilder;
import io.fabric8.openshift.api.model.v6_13.hive.gcp.v1.EncryptionKeyReferenceFluent;
import io.fabric8.openshift.api.model.v6_13.hive.gcp.v1.OSDisk;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OSDiskFluent<A extends OSDiskFluent<A>>
extends BaseFluent<A> {
    private Long diskSizeGB;
    private String diskType;
    private EncryptionKeyReferenceBuilder encryptionKey;
    private Map<String, Object> additionalProperties;

    public OSDiskFluent() {
    }

    public OSDiskFluent(OSDisk instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OSDisk instance) {
        OSDisk oSDisk = instance = instance != null ? instance : new OSDisk();
        if (instance != null) {
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withDiskType(instance.getDiskType());
            this.withEncryptionKey(instance.getEncryptionKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public A withDiskSizeGB(Long diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return (A)this;
    }

    public boolean hasDiskSizeGB() {
        return this.diskSizeGB != null;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public A withDiskType(String diskType) {
        this.diskType = diskType;
        return (A)this;
    }

    public boolean hasDiskType() {
        return this.diskType != null;
    }

    public EncryptionKeyReference buildEncryptionKey() {
        return this.encryptionKey != null ? this.encryptionKey.build() : null;
    }

    public A withEncryptionKey(EncryptionKeyReference encryptionKey) {
        this._visitables.remove("encryptionKey");
        if (encryptionKey != null) {
            this.encryptionKey = new EncryptionKeyReferenceBuilder(encryptionKey);
            this._visitables.get("encryptionKey").add(this.encryptionKey);
        } else {
            this.encryptionKey = null;
            this._visitables.get("encryptionKey").remove(this.encryptionKey);
        }
        return (A)this;
    }

    public boolean hasEncryptionKey() {
        return this.encryptionKey != null;
    }

    public EncryptionKeyNested<A> withNewEncryptionKey() {
        return new EncryptionKeyNested(null);
    }

    public EncryptionKeyNested<A> withNewEncryptionKeyLike(EncryptionKeyReference item) {
        return new EncryptionKeyNested(item);
    }

    public EncryptionKeyNested<A> editEncryptionKey() {
        return this.withNewEncryptionKeyLike(Optional.ofNullable(this.buildEncryptionKey()).orElse(null));
    }

    public EncryptionKeyNested<A> editOrNewEncryptionKey() {
        return this.withNewEncryptionKeyLike(Optional.ofNullable(this.buildEncryptionKey()).orElse(new EncryptionKeyReferenceBuilder().build()));
    }

    public EncryptionKeyNested<A> editOrNewEncryptionKeyLike(EncryptionKeyReference item) {
        return this.withNewEncryptionKeyLike(Optional.ofNullable(this.buildEncryptionKey()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OSDiskFluent that = (OSDiskFluent)o;
        if (!Objects.equals(this.diskSizeGB, that.diskSizeGB)) {
            return false;
        }
        if (!Objects.equals(this.diskType, that.diskType)) {
            return false;
        }
        if (!Objects.equals(this.encryptionKey, that.encryptionKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.diskSizeGB, this.diskType, this.encryptionKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.diskSizeGB != null) {
            sb.append("diskSizeGB:");
            sb.append(this.diskSizeGB + ",");
        }
        if (this.diskType != null) {
            sb.append("diskType:");
            sb.append(this.diskType + ",");
        }
        if (this.encryptionKey != null) {
            sb.append("encryptionKey:");
            sb.append(this.encryptionKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EncryptionKeyNested<N>
    extends EncryptionKeyReferenceFluent<EncryptionKeyNested<N>>
    implements Nested<N> {
        EncryptionKeyReferenceBuilder builder;

        EncryptionKeyNested(EncryptionKeyReference item) {
            this.builder = new EncryptionKeyReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OSDiskFluent.this.withEncryptionKey(this.builder.build());
        }

        public N endEncryptionKey() {
            return this.and();
        }
    }
}

