/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.console.v1alpha1.ConsolePluginProxy;
import io.fabric8.openshift.api.model.v6_13.console.v1alpha1.ConsolePluginProxyBuilder;
import io.fabric8.openshift.api.model.v6_13.console.v1alpha1.ConsolePluginProxyFluent;
import io.fabric8.openshift.api.model.v6_13.console.v1alpha1.ConsolePluginService;
import io.fabric8.openshift.api.model.v6_13.console.v1alpha1.ConsolePluginServiceBuilder;
import io.fabric8.openshift.api.model.v6_13.console.v1alpha1.ConsolePluginServiceFluent;
import io.fabric8.openshift.api.model.v6_13.console.v1alpha1.ConsolePluginSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConsolePluginSpecFluent<A extends ConsolePluginSpecFluent<A>>
extends BaseFluent<A> {
    private String displayName;
    private ArrayList<ConsolePluginProxyBuilder> proxy = new ArrayList();
    private ConsolePluginServiceBuilder service;
    private Map<String, Object> additionalProperties;

    public ConsolePluginSpecFluent() {
    }

    public ConsolePluginSpecFluent(ConsolePluginSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsolePluginSpec instance) {
        ConsolePluginSpec consolePluginSpec = instance = instance != null ? instance : new ConsolePluginSpec();
        if (instance != null) {
            this.withDisplayName(instance.getDisplayName());
            this.withProxy(instance.getProxy());
            this.withService(instance.getService());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)this;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A addToProxy(int index, ConsolePluginProxy item) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
        if (index < 0 || index >= this.proxy.size()) {
            this._visitables.get("proxy").add(builder);
            this.proxy.add(builder);
        } else {
            this._visitables.get("proxy").add(index, builder);
            this.proxy.add(index, builder);
        }
        return (A)this;
    }

    public A setToProxy(int index, ConsolePluginProxy item) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
        if (index < 0 || index >= this.proxy.size()) {
            this._visitables.get("proxy").add(builder);
            this.proxy.add(builder);
        } else {
            this._visitables.get("proxy").set(index, builder);
            this.proxy.set(index, builder);
        }
        return (A)this;
    }

    public A addToProxy(ConsolePluginProxy ... items) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get("proxy").add(builder);
            this.proxy.add(builder);
        }
        return (A)this;
    }

    public A addAllToProxy(Collection<ConsolePluginProxy> items) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get("proxy").add(builder);
            this.proxy.add(builder);
        }
        return (A)this;
    }

    public A removeFromProxy(ConsolePluginProxy ... items) {
        if (this.proxy == null) {
            return (A)this;
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get("proxy").remove(builder);
            this.proxy.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromProxy(Collection<ConsolePluginProxy> items) {
        if (this.proxy == null) {
            return (A)this;
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get("proxy").remove(builder);
            this.proxy.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        if (this.proxy == null) {
            return (A)this;
        }
        Iterator<ConsolePluginProxyBuilder> each = this.proxy.iterator();
        Object visitables = this._visitables.get("proxy");
        while (each.hasNext()) {
            ConsolePluginProxyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ConsolePluginProxy> buildProxy() {
        return this.proxy != null ? ConsolePluginSpecFluent.build(this.proxy) : null;
    }

    public ConsolePluginProxy buildProxy(int index) {
        return this.proxy.get(index).build();
    }

    public ConsolePluginProxy buildFirstProxy() {
        return this.proxy.get(0).build();
    }

    public ConsolePluginProxy buildLastProxy() {
        return this.proxy.get(this.proxy.size() - 1).build();
    }

    public ConsolePluginProxy buildMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        for (ConsolePluginProxyBuilder item : this.proxy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        for (ConsolePluginProxyBuilder item : this.proxy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProxy(List<ConsolePluginProxy> proxy) {
        if (this.proxy != null) {
            this._visitables.get("proxy").clear();
        }
        if (proxy != null) {
            this.proxy = new ArrayList();
            for (ConsolePluginProxy item : proxy) {
                this.addToProxy(item);
            }
        } else {
            this.proxy = null;
        }
        return (A)this;
    }

    public A withProxy(ConsolePluginProxy ... proxy) {
        if (this.proxy != null) {
            this.proxy.clear();
            this._visitables.remove("proxy");
        }
        if (proxy != null) {
            for (ConsolePluginProxy item : proxy) {
                this.addToProxy(item);
            }
        }
        return (A)this;
    }

    public boolean hasProxy() {
        return this.proxy != null && !this.proxy.isEmpty();
    }

    public ProxyNested<A> addNewProxy() {
        return new ProxyNested(-1, null);
    }

    public ProxyNested<A> addNewProxyLike(ConsolePluginProxy item) {
        return new ProxyNested(-1, item);
    }

    public ProxyNested<A> setNewProxyLike(int index, ConsolePluginProxy item) {
        return new ProxyNested(index, item);
    }

    public ProxyNested<A> editProxy(int index) {
        if (this.proxy.size() <= index) {
            throw new RuntimeException("Can't edit proxy. Index exceeds size.");
        }
        return this.setNewProxyLike(index, this.buildProxy(index));
    }

    public ProxyNested<A> editFirstProxy() {
        if (this.proxy.size() == 0) {
            throw new RuntimeException("Can't edit first proxy. The list is empty.");
        }
        return this.setNewProxyLike(0, this.buildProxy(0));
    }

    public ProxyNested<A> editLastProxy() {
        int index = this.proxy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last proxy. The list is empty.");
        }
        return this.setNewProxyLike(index, this.buildProxy(index));
    }

    public ProxyNested<A> editMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.proxy.size(); ++i) {
            if (!predicate.test(this.proxy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching proxy. No match found.");
        }
        return this.setNewProxyLike(index, this.buildProxy(index));
    }

    public ConsolePluginService buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(ConsolePluginService service) {
        this._visitables.remove("service");
        if (service != null) {
            this.service = new ConsolePluginServiceBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public A withNewService(String basePath, String name, String namespace, Integer port) {
        return this.withService(new ConsolePluginService(basePath, name, namespace, port));
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(ConsolePluginService item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new ConsolePluginServiceBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(ConsolePluginService item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsolePluginSpecFluent that = (ConsolePluginSpecFluent)o;
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals(this.proxy, that.proxy)) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.displayName, this.proxy, this.service, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.proxy != null && !this.proxy.isEmpty()) {
            sb.append("proxy:");
            sb.append(this.proxy + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(this.service + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceNested<N>
    extends ConsolePluginServiceFluent<ServiceNested<N>>
    implements Nested<N> {
        ConsolePluginServiceBuilder builder;

        ServiceNested(ConsolePluginService item) {
            this.builder = new ConsolePluginServiceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsolePluginSpecFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }

    public class ProxyNested<N>
    extends ConsolePluginProxyFluent<ProxyNested<N>>
    implements Nested<N> {
        ConsolePluginProxyBuilder builder;
        int index;

        ProxyNested(int index, ConsolePluginProxy item) {
            this.index = index;
            this.builder = new ConsolePluginProxyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsolePluginSpecFluent.this.setToProxy(this.index, this.builder.build());
        }

        public N endProxy() {
            return this.and();
        }
    }
}

