/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.config.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.config.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.v6_13.config.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.v6_13.config.v1.ClusterNetworkEntryFluent;
import io.fabric8.openshift.api.model.v6_13.config.v1.NetworkMigration;
import io.fabric8.openshift.api.model.v6_13.config.v1.NetworkMigrationBuilder;
import io.fabric8.openshift.api.model.v6_13.config.v1.NetworkMigrationFluent;
import io.fabric8.openshift.api.model.v6_13.config.v1.NetworkStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetworkStatusFluent<A extends NetworkStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList();
    private Integer clusterNetworkMTU;
    private NetworkMigrationBuilder migration;
    private String networkType;
    private List<String> serviceNetwork = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NetworkStatusFluent() {
    }

    public NetworkStatusFluent(NetworkStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkStatus instance) {
        NetworkStatus networkStatus = instance = instance != null ? instance : new NetworkStatus();
        if (instance != null) {
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withClusterNetworkMTU(instance.getClusterNetworkMTU());
            this.withMigration(instance.getMigration());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get("clusterNetwork").add(index, builder);
            this.clusterNetwork.add(index, builder);
        }
        return (A)this;
    }

    public A setToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get("clusterNetwork").set(index, builder);
            this.clusterNetwork.set(index, builder);
        }
        return (A)this;
    }

    public A addToClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    public A removeFromClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetwork.iterator();
        Object visitables = this._visitables.get("clusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return this.clusterNetwork != null ? NetworkStatusFluent.build(this.clusterNetwork) : null;
    }

    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(this.clusterNetwork.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) {
            this._visitables.get("clusterNetwork").clear();
        }
        if (clusterNetwork != null) {
            this.clusterNetwork = new ArrayList();
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        } else {
            this.clusterNetwork = null;
        }
        return (A)this;
    }

    public A withClusterNetwork(ClusterNetworkEntry ... clusterNetwork) {
        if (this.clusterNetwork != null) {
            this.clusterNetwork.clear();
            this._visitables.remove("clusterNetwork");
        }
        if (clusterNetwork != null) {
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        }
        return (A)this;
    }

    public boolean hasClusterNetwork() {
        return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
    }

    public A addNewClusterNetwork(String cidr, Integer hostPrefix) {
        return this.addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNested(-1, null);
    }

    public ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNested(-1, item);
    }

    public ClusterNetworkNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworkNested(index, item);
    }

    public ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (this.clusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (this.clusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    public ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = this.clusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetwork.size(); ++i) {
            if (!predicate.test(this.clusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public Integer getClusterNetworkMTU() {
        return this.clusterNetworkMTU;
    }

    public A withClusterNetworkMTU(Integer clusterNetworkMTU) {
        this.clusterNetworkMTU = clusterNetworkMTU;
        return (A)this;
    }

    public boolean hasClusterNetworkMTU() {
        return this.clusterNetworkMTU != null;
    }

    public NetworkMigration buildMigration() {
        return this.migration != null ? this.migration.build() : null;
    }

    public A withMigration(NetworkMigration migration) {
        this._visitables.remove("migration");
        if (migration != null) {
            this.migration = new NetworkMigrationBuilder(migration);
            this._visitables.get("migration").add(this.migration);
        } else {
            this.migration = null;
            this._visitables.get("migration").remove(this.migration);
        }
        return (A)this;
    }

    public boolean hasMigration() {
        return this.migration != null;
    }

    public MigrationNested<A> withNewMigration() {
        return new MigrationNested(null);
    }

    public MigrationNested<A> withNewMigrationLike(NetworkMigration item) {
        return new MigrationNested(item);
    }

    public MigrationNested<A> editMigration() {
        return this.withNewMigrationLike(Optional.ofNullable(this.buildMigration()).orElse(null));
    }

    public MigrationNested<A> editOrNewMigration() {
        return this.withNewMigrationLike(Optional.ofNullable(this.buildMigration()).orElse(new NetworkMigrationBuilder().build()));
    }

    public MigrationNested<A> editOrNewMigrationLike(NetworkMigration item) {
        return this.withNewMigrationLike(Optional.ofNullable(this.buildMigration()).orElse(item));
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)this;
    }

    public boolean hasNetworkType() {
        return this.networkType != null;
    }

    public A addToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    public A setToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.set(index, item);
        return (A)this;
    }

    public A addToServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    public A removeFromServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    public String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(this.serviceNetwork.size() - 1);
    }

    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceNetwork(List<String> serviceNetwork) {
        if (serviceNetwork != null) {
            this.serviceNetwork = new ArrayList<String>();
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        } else {
            this.serviceNetwork = null;
        }
        return (A)this;
    }

    public A withServiceNetwork(String ... serviceNetwork) {
        if (this.serviceNetwork != null) {
            this.serviceNetwork.clear();
            this._visitables.remove("serviceNetwork");
        }
        if (serviceNetwork != null) {
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceNetwork() {
        return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkStatusFluent that = (NetworkStatusFluent)o;
        if (!Objects.equals(this.clusterNetwork, that.clusterNetwork)) {
            return false;
        }
        if (!Objects.equals(this.clusterNetworkMTU, that.clusterNetworkMTU)) {
            return false;
        }
        if (!Objects.equals(this.migration, that.migration)) {
            return false;
        }
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        if (!Objects.equals(this.serviceNetwork, that.serviceNetwork)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterNetwork, this.clusterNetworkMTU, this.migration, this.networkType, this.serviceNetwork, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterNetwork != null && !this.clusterNetwork.isEmpty()) {
            sb.append("clusterNetwork:");
            sb.append(this.clusterNetwork + ",");
        }
        if (this.clusterNetworkMTU != null) {
            sb.append("clusterNetworkMTU:");
            sb.append(this.clusterNetworkMTU + ",");
        }
        if (this.migration != null) {
            sb.append("migration:");
            sb.append(this.migration + ",");
        }
        if (this.networkType != null) {
            sb.append("networkType:");
            sb.append(this.networkType + ",");
        }
        if (this.serviceNetwork != null && !this.serviceNetwork.isEmpty()) {
            sb.append("serviceNetwork:");
            sb.append(this.serviceNetwork + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MigrationNested<N>
    extends NetworkMigrationFluent<MigrationNested<N>>
    implements Nested<N> {
        NetworkMigrationBuilder builder;

        MigrationNested(NetworkMigration item) {
            this.builder = new NetworkMigrationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkStatusFluent.this.withMigration(this.builder.build());
        }

        public N endMigration() {
            return this.and();
        }
    }

    public class ClusterNetworkNested<N>
    extends ClusterNetworkEntryFluent<ClusterNetworkNested<N>>
    implements Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        ClusterNetworkNested(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkStatusFluent.this.setToClusterNetwork(this.index, this.builder.build());
        }

        public N endClusterNetwork() {
            return this.and();
        }
    }
}

