/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.config.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_13.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_13.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.v6_13.config.v1.GitLabIdentityProvider;
import io.fabric8.openshift.api.model.v6_13.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.v6_13.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_13.config.v1.SecretNameReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GitLabIdentityProviderFluent<A extends GitLabIdentityProviderFluent<A>>
extends BaseFluent<A> {
    private ConfigMapNameReferenceBuilder ca;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String url;
    private Map<String, Object> additionalProperties;

    public GitLabIdentityProviderFluent() {
    }

    public GitLabIdentityProviderFluent(GitLabIdentityProvider instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GitLabIdentityProvider instance) {
        GitLabIdentityProvider gitLabIdentityProvider = instance = instance != null ? instance : new GitLabIdentityProvider();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(ConfigMapNameReference ca) {
        this._visitables.remove("ca");
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get("ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get("ca").remove(this.ca);
        }
        return (A)this;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public String getClientID() {
        return this.clientID;
    }

    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    public boolean hasClientID() {
        return this.clientID != null;
    }

    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.remove("clientSecret");
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get("clientSecret").add(this.clientSecret);
        } else {
            this.clientSecret = null;
            this._visitables.get("clientSecret").remove(this.clientSecret);
        }
        return (A)this;
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    public ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNested(null);
    }

    public ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNested(item);
    }

    public ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(null));
    }

    public ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(item));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitLabIdentityProviderFluent that = (GitLabIdentityProviderFluent)o;
        if (!Objects.equals(this.ca, that.ca)) {
            return false;
        }
        if (!Objects.equals(this.clientID, that.clientID)) {
            return false;
        }
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ca, this.clientID, this.clientSecret, this.url, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(this.clientSecret + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientSecretNested<N>
    extends SecretNameReferenceFluent<ClientSecretNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        ClientSecretNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GitLabIdentityProviderFluent.this.withClientSecret(this.builder.build());
        }

        public N endClientSecret() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends ConfigMapNameReferenceFluent<CaNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        CaNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GitLabIdentityProviderFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

