/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_13.dsl.internal;

import io.fabric8.kubernetes.clnt.v6_13.KubernetesClientException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ExecWatchInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 32768;
    private final LinkedList<ByteBuffer> buffers = new LinkedList();
    private boolean complete;
    private boolean closed;
    private Throwable failed;
    private ByteBuffer currentBuffer;
    private final Runnable request;
    private final int bufferSize;

    public ExecWatchInputStream(Runnable request) {
        this(request, 32768);
    }

    public ExecWatchInputStream(Runnable request, int bufferSize) {
        this.request = request;
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onExit(Integer exitCode, Throwable t) {
        LinkedList<ByteBuffer> linkedList = this.buffers;
        synchronized (linkedList) {
            if (this.complete) {
                return;
            }
            this.complete = true;
            if (t != null) {
                this.failed = t;
            } else if (exitCode != null && exitCode != 0) {
                this.failed = new KubernetesClientException("process exited with a non-zero exit code: " + exitCode);
            }
            this.buffers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consume(List<ByteBuffer> value) {
        LinkedList<ByteBuffer> linkedList = this.buffers;
        synchronized (linkedList) {
            if (this.closed) {
                this.request.run();
                return;
            }
            assert (!this.complete || this.failed == null);
            this.buffers.addAll(value);
            this.buffers.notifyAll();
            if ((this.currentBuffer != null ? this.currentBuffer.remaining() : 0) + this.buffers.stream().mapToInt(Buffer::remaining).sum() < this.bufferSize) {
                this.request.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer current() throws IOException {
        LinkedList<ByteBuffer> linkedList = this.buffers;
        synchronized (linkedList) {
            while (this.currentBuffer == null || !this.currentBuffer.hasRemaining()) {
                if (this.closed) {
                    throw new IOException("closed", this.failed);
                }
                if (this.buffers.isEmpty()) {
                    if (this.complete) {
                        if (this.failed != null) {
                            throw new IOException("closed", this.failed);
                        }
                        return null;
                    }
                    this.requestMoreIfNeeded();
                }
                this.currentBuffer = this.buffers.poll();
                if (this.currentBuffer != null || this.complete) continue;
                try {
                    this.buffers.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            return this.currentBuffer;
        }
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        ByteBuffer buffer = this.current();
        if (buffer == null) {
            return -1;
        }
        int read = Math.min(buffer.remaining(), len);
        assert (read > 0 && read <= buffer.remaining());
        buffer.get(bytes, off, read);
        return read;
    }

    @Override
    public int read() throws IOException {
        byte[] single = new byte[1];
        if (this.read(single) == -1) {
            return -1;
        }
        return single[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LinkedList<ByteBuffer> linkedList = this.buffers;
        synchronized (linkedList) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.requestMoreIfNeeded();
            this.buffers.clear();
            this.buffers.notifyAll();
        }
    }

    private void requestMoreIfNeeded() {
        if (this.currentBuffer != null) {
            this.currentBuffer = null;
            this.request.run();
        }
    }
}

