/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.NamedResourcesAttribute;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.NamedResourcesAttributeBuilder;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.NamedResourcesAttributeFluent;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.NamedResourcesInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NamedResourcesInstanceFluent<A extends NamedResourcesInstanceFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NamedResourcesAttributeBuilder> attributes = new ArrayList();
    private String name;
    private Map<String, Object> additionalProperties;

    public NamedResourcesInstanceFluent() {
    }

    public NamedResourcesInstanceFluent(NamedResourcesInstance instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamedResourcesInstance instance) {
        NamedResourcesInstance namedResourcesInstance = instance = instance != null ? instance : new NamedResourcesInstance();
        if (instance != null) {
            this.withAttributes(instance.getAttributes());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAttributes(int index, NamedResourcesAttribute item) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
        if (index < 0 || index >= this.attributes.size()) {
            this._visitables.get("attributes").add(builder);
            this.attributes.add(builder);
        } else {
            this._visitables.get("attributes").add(index, builder);
            this.attributes.add(index, builder);
        }
        return (A)this;
    }

    public A setToAttributes(int index, NamedResourcesAttribute item) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
        if (index < 0 || index >= this.attributes.size()) {
            this._visitables.get("attributes").add(builder);
            this.attributes.add(builder);
        } else {
            this._visitables.get("attributes").set(index, builder);
            this.attributes.set(index, builder);
        }
        return (A)this;
    }

    public A addToAttributes(NamedResourcesAttribute ... items) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        for (NamedResourcesAttribute item : items) {
            NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
            this._visitables.get("attributes").add(builder);
            this.attributes.add(builder);
        }
        return (A)this;
    }

    public A addAllToAttributes(Collection<NamedResourcesAttribute> items) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        for (NamedResourcesAttribute item : items) {
            NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
            this._visitables.get("attributes").add(builder);
            this.attributes.add(builder);
        }
        return (A)this;
    }

    public A removeFromAttributes(NamedResourcesAttribute ... items) {
        if (this.attributes == null) {
            return (A)this;
        }
        for (NamedResourcesAttribute item : items) {
            NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
            this._visitables.get("attributes").remove(builder);
            this.attributes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAttributes(Collection<NamedResourcesAttribute> items) {
        if (this.attributes == null) {
            return (A)this;
        }
        for (NamedResourcesAttribute item : items) {
            NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
            this._visitables.get("attributes").remove(builder);
            this.attributes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAttributes(Predicate<NamedResourcesAttributeBuilder> predicate) {
        if (this.attributes == null) {
            return (A)this;
        }
        Iterator<NamedResourcesAttributeBuilder> each = this.attributes.iterator();
        Object visitables = this._visitables.get("attributes");
        while (each.hasNext()) {
            NamedResourcesAttributeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NamedResourcesAttribute> buildAttributes() {
        return this.attributes != null ? NamedResourcesInstanceFluent.build(this.attributes) : null;
    }

    public NamedResourcesAttribute buildAttribute(int index) {
        return this.attributes.get(index).build();
    }

    public NamedResourcesAttribute buildFirstAttribute() {
        return this.attributes.get(0).build();
    }

    public NamedResourcesAttribute buildLastAttribute() {
        return this.attributes.get(this.attributes.size() - 1).build();
    }

    public NamedResourcesAttribute buildMatchingAttribute(Predicate<NamedResourcesAttributeBuilder> predicate) {
        for (NamedResourcesAttributeBuilder item : this.attributes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAttribute(Predicate<NamedResourcesAttributeBuilder> predicate) {
        for (NamedResourcesAttributeBuilder item : this.attributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAttributes(List<NamedResourcesAttribute> attributes) {
        if (this.attributes != null) {
            this._visitables.get("attributes").clear();
        }
        if (attributes != null) {
            this.attributes = new ArrayList();
            for (NamedResourcesAttribute item : attributes) {
                this.addToAttributes(item);
            }
        } else {
            this.attributes = null;
        }
        return (A)this;
    }

    public A withAttributes(NamedResourcesAttribute ... attributes) {
        if (this.attributes != null) {
            this.attributes.clear();
            this._visitables.remove("attributes");
        }
        if (attributes != null) {
            for (NamedResourcesAttribute item : attributes) {
                this.addToAttributes(item);
            }
        }
        return (A)this;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public AttributesNested<A> addNewAttribute() {
        return new AttributesNested(-1, null);
    }

    public AttributesNested<A> addNewAttributeLike(NamedResourcesAttribute item) {
        return new AttributesNested(-1, item);
    }

    public AttributesNested<A> setNewAttributeLike(int index, NamedResourcesAttribute item) {
        return new AttributesNested(index, item);
    }

    public AttributesNested<A> editAttribute(int index) {
        if (this.attributes.size() <= index) {
            throw new RuntimeException("Can't edit attributes. Index exceeds size.");
        }
        return this.setNewAttributeLike(index, this.buildAttribute(index));
    }

    public AttributesNested<A> editFirstAttribute() {
        if (this.attributes.size() == 0) {
            throw new RuntimeException("Can't edit first attributes. The list is empty.");
        }
        return this.setNewAttributeLike(0, this.buildAttribute(0));
    }

    public AttributesNested<A> editLastAttribute() {
        int index = this.attributes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last attributes. The list is empty.");
        }
        return this.setNewAttributeLike(index, this.buildAttribute(index));
    }

    public AttributesNested<A> editMatchingAttribute(Predicate<NamedResourcesAttributeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!predicate.test(this.attributes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching attributes. No match found.");
        }
        return this.setNewAttributeLike(index, this.buildAttribute(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedResourcesInstanceFluent that = (NamedResourcesInstanceFluent)o;
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributes, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AttributesNested<N>
    extends NamedResourcesAttributeFluent<AttributesNested<N>>
    implements Nested<N> {
        NamedResourcesAttributeBuilder builder;
        int index;

        AttributesNested(int index, NamedResourcesAttribute item) {
            this.index = index;
            this.builder = new NamedResourcesAttributeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedResourcesInstanceFluent.this.setToAttributes(this.index, this.builder.build());
        }

        public N endAttribute() {
            return this.and();
        }
    }
}

