/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1.Overhead;
import io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1.OverheadBuilder;
import io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1.OverheadFluent;
import io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1.RuntimeClassSpec;
import io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1.Scheduling;
import io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1.SchedulingBuilder;
import io.fabric8.kubernetes.api.model.v6_13.node.v1alpha1.SchedulingFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RuntimeClassSpecFluent<A extends RuntimeClassSpecFluent<A>>
extends BaseFluent<A> {
    private OverheadBuilder overhead;
    private String runtimeHandler;
    private SchedulingBuilder scheduling;
    private Map<String, Object> additionalProperties;

    public RuntimeClassSpecFluent() {
    }

    public RuntimeClassSpecFluent(RuntimeClassSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RuntimeClassSpec instance) {
        RuntimeClassSpec runtimeClassSpec = instance = instance != null ? instance : new RuntimeClassSpec();
        if (instance != null) {
            this.withOverhead(instance.getOverhead());
            this.withRuntimeHandler(instance.getRuntimeHandler());
            this.withScheduling(instance.getScheduling());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Overhead buildOverhead() {
        return this.overhead != null ? this.overhead.build() : null;
    }

    public A withOverhead(Overhead overhead) {
        this._visitables.remove("overhead");
        if (overhead != null) {
            this.overhead = new OverheadBuilder(overhead);
            this._visitables.get("overhead").add(this.overhead);
        } else {
            this.overhead = null;
            this._visitables.get("overhead").remove(this.overhead);
        }
        return (A)this;
    }

    public boolean hasOverhead() {
        return this.overhead != null;
    }

    public OverheadNested<A> withNewOverhead() {
        return new OverheadNested(null);
    }

    public OverheadNested<A> withNewOverheadLike(Overhead item) {
        return new OverheadNested(item);
    }

    public OverheadNested<A> editOverhead() {
        return this.withNewOverheadLike(Optional.ofNullable(this.buildOverhead()).orElse(null));
    }

    public OverheadNested<A> editOrNewOverhead() {
        return this.withNewOverheadLike(Optional.ofNullable(this.buildOverhead()).orElse(new OverheadBuilder().build()));
    }

    public OverheadNested<A> editOrNewOverheadLike(Overhead item) {
        return this.withNewOverheadLike(Optional.ofNullable(this.buildOverhead()).orElse(item));
    }

    public String getRuntimeHandler() {
        return this.runtimeHandler;
    }

    public A withRuntimeHandler(String runtimeHandler) {
        this.runtimeHandler = runtimeHandler;
        return (A)this;
    }

    public boolean hasRuntimeHandler() {
        return this.runtimeHandler != null;
    }

    public Scheduling buildScheduling() {
        return this.scheduling != null ? this.scheduling.build() : null;
    }

    public A withScheduling(Scheduling scheduling) {
        this._visitables.remove("scheduling");
        if (scheduling != null) {
            this.scheduling = new SchedulingBuilder(scheduling);
            this._visitables.get("scheduling").add(this.scheduling);
        } else {
            this.scheduling = null;
            this._visitables.get("scheduling").remove(this.scheduling);
        }
        return (A)this;
    }

    public boolean hasScheduling() {
        return this.scheduling != null;
    }

    public SchedulingNested<A> withNewScheduling() {
        return new SchedulingNested(null);
    }

    public SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
        return new SchedulingNested(item);
    }

    public SchedulingNested<A> editScheduling() {
        return this.withNewSchedulingLike(Optional.ofNullable(this.buildScheduling()).orElse(null));
    }

    public SchedulingNested<A> editOrNewScheduling() {
        return this.withNewSchedulingLike(Optional.ofNullable(this.buildScheduling()).orElse(new SchedulingBuilder().build()));
    }

    public SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
        return this.withNewSchedulingLike(Optional.ofNullable(this.buildScheduling()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeClassSpecFluent that = (RuntimeClassSpecFluent)o;
        if (!Objects.equals(this.overhead, that.overhead)) {
            return false;
        }
        if (!Objects.equals(this.runtimeHandler, that.runtimeHandler)) {
            return false;
        }
        if (!Objects.equals(this.scheduling, that.scheduling)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.overhead, this.runtimeHandler, this.scheduling, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.overhead != null) {
            sb.append("overhead:");
            sb.append(this.overhead + ",");
        }
        if (this.runtimeHandler != null) {
            sb.append("runtimeHandler:");
            sb.append(this.runtimeHandler + ",");
        }
        if (this.scheduling != null) {
            sb.append("scheduling:");
            sb.append(this.scheduling + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SchedulingNested<N>
    extends SchedulingFluent<SchedulingNested<N>>
    implements Nested<N> {
        SchedulingBuilder builder;

        SchedulingNested(Scheduling item) {
            this.builder = new SchedulingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RuntimeClassSpecFluent.this.withScheduling(this.builder.build());
        }

        public N endScheduling() {
            return this.and();
        }
    }

    public class OverheadNested<N>
    extends OverheadFluent<OverheadNested<N>>
    implements Nested<N> {
        OverheadBuilder builder;

        OverheadNested(Overhead item) {
            this.builder = new OverheadBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RuntimeClassSpecFluent.this.withOverhead(this.builder.build());
        }

        public N endOverhead() {
            return this.and();
        }
    }
}

