/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1.NonResourceAttributes;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1.NonResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1.NonResourceAttributesFluent;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1.ResourceAttributes;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1.ResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1.ResourceAttributesFluent;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1beta1.SubjectAccessReviewSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SubjectAccessReviewSpecFluent<A extends SubjectAccessReviewSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, List<String>> extra;
    private List<String> group = new ArrayList<String>();
    private NonResourceAttributesBuilder nonResourceAttributes;
    private ResourceAttributesBuilder resourceAttributes;
    private String uid;
    private String user;
    private Map<String, Object> additionalProperties;

    public SubjectAccessReviewSpecFluent() {
    }

    public SubjectAccessReviewSpecFluent(SubjectAccessReviewSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SubjectAccessReviewSpec instance) {
        SubjectAccessReviewSpec subjectAccessReviewSpec = instance = instance != null ? instance : new SubjectAccessReviewSpec();
        if (instance != null) {
            this.withExtra(instance.getExtra());
            this.withGroup(instance.getGroup());
            this.withNonResourceAttributes(instance.getNonResourceAttributes());
            this.withResourceAttributes(instance.getResourceAttributes());
            this.withUid(instance.getUid());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToExtra(String key, List<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    public A addToExtra(Map<String, List<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    public A removeFromExtra(Map<String, List<String>> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public <K, V> A withExtra(Map<String, List<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, List<String>>(extra);
        return (A)this;
    }

    public boolean hasExtra() {
        return this.extra != null;
    }

    public A addToGroup(int index, String item) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.add(index, item);
        return (A)this;
    }

    public A setToGroup(int index, String item) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.set(index, item);
        return (A)this;
    }

    public A addToGroup(String ... items) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        for (String item : items) {
            this.group.add(item);
        }
        return (A)this;
    }

    public A addAllToGroup(Collection<String> items) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        for (String item : items) {
            this.group.add(item);
        }
        return (A)this;
    }

    public A removeFromGroup(String ... items) {
        if (this.group == null) {
            return (A)this;
        }
        for (String item : items) {
            this.group.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGroup(Collection<String> items) {
        if (this.group == null) {
            return (A)this;
        }
        for (String item : items) {
            this.group.remove(item);
        }
        return (A)this;
    }

    public List<String> getGroup() {
        return this.group;
    }

    public String getGroup(int index) {
        return this.group.get(index);
    }

    public String getFirstGroup() {
        return this.group.get(0);
    }

    public String getLastGroup() {
        return this.group.get(this.group.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.group) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.group) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroup(List<String> group) {
        if (group != null) {
            this.group = new ArrayList<String>();
            for (String item : group) {
                this.addToGroup(item);
            }
        } else {
            this.group = null;
        }
        return (A)this;
    }

    public A withGroup(String ... group) {
        if (this.group != null) {
            this.group.clear();
            this._visitables.remove("group");
        }
        if (group != null) {
            for (String item : group) {
                this.addToGroup(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public NonResourceAttributes buildNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
        this._visitables.remove("nonResourceAttributes");
        if (nonResourceAttributes != null) {
            this.nonResourceAttributes = new NonResourceAttributesBuilder(nonResourceAttributes);
            this._visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);
        } else {
            this.nonResourceAttributes = null;
            this._visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
        }
        return (A)this;
    }

    public boolean hasNonResourceAttributes() {
        return this.nonResourceAttributes != null;
    }

    public A withNewNonResourceAttributes(String path, String verb) {
        return this.withNonResourceAttributes(new NonResourceAttributes(path, verb));
    }

    public NonResourceAttributesNested<A> withNewNonResourceAttributes() {
        return new NonResourceAttributesNested(null);
    }

    public NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
        return new NonResourceAttributesNested(item);
    }

    public NonResourceAttributesNested<A> editNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(Optional.ofNullable(this.buildNonResourceAttributes()).orElse(null));
    }

    public NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(Optional.ofNullable(this.buildNonResourceAttributes()).orElse(new NonResourceAttributesBuilder().build()));
    }

    public NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
        return this.withNewNonResourceAttributesLike(Optional.ofNullable(this.buildNonResourceAttributes()).orElse(item));
    }

    public ResourceAttributes buildResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    public A withResourceAttributes(ResourceAttributes resourceAttributes) {
        this._visitables.remove("resourceAttributes");
        if (resourceAttributes != null) {
            this.resourceAttributes = new ResourceAttributesBuilder(resourceAttributes);
            this._visitables.get("resourceAttributes").add(this.resourceAttributes);
        } else {
            this.resourceAttributes = null;
            this._visitables.get("resourceAttributes").remove(this.resourceAttributes);
        }
        return (A)this;
    }

    public boolean hasResourceAttributes() {
        return this.resourceAttributes != null;
    }

    public ResourceAttributesNested<A> withNewResourceAttributes() {
        return new ResourceAttributesNested(null);
    }

    public ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
        return new ResourceAttributesNested(item);
    }

    public ResourceAttributesNested<A> editResourceAttributes() {
        return this.withNewResourceAttributesLike(Optional.ofNullable(this.buildResourceAttributes()).orElse(null));
    }

    public ResourceAttributesNested<A> editOrNewResourceAttributes() {
        return this.withNewResourceAttributesLike(Optional.ofNullable(this.buildResourceAttributes()).orElse(new ResourceAttributesBuilder().build()));
    }

    public ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
        return this.withNewResourceAttributesLike(Optional.ofNullable(this.buildResourceAttributes()).orElse(item));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectAccessReviewSpecFluent that = (SubjectAccessReviewSpecFluent)o;
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.nonResourceAttributes, that.nonResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.resourceAttributes, that.resourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.extra, this.group, this.nonResourceAttributes, this.resourceAttributes, this.uid, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra + ",");
        }
        if (this.group != null && !this.group.isEmpty()) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.nonResourceAttributes != null) {
            sb.append("nonResourceAttributes:");
            sb.append(this.nonResourceAttributes + ",");
        }
        if (this.resourceAttributes != null) {
            sb.append("resourceAttributes:");
            sb.append(this.resourceAttributes + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceAttributesNested<N>
    extends ResourceAttributesFluent<ResourceAttributesNested<N>>
    implements Nested<N> {
        ResourceAttributesBuilder builder;

        ResourceAttributesNested(ResourceAttributes item) {
            this.builder = new ResourceAttributesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluent.this.withResourceAttributes(this.builder.build());
        }

        public N endResourceAttributes() {
            return this.and();
        }
    }

    public class NonResourceAttributesNested<N>
    extends NonResourceAttributesFluent<NonResourceAttributesNested<N>>
    implements Nested<N> {
        NonResourceAttributesBuilder builder;

        NonResourceAttributesNested(NonResourceAttributes item) {
            this.builder = new NonResourceAttributesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluent.this.withNonResourceAttributes(this.builder.build());
        }

        public N endNonResourceAttributes() {
            return this.and();
        }
    }
}

