/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1.CustomResourceDefinitionCondition;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1.CustomResourceDefinitionConditionBuilder;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1.CustomResourceDefinitionConditionFluent;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1.CustomResourceDefinitionNames;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1.CustomResourceDefinitionNamesBuilder;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1.CustomResourceDefinitionNamesFluent;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1.CustomResourceDefinitionStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CustomResourceDefinitionStatusFluent<A extends CustomResourceDefinitionStatusFluent<A>>
extends BaseFluent<A> {
    private CustomResourceDefinitionNamesBuilder acceptedNames;
    private ArrayList<CustomResourceDefinitionConditionBuilder> conditions = new ArrayList();
    private List<String> storedVersions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CustomResourceDefinitionStatusFluent() {
    }

    public CustomResourceDefinitionStatusFluent(CustomResourceDefinitionStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomResourceDefinitionStatus instance) {
        CustomResourceDefinitionStatus customResourceDefinitionStatus = instance = instance != null ? instance : new CustomResourceDefinitionStatus();
        if (instance != null) {
            this.withAcceptedNames(instance.getAcceptedNames());
            this.withConditions(instance.getConditions());
            this.withStoredVersions(instance.getStoredVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CustomResourceDefinitionNames buildAcceptedNames() {
        return this.acceptedNames != null ? this.acceptedNames.build() : null;
    }

    public A withAcceptedNames(CustomResourceDefinitionNames acceptedNames) {
        this._visitables.remove("acceptedNames");
        if (acceptedNames != null) {
            this.acceptedNames = new CustomResourceDefinitionNamesBuilder(acceptedNames);
            this._visitables.get("acceptedNames").add(this.acceptedNames);
        } else {
            this.acceptedNames = null;
            this._visitables.get("acceptedNames").remove(this.acceptedNames);
        }
        return (A)this;
    }

    public boolean hasAcceptedNames() {
        return this.acceptedNames != null;
    }

    public AcceptedNamesNested<A> withNewAcceptedNames() {
        return new AcceptedNamesNested(null);
    }

    public AcceptedNamesNested<A> withNewAcceptedNamesLike(CustomResourceDefinitionNames item) {
        return new AcceptedNamesNested(item);
    }

    public AcceptedNamesNested<A> editAcceptedNames() {
        return this.withNewAcceptedNamesLike(Optional.ofNullable(this.buildAcceptedNames()).orElse(null));
    }

    public AcceptedNamesNested<A> editOrNewAcceptedNames() {
        return this.withNewAcceptedNamesLike(Optional.ofNullable(this.buildAcceptedNames()).orElse(new CustomResourceDefinitionNamesBuilder().build()));
    }

    public AcceptedNamesNested<A> editOrNewAcceptedNamesLike(CustomResourceDefinitionNames item) {
        return this.withNewAcceptedNamesLike(Optional.ofNullable(this.buildAcceptedNames()).orElse(item));
    }

    public A addToConditions(int index, CustomResourceDefinitionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, CustomResourceDefinitionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(CustomResourceDefinitionCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (CustomResourceDefinitionCondition item : items) {
            CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<CustomResourceDefinitionCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (CustomResourceDefinitionCondition item : items) {
            CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(CustomResourceDefinitionCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (CustomResourceDefinitionCondition item : items) {
            CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<CustomResourceDefinitionCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (CustomResourceDefinitionCondition item : items) {
            CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<CustomResourceDefinitionConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<CustomResourceDefinitionConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            CustomResourceDefinitionConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<CustomResourceDefinitionCondition> buildConditions() {
        return this.conditions != null ? CustomResourceDefinitionStatusFluent.build(this.conditions) : null;
    }

    public CustomResourceDefinitionCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public CustomResourceDefinitionCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public CustomResourceDefinitionCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public CustomResourceDefinitionCondition buildMatchingCondition(Predicate<CustomResourceDefinitionConditionBuilder> predicate) {
        for (CustomResourceDefinitionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<CustomResourceDefinitionConditionBuilder> predicate) {
        for (CustomResourceDefinitionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<CustomResourceDefinitionCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (CustomResourceDefinitionCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(CustomResourceDefinitionCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (CustomResourceDefinitionCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new CustomResourceDefinitionCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(CustomResourceDefinitionCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, CustomResourceDefinitionCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<CustomResourceDefinitionConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToStoredVersions(int index, String item) {
        if (this.storedVersions == null) {
            this.storedVersions = new ArrayList<String>();
        }
        this.storedVersions.add(index, item);
        return (A)this;
    }

    public A setToStoredVersions(int index, String item) {
        if (this.storedVersions == null) {
            this.storedVersions = new ArrayList<String>();
        }
        this.storedVersions.set(index, item);
        return (A)this;
    }

    public A addToStoredVersions(String ... items) {
        if (this.storedVersions == null) {
            this.storedVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.storedVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToStoredVersions(Collection<String> items) {
        if (this.storedVersions == null) {
            this.storedVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.storedVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromStoredVersions(String ... items) {
        if (this.storedVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.storedVersions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromStoredVersions(Collection<String> items) {
        if (this.storedVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.storedVersions.remove(item);
        }
        return (A)this;
    }

    public List<String> getStoredVersions() {
        return this.storedVersions;
    }

    public String getStoredVersion(int index) {
        return this.storedVersions.get(index);
    }

    public String getFirstStoredVersion() {
        return this.storedVersions.get(0);
    }

    public String getLastStoredVersion() {
        return this.storedVersions.get(this.storedVersions.size() - 1);
    }

    public String getMatchingStoredVersion(Predicate<String> predicate) {
        for (String item : this.storedVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingStoredVersion(Predicate<String> predicate) {
        for (String item : this.storedVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStoredVersions(List<String> storedVersions) {
        if (storedVersions != null) {
            this.storedVersions = new ArrayList<String>();
            for (String item : storedVersions) {
                this.addToStoredVersions(item);
            }
        } else {
            this.storedVersions = null;
        }
        return (A)this;
    }

    public A withStoredVersions(String ... storedVersions) {
        if (this.storedVersions != null) {
            this.storedVersions.clear();
            this._visitables.remove("storedVersions");
        }
        if (storedVersions != null) {
            for (String item : storedVersions) {
                this.addToStoredVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasStoredVersions() {
        return this.storedVersions != null && !this.storedVersions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceDefinitionStatusFluent that = (CustomResourceDefinitionStatusFluent)o;
        if (!Objects.equals(this.acceptedNames, that.acceptedNames)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.storedVersions, that.storedVersions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.acceptedNames, this.conditions, this.storedVersions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptedNames != null) {
            sb.append("acceptedNames:");
            sb.append(this.acceptedNames + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.storedVersions != null && !this.storedVersions.isEmpty()) {
            sb.append("storedVersions:");
            sb.append(this.storedVersions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends CustomResourceDefinitionConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        CustomResourceDefinitionConditionBuilder builder;
        int index;

        ConditionsNested(int index, CustomResourceDefinitionCondition item) {
            this.index = index;
            this.builder = new CustomResourceDefinitionConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AcceptedNamesNested<N>
    extends CustomResourceDefinitionNamesFluent<AcceptedNamesNested<N>>
    implements Nested<N> {
        CustomResourceDefinitionNamesBuilder builder;

        AcceptedNamesNested(CustomResourceDefinitionNames item) {
            this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionStatusFluent.this.withAcceptedNames(this.builder.build());
        }

        public N endAcceptedNames() {
            return this.and();
        }
    }
}

