/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.ScopeSelector;
import io.fabric8.kubernetes.api.model.v6_13.ScopedResourceSelectorRequirement;
import io.fabric8.kubernetes.api.model.v6_13.ScopedResourceSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.v6_13.ScopedResourceSelectorRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ScopeSelectorFluent<A extends ScopeSelectorFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ScopedResourceSelectorRequirementBuilder> matchExpressions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ScopeSelectorFluent() {
    }

    public ScopeSelectorFluent(ScopeSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ScopeSelector instance) {
        ScopeSelector scopeSelector = instance = instance != null ? instance : new ScopeSelector();
        if (instance != null) {
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMatchExpressions(int index, ScopedResourceSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get("matchExpressions").add(index, builder);
            this.matchExpressions.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchExpressions(int index, ScopedResourceSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get("matchExpressions").set(index, builder);
            this.matchExpressions.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchExpressions(ScopedResourceSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchExpressions(Collection<ScopedResourceSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchExpressions(ScopedResourceSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<ScopedResourceSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchExpressions(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        Iterator<ScopedResourceSelectorRequirementBuilder> each = this.matchExpressions.iterator();
        Object visitables = this._visitables.get("matchExpressions");
        while (each.hasNext()) {
            ScopedResourceSelectorRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ScopedResourceSelectorRequirement> buildMatchExpressions() {
        return this.matchExpressions != null ? ScopeSelectorFluent.build(this.matchExpressions) : null;
    }

    public ScopedResourceSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    public ScopedResourceSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    public ScopedResourceSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    public ScopedResourceSelectorRequirement buildMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        for (ScopedResourceSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        for (ScopedResourceSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchExpressions(List<ScopedResourceSelectorRequirement> matchExpressions) {
        if (this.matchExpressions != null) {
            this._visitables.get("matchExpressions").clear();
        }
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList();
            for (ScopedResourceSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)this;
    }

    public A withMatchExpressions(ScopedResourceSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove("matchExpressions");
        }
        if (matchExpressions != null) {
            for (ScopedResourceSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNested(-1, null);
    }

    public MatchExpressionsNested<A> addNewMatchExpressionLike(ScopedResourceSelectorRequirement item) {
        return new MatchExpressionsNested(-1, item);
    }

    public MatchExpressionsNested<A> setNewMatchExpressionLike(int index, ScopedResourceSelectorRequirement item) {
        return new MatchExpressionsNested(index, item);
    }

    public MatchExpressionsNested<A> editMatchExpression(int index) {
        if (this.matchExpressions.size() <= index) {
            throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    public MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.test(this.matchExpressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopeSelectorFluent that = (ScopeSelectorFluent)o;
        if (!Objects.equals(this.matchExpressions, that.matchExpressions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(this.matchExpressions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchExpressionsNested<N>
    extends ScopedResourceSelectorRequirementFluent<MatchExpressionsNested<N>>
    implements Nested<N> {
        ScopedResourceSelectorRequirementBuilder builder;
        int index;

        MatchExpressionsNested(int index, ScopedResourceSelectorRequirement item) {
            this.index = index;
            this.builder = new ScopedResourceSelectorRequirementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ScopeSelectorFluent.this.setToMatchExpressions(this.index, this.builder.build());
        }

        public N endMatchExpression() {
            return this.and();
        }
    }
}

