/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.EndpointAddress;
import io.fabric8.kubernetes.api.model.v6_13.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.v6_13.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.v6_13.EndpointPort;
import io.fabric8.kubernetes.api.model.v6_13.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.v6_13.EndpointPortFluent;
import io.fabric8.kubernetes.api.model.v6_13.EndpointSubset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointSubsetFluent<A extends EndpointSubsetFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EndpointAddressBuilder> addresses = new ArrayList();
    private ArrayList<EndpointAddressBuilder> notReadyAddresses = new ArrayList();
    private ArrayList<EndpointPortBuilder> ports = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EndpointSubsetFluent() {
    }

    public EndpointSubsetFluent(EndpointSubset instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EndpointSubset instance) {
        EndpointSubset endpointSubset = instance = instance != null ? instance : new EndpointSubset();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withNotReadyAddresses(instance.getNotReadyAddresses());
            this.withPorts(instance.getPorts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToAddresses(EndpointAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToAddresses(Collection<EndpointAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromAddresses(EndpointAddress ... items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAddresses(Collection<EndpointAddress> items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<EndpointAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<EndpointAddress> buildAddresses() {
        return this.addresses != null ? EndpointSubsetFluent.build(this.addresses) : null;
    }

    public EndpointAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public EndpointAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public EndpointAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public EndpointAddress buildMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<EndpointAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    public A withAddresses(EndpointAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(EndpointAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, EndpointAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get("notReadyAddresses").add(index, builder);
            this.notReadyAddresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get("notReadyAddresses").set(index, builder);
            this.notReadyAddresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToNotReadyAddresses(EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToNotReadyAddresses(Collection<EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromNotReadyAddresses(EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNotReadyAddresses(Collection<EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNotReadyAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        Iterator<EndpointAddressBuilder> each = this.notReadyAddresses.iterator();
        Object visitables = this._visitables.get("notReadyAddresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<EndpointAddress> buildNotReadyAddresses() {
        return this.notReadyAddresses != null ? EndpointSubsetFluent.build(this.notReadyAddresses) : null;
    }

    public EndpointAddress buildNotReadyAddress(int index) {
        return this.notReadyAddresses.get(index).build();
    }

    public EndpointAddress buildFirstNotReadyAddress() {
        return this.notReadyAddresses.get(0).build();
    }

    public EndpointAddress buildLastNotReadyAddress() {
        return this.notReadyAddresses.get(this.notReadyAddresses.size() - 1).build();
    }

    public EndpointAddress buildMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this._visitables.get("notReadyAddresses").clear();
        }
        if (notReadyAddresses != null) {
            this.notReadyAddresses = new ArrayList();
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        } else {
            this.notReadyAddresses = null;
        }
        return (A)this;
    }

    public A withNotReadyAddresses(EndpointAddress ... notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this.notReadyAddresses.clear();
            this._visitables.remove("notReadyAddresses");
        }
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasNotReadyAddresses() {
        return this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty();
    }

    public NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNested(-1, null);
    }

    public NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item) {
        return new NotReadyAddressesNested(-1, item);
    }

    public NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index, EndpointAddress item) {
        return new NotReadyAddressesNested(index, item);
    }

    public NotReadyAddressesNested<A> editNotReadyAddress(int index) {
        if (this.notReadyAddresses.size() <= index) {
            throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public NotReadyAddressesNested<A> editFirstNotReadyAddress() {
        if (this.notReadyAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(0, this.buildNotReadyAddress(0));
    }

    public NotReadyAddressesNested<A> editLastNotReadyAddress() {
        int index = this.notReadyAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.notReadyAddresses.size(); ++i) {
            if (!predicate.test(this.notReadyAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public A addToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(EndpointPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<EndpointPort> buildPorts() {
        return this.ports != null ? EndpointSubsetFluent.build(this.ports) : null;
    }

    public EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public A addNewPort(String appProtocol, String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(appProtocol, name, port, protocol));
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, EndpointPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSubsetFluent that = (EndpointSubsetFluent)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.notReadyAddresses, that.notReadyAddresses)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty()) {
            sb.append("notReadyAddresses:");
            sb.append(this.notReadyAddresses + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortsNested<N>
    extends EndpointPortFluent<PortsNested<N>>
    implements Nested<N> {
        EndpointPortBuilder builder;
        int index;

        PortsNested(int index, EndpointPort item) {
            this.index = index;
            this.builder = new EndpointPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class NotReadyAddressesNested<N>
    extends EndpointAddressFluent<NotReadyAddressesNested<N>>
    implements Nested<N> {
        EndpointAddressBuilder builder;
        int index;

        NotReadyAddressesNested(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluent.this.setToNotReadyAddresses(this.index, this.builder.build());
        }

        public N endNotReadyAddress() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends EndpointAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        EndpointAddressBuilder builder;
        int index;

        AddressesNested(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

