/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.v6_13.Editable;
import io.fabric8.kubernetes.api.model.v6_13.APIResource;
import io.fabric8.kubernetes.api.model.v6_13.APIResourceListBuilder;
import io.fabric8.kubernetes.api.model.v6_13.KubernetesResource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "groupVersion", "resources"})
public class APIResourceList
implements Editable<APIResourceListBuilder>,
KubernetesResource {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @JsonProperty(value="groupVersion")
    private String groupVersion;
    @JsonProperty(value="kind")
    private String kind = "APIResourceList";
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<APIResource> resources = new ArrayList<APIResource>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public APIResourceList() {
    }

    public APIResourceList(String apiVersion, String groupVersion, String kind, List<APIResource> resources) {
        this.apiVersion = apiVersion;
        this.groupVersion = groupVersion;
        this.kind = kind;
        this.resources = resources;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="groupVersion")
    public String getGroupVersion() {
        return this.groupVersion;
    }

    @JsonProperty(value="groupVersion")
    public void setGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<APIResource> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(List<APIResource> resources) {
        this.resources = resources;
    }

    @Override
    @JsonIgnore
    public APIResourceListBuilder edit() {
        return new APIResourceListBuilder(this);
    }

    @JsonIgnore
    public APIResourceListBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String toString() {
        return "APIResourceList(apiVersion=" + this.getApiVersion() + ", groupVersion=" + this.getGroupVersion() + ", kind=" + this.getKind() + ", resources=" + this.getResources() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIResourceList)) {
            return false;
        }
        APIResourceList other = (APIResourceList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$groupVersion = this.getGroupVersion();
        String other$groupVersion = other.getGroupVersion();
        if (this$groupVersion == null ? other$groupVersion != null : !this$groupVersion.equals(other$groupVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        List<APIResource> this$resources = this.getResources();
        List<APIResource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof APIResourceList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $groupVersion = this.getGroupVersion();
        result = result * 59 + ($groupVersion == null ? 43 : $groupVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        List<APIResource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

