/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.UnhealthyCondition;
import io.fabric8.openshift.api.model.machine.v1beta1.UnhealthyConditionBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.UnhealthyConditionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineHealthCheckSpecFluent<A extends MachineHealthCheckSpecFluent<A>>
extends BaseFluent<A> {
    private IntOrStringBuilder maxUnhealthy;
    private Duration nodeStartupTimeout;
    private ObjectReferenceBuilder remediationTemplate;
    private LabelSelectorBuilder selector;
    private ArrayList<UnhealthyConditionBuilder> unhealthyConditions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MachineHealthCheckSpecFluent() {
    }

    public MachineHealthCheckSpecFluent(MachineHealthCheckSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineHealthCheckSpec instance) {
        MachineHealthCheckSpec machineHealthCheckSpec = instance = instance != null ? instance : new MachineHealthCheckSpec();
        if (instance != null) {
            this.withMaxUnhealthy(instance.getMaxUnhealthy());
            this.withNodeStartupTimeout(instance.getNodeStartupTimeout());
            this.withRemediationTemplate(instance.getRemediationTemplate());
            this.withSelector(instance.getSelector());
            this.withUnhealthyConditions(instance.getUnhealthyConditions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IntOrString buildMaxUnhealthy() {
        return this.maxUnhealthy != null ? this.maxUnhealthy.build() : null;
    }

    public A withMaxUnhealthy(IntOrString maxUnhealthy) {
        this._visitables.remove("maxUnhealthy");
        if (maxUnhealthy != null) {
            this.maxUnhealthy = new IntOrStringBuilder(maxUnhealthy);
            this._visitables.get("maxUnhealthy").add(this.maxUnhealthy);
        } else {
            this.maxUnhealthy = null;
            this._visitables.get("maxUnhealthy").remove(this.maxUnhealthy);
        }
        return (A)this;
    }

    public boolean hasMaxUnhealthy() {
        return this.maxUnhealthy != null;
    }

    public A withNewMaxUnhealthy(Object value) {
        return this.withMaxUnhealthy(new IntOrString(value));
    }

    public MaxUnhealthyNested<A> withNewMaxUnhealthy() {
        return new MaxUnhealthyNested(null);
    }

    public MaxUnhealthyNested<A> withNewMaxUnhealthyLike(IntOrString item) {
        return new MaxUnhealthyNested(item);
    }

    public MaxUnhealthyNested<A> editMaxUnhealthy() {
        return this.withNewMaxUnhealthyLike(Optional.ofNullable(this.buildMaxUnhealthy()).orElse(null));
    }

    public MaxUnhealthyNested<A> editOrNewMaxUnhealthy() {
        return this.withNewMaxUnhealthyLike(Optional.ofNullable(this.buildMaxUnhealthy()).orElse(new IntOrStringBuilder().build()));
    }

    public MaxUnhealthyNested<A> editOrNewMaxUnhealthyLike(IntOrString item) {
        return this.withNewMaxUnhealthyLike(Optional.ofNullable(this.buildMaxUnhealthy()).orElse(item));
    }

    public Duration getNodeStartupTimeout() {
        return this.nodeStartupTimeout;
    }

    public A withNodeStartupTimeout(Duration nodeStartupTimeout) {
        this.nodeStartupTimeout = nodeStartupTimeout;
        return (A)this;
    }

    public boolean hasNodeStartupTimeout() {
        return this.nodeStartupTimeout != null;
    }

    public ObjectReference buildRemediationTemplate() {
        return this.remediationTemplate != null ? this.remediationTemplate.build() : null;
    }

    public A withRemediationTemplate(ObjectReference remediationTemplate) {
        this._visitables.remove("remediationTemplate");
        if (remediationTemplate != null) {
            this.remediationTemplate = new ObjectReferenceBuilder(remediationTemplate);
            this._visitables.get("remediationTemplate").add(this.remediationTemplate);
        } else {
            this.remediationTemplate = null;
            this._visitables.get("remediationTemplate").remove(this.remediationTemplate);
        }
        return (A)this;
    }

    public boolean hasRemediationTemplate() {
        return this.remediationTemplate != null;
    }

    public RemediationTemplateNested<A> withNewRemediationTemplate() {
        return new RemediationTemplateNested(null);
    }

    public RemediationTemplateNested<A> withNewRemediationTemplateLike(ObjectReference item) {
        return new RemediationTemplateNested(item);
    }

    public RemediationTemplateNested<A> editRemediationTemplate() {
        return this.withNewRemediationTemplateLike(Optional.ofNullable(this.buildRemediationTemplate()).orElse(null));
    }

    public RemediationTemplateNested<A> editOrNewRemediationTemplate() {
        return this.withNewRemediationTemplateLike(Optional.ofNullable(this.buildRemediationTemplate()).orElse(new ObjectReferenceBuilder().build()));
    }

    public RemediationTemplateNested<A> editOrNewRemediationTemplateLike(ObjectReference item) {
        return this.withNewRemediationTemplateLike(Optional.ofNullable(this.buildRemediationTemplate()).orElse(item));
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public A addToUnhealthyConditions(int index, UnhealthyCondition item) {
        if (this.unhealthyConditions == null) {
            this.unhealthyConditions = new ArrayList();
        }
        UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
        if (index < 0 || index >= this.unhealthyConditions.size()) {
            this._visitables.get("unhealthyConditions").add(builder);
            this.unhealthyConditions.add(builder);
        } else {
            this._visitables.get("unhealthyConditions").add(index, builder);
            this.unhealthyConditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToUnhealthyConditions(int index, UnhealthyCondition item) {
        if (this.unhealthyConditions == null) {
            this.unhealthyConditions = new ArrayList();
        }
        UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
        if (index < 0 || index >= this.unhealthyConditions.size()) {
            this._visitables.get("unhealthyConditions").add(builder);
            this.unhealthyConditions.add(builder);
        } else {
            this._visitables.get("unhealthyConditions").set(index, builder);
            this.unhealthyConditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToUnhealthyConditions(UnhealthyCondition ... items) {
        if (this.unhealthyConditions == null) {
            this.unhealthyConditions = new ArrayList();
        }
        for (UnhealthyCondition item : items) {
            UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
            this._visitables.get("unhealthyConditions").add(builder);
            this.unhealthyConditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToUnhealthyConditions(Collection<UnhealthyCondition> items) {
        if (this.unhealthyConditions == null) {
            this.unhealthyConditions = new ArrayList();
        }
        for (UnhealthyCondition item : items) {
            UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
            this._visitables.get("unhealthyConditions").add(builder);
            this.unhealthyConditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromUnhealthyConditions(UnhealthyCondition ... items) {
        if (this.unhealthyConditions == null) {
            return (A)this;
        }
        for (UnhealthyCondition item : items) {
            UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
            this._visitables.get("unhealthyConditions").remove(builder);
            this.unhealthyConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromUnhealthyConditions(Collection<UnhealthyCondition> items) {
        if (this.unhealthyConditions == null) {
            return (A)this;
        }
        for (UnhealthyCondition item : items) {
            UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
            this._visitables.get("unhealthyConditions").remove(builder);
            this.unhealthyConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromUnhealthyConditions(Predicate<UnhealthyConditionBuilder> predicate) {
        if (this.unhealthyConditions == null) {
            return (A)this;
        }
        Iterator<UnhealthyConditionBuilder> each = this.unhealthyConditions.iterator();
        Object visitables = this._visitables.get("unhealthyConditions");
        while (each.hasNext()) {
            UnhealthyConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<UnhealthyCondition> buildUnhealthyConditions() {
        return this.unhealthyConditions != null ? MachineHealthCheckSpecFluent.build(this.unhealthyConditions) : null;
    }

    public UnhealthyCondition buildUnhealthyCondition(int index) {
        return this.unhealthyConditions.get(index).build();
    }

    public UnhealthyCondition buildFirstUnhealthyCondition() {
        return this.unhealthyConditions.get(0).build();
    }

    public UnhealthyCondition buildLastUnhealthyCondition() {
        return this.unhealthyConditions.get(this.unhealthyConditions.size() - 1).build();
    }

    public UnhealthyCondition buildMatchingUnhealthyCondition(Predicate<UnhealthyConditionBuilder> predicate) {
        for (UnhealthyConditionBuilder item : this.unhealthyConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingUnhealthyCondition(Predicate<UnhealthyConditionBuilder> predicate) {
        for (UnhealthyConditionBuilder item : this.unhealthyConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUnhealthyConditions(List<UnhealthyCondition> unhealthyConditions) {
        if (this.unhealthyConditions != null) {
            this._visitables.get("unhealthyConditions").clear();
        }
        if (unhealthyConditions != null) {
            this.unhealthyConditions = new ArrayList();
            for (UnhealthyCondition item : unhealthyConditions) {
                this.addToUnhealthyConditions(item);
            }
        } else {
            this.unhealthyConditions = null;
        }
        return (A)this;
    }

    public A withUnhealthyConditions(UnhealthyCondition ... unhealthyConditions) {
        if (this.unhealthyConditions != null) {
            this.unhealthyConditions.clear();
            this._visitables.remove("unhealthyConditions");
        }
        if (unhealthyConditions != null) {
            for (UnhealthyCondition item : unhealthyConditions) {
                this.addToUnhealthyConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasUnhealthyConditions() {
        return this.unhealthyConditions != null && !this.unhealthyConditions.isEmpty();
    }

    public UnhealthyConditionsNested<A> addNewUnhealthyCondition() {
        return new UnhealthyConditionsNested(-1, null);
    }

    public UnhealthyConditionsNested<A> addNewUnhealthyConditionLike(UnhealthyCondition item) {
        return new UnhealthyConditionsNested(-1, item);
    }

    public UnhealthyConditionsNested<A> setNewUnhealthyConditionLike(int index, UnhealthyCondition item) {
        return new UnhealthyConditionsNested(index, item);
    }

    public UnhealthyConditionsNested<A> editUnhealthyCondition(int index) {
        if (this.unhealthyConditions.size() <= index) {
            throw new RuntimeException("Can't edit unhealthyConditions. Index exceeds size.");
        }
        return this.setNewUnhealthyConditionLike(index, this.buildUnhealthyCondition(index));
    }

    public UnhealthyConditionsNested<A> editFirstUnhealthyCondition() {
        if (this.unhealthyConditions.size() == 0) {
            throw new RuntimeException("Can't edit first unhealthyConditions. The list is empty.");
        }
        return this.setNewUnhealthyConditionLike(0, this.buildUnhealthyCondition(0));
    }

    public UnhealthyConditionsNested<A> editLastUnhealthyCondition() {
        int index = this.unhealthyConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last unhealthyConditions. The list is empty.");
        }
        return this.setNewUnhealthyConditionLike(index, this.buildUnhealthyCondition(index));
    }

    public UnhealthyConditionsNested<A> editMatchingUnhealthyCondition(Predicate<UnhealthyConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.unhealthyConditions.size(); ++i) {
            if (!predicate.test(this.unhealthyConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching unhealthyConditions. No match found.");
        }
        return this.setNewUnhealthyConditionLike(index, this.buildUnhealthyCondition(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineHealthCheckSpecFluent that = (MachineHealthCheckSpecFluent)o;
        if (!Objects.equals(this.maxUnhealthy, that.maxUnhealthy)) {
            return false;
        }
        if (!Objects.equals(this.nodeStartupTimeout, that.nodeStartupTimeout)) {
            return false;
        }
        if (!Objects.equals(this.remediationTemplate, that.remediationTemplate)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.unhealthyConditions, that.unhealthyConditions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxUnhealthy, this.nodeStartupTimeout, this.remediationTemplate, this.selector, this.unhealthyConditions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxUnhealthy != null) {
            sb.append("maxUnhealthy:");
            sb.append(this.maxUnhealthy + ",");
        }
        if (this.nodeStartupTimeout != null) {
            sb.append("nodeStartupTimeout:");
            sb.append(this.nodeStartupTimeout + ",");
        }
        if (this.remediationTemplate != null) {
            sb.append("remediationTemplate:");
            sb.append(this.remediationTemplate + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.unhealthyConditions != null && !this.unhealthyConditions.isEmpty()) {
            sb.append("unhealthyConditions:");
            sb.append(this.unhealthyConditions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UnhealthyConditionsNested<N>
    extends UnhealthyConditionFluent<UnhealthyConditionsNested<N>>
    implements Nested<N> {
        UnhealthyConditionBuilder builder;
        int index;

        UnhealthyConditionsNested(int index, UnhealthyCondition item) {
            this.index = index;
            this.builder = new UnhealthyConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineHealthCheckSpecFluent.this.setToUnhealthyConditions(this.index, this.builder.build());
        }

        public N endUnhealthyCondition() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineHealthCheckSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class RemediationTemplateNested<N>
    extends ObjectReferenceFluent<RemediationTemplateNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        RemediationTemplateNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineHealthCheckSpecFluent.this.withRemediationTemplate(this.builder.build());
        }

        public N endRemediationTemplate() {
            return this.and();
        }
    }

    public class MaxUnhealthyNested<N>
    extends IntOrStringFluent<MaxUnhealthyNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        MaxUnhealthyNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineHealthCheckSpecFluent.this.withMaxUnhealthy(this.builder.build());
        }

        public N endMaxUnhealthy() {
            return this.and();
        }
    }
}

