/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.ConfigMapBuildSource;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.SecretBuildSource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"binary", "configMaps", "contextDir", "dockerfile", "git", "images", "secrets", "sourceSecret", "type"})
public class BuildSource
implements Editable<BuildSourceBuilder>,
KubernetesResource {
    @JsonProperty(value="binary")
    private BinaryBuildSource binary;
    @JsonProperty(value="configMaps")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ConfigMapBuildSource> configMaps = new ArrayList<ConfigMapBuildSource>();
    @JsonProperty(value="contextDir")
    private String contextDir;
    @JsonProperty(value="dockerfile")
    private String dockerfile;
    @JsonProperty(value="git")
    private GitBuildSource git;
    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ImageSource> images = new ArrayList<ImageSource>();
    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<SecretBuildSource> secrets = new ArrayList<SecretBuildSource>();
    @JsonProperty(value="sourceSecret")
    private LocalObjectReference sourceSecret;
    @JsonProperty(value="type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public BuildSource() {
    }

    public BuildSource(BinaryBuildSource binary, List<ConfigMapBuildSource> configMaps, String contextDir, String dockerfile, GitBuildSource git, List<ImageSource> images, List<SecretBuildSource> secrets, LocalObjectReference sourceSecret, String type) {
        this.binary = binary;
        this.configMaps = configMaps;
        this.contextDir = contextDir;
        this.dockerfile = dockerfile;
        this.git = git;
        this.images = images;
        this.secrets = secrets;
        this.sourceSecret = sourceSecret;
        this.type = type;
    }

    @JsonProperty(value="binary")
    public BinaryBuildSource getBinary() {
        return this.binary;
    }

    @JsonProperty(value="binary")
    public void setBinary(BinaryBuildSource binary) {
        this.binary = binary;
    }

    @JsonProperty(value="configMaps")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ConfigMapBuildSource> getConfigMaps() {
        return this.configMaps;
    }

    @JsonProperty(value="configMaps")
    public void setConfigMaps(List<ConfigMapBuildSource> configMaps) {
        this.configMaps = configMaps;
    }

    @JsonProperty(value="contextDir")
    public String getContextDir() {
        return this.contextDir;
    }

    @JsonProperty(value="contextDir")
    public void setContextDir(String contextDir) {
        this.contextDir = contextDir;
    }

    @JsonProperty(value="dockerfile")
    public String getDockerfile() {
        return this.dockerfile;
    }

    @JsonProperty(value="dockerfile")
    public void setDockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
    }

    @JsonProperty(value="git")
    public GitBuildSource getGit() {
        return this.git;
    }

    @JsonProperty(value="git")
    public void setGit(GitBuildSource git) {
        this.git = git;
    }

    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ImageSource> getImages() {
        return this.images;
    }

    @JsonProperty(value="images")
    public void setImages(List<ImageSource> images) {
        this.images = images;
    }

    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<SecretBuildSource> getSecrets() {
        return this.secrets;
    }

    @JsonProperty(value="secrets")
    public void setSecrets(List<SecretBuildSource> secrets) {
        this.secrets = secrets;
    }

    @JsonProperty(value="sourceSecret")
    public LocalObjectReference getSourceSecret() {
        return this.sourceSecret;
    }

    @JsonProperty(value="sourceSecret")
    public void setSourceSecret(LocalObjectReference sourceSecret) {
        this.sourceSecret = sourceSecret;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @Override
    @JsonIgnore
    public BuildSourceBuilder edit() {
        return new BuildSourceBuilder(this);
    }

    @JsonIgnore
    public BuildSourceBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "BuildSource(binary=" + this.getBinary() + ", configMaps=" + this.getConfigMaps() + ", contextDir=" + this.getContextDir() + ", dockerfile=" + this.getDockerfile() + ", git=" + this.getGit() + ", images=" + this.getImages() + ", secrets=" + this.getSecrets() + ", sourceSecret=" + this.getSourceSecret() + ", type=" + this.getType() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildSource)) {
            return false;
        }
        BuildSource other = (BuildSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BinaryBuildSource this$binary = this.getBinary();
        BinaryBuildSource other$binary = other.getBinary();
        if (this$binary == null ? other$binary != null : !((Object)this$binary).equals(other$binary)) {
            return false;
        }
        List<ConfigMapBuildSource> this$configMaps = this.getConfigMaps();
        List<ConfigMapBuildSource> other$configMaps = other.getConfigMaps();
        if (this$configMaps == null ? other$configMaps != null : !((Object)this$configMaps).equals(other$configMaps)) {
            return false;
        }
        String this$contextDir = this.getContextDir();
        String other$contextDir = other.getContextDir();
        if (this$contextDir == null ? other$contextDir != null : !this$contextDir.equals(other$contextDir)) {
            return false;
        }
        String this$dockerfile = this.getDockerfile();
        String other$dockerfile = other.getDockerfile();
        if (this$dockerfile == null ? other$dockerfile != null : !this$dockerfile.equals(other$dockerfile)) {
            return false;
        }
        GitBuildSource this$git = this.getGit();
        GitBuildSource other$git = other.getGit();
        if (this$git == null ? other$git != null : !((Object)this$git).equals(other$git)) {
            return false;
        }
        List<ImageSource> this$images = this.getImages();
        List<ImageSource> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        List<SecretBuildSource> this$secrets = this.getSecrets();
        List<SecretBuildSource> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        LocalObjectReference this$sourceSecret = this.getSourceSecret();
        LocalObjectReference other$sourceSecret = other.getSourceSecret();
        if (this$sourceSecret == null ? other$sourceSecret != null : !((Object)this$sourceSecret).equals(other$sourceSecret)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BinaryBuildSource $binary = this.getBinary();
        result = result * 59 + ($binary == null ? 43 : ((Object)$binary).hashCode());
        List<ConfigMapBuildSource> $configMaps = this.getConfigMaps();
        result = result * 59 + ($configMaps == null ? 43 : ((Object)$configMaps).hashCode());
        String $contextDir = this.getContextDir();
        result = result * 59 + ($contextDir == null ? 43 : $contextDir.hashCode());
        String $dockerfile = this.getDockerfile();
        result = result * 59 + ($dockerfile == null ? 43 : $dockerfile.hashCode());
        GitBuildSource $git = this.getGit();
        result = result * 59 + ($git == null ? 43 : ((Object)$git).hashCode());
        List<ImageSource> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        List<SecretBuildSource> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        LocalObjectReference $sourceSecret = this.getSourceSecret();
        result = result * 59 + ($sourceSecret == null ? 43 : ((Object)$sourceSecret).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

