/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.Authorization;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.AuthorizationBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.AuthorizationFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.MetadataConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.MetadataConfigBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.MetadataConfigFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.QueueConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.QueueConfigBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.QueueConfigFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.RelabelConfigFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.RemoteWriteSpec;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.Sigv4;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.Sigv4Builder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.Sigv4Fluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.TLSConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RemoteWriteSpecFluent<A extends RemoteWriteSpecFluent<A>>
extends BaseFluent<A> {
    private AuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private Map<String, String> headers;
    private MetadataConfigBuilder metadataConfig;
    private String name;
    private OAuth2Builder oauth2;
    private String proxyUrl;
    private QueueConfigBuilder queueConfig;
    private String remoteTimeout;
    private Boolean sendExemplars;
    private Boolean sendNativeHistograms;
    private Sigv4Builder sigv4;
    private TLSConfigBuilder tlsConfig;
    private String url;
    private ArrayList<RelabelConfigBuilder> writeRelabelConfigs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RemoteWriteSpecFluent() {
    }

    public RemoteWriteSpecFluent(RemoteWriteSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RemoteWriteSpec instance) {
        RemoteWriteSpec remoteWriteSpec = instance = instance != null ? instance : new RemoteWriteSpec();
        if (instance != null) {
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerToken(instance.getBearerToken());
            this.withBearerTokenFile(instance.getBearerTokenFile());
            this.withHeaders(instance.getHeaders());
            this.withMetadataConfig(instance.getMetadataConfig());
            this.withName(instance.getName());
            this.withOauth2(instance.getOauth2());
            this.withProxyUrl(instance.getProxyUrl());
            this.withQueueConfig(instance.getQueueConfig());
            this.withRemoteTimeout(instance.getRemoteTimeout());
            this.withSendExemplars(instance.getSendExemplars());
            this.withSendNativeHistograms(instance.getSendNativeHistograms());
            this.withSigv4(instance.getSigv4());
            this.withTlsConfig(instance.getTlsConfig());
            this.withUrl(instance.getUrl());
            this.withWriteRelabelConfigs(instance.getWriteRelabelConfigs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Authorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(Authorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new AuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new AuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove("basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get("basicAuth").remove(this.basicAuth);
        }
        return (A)this;
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public A withBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return (A)this;
    }

    public boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return (A)this;
    }

    public boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public A addToHeaders(String key, String value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)this;
    }

    public A addToHeaders(Map<String, String> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)this;
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)this;
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)this;
    }

    public A removeFromHeaders(Map<String, String> map) {
        if (this.headers == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public <K, V> A withHeaders(Map<String, String> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, String>(headers);
        return (A)this;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public MetadataConfig buildMetadataConfig() {
        return this.metadataConfig != null ? this.metadataConfig.build() : null;
    }

    public A withMetadataConfig(MetadataConfig metadataConfig) {
        this._visitables.remove("metadataConfig");
        if (metadataConfig != null) {
            this.metadataConfig = new MetadataConfigBuilder(metadataConfig);
            this._visitables.get("metadataConfig").add(this.metadataConfig);
        } else {
            this.metadataConfig = null;
            this._visitables.get("metadataConfig").remove(this.metadataConfig);
        }
        return (A)this;
    }

    public boolean hasMetadataConfig() {
        return this.metadataConfig != null;
    }

    public A withNewMetadataConfig(Boolean send, String sendInterval) {
        return this.withMetadataConfig(new MetadataConfig(send, sendInterval));
    }

    public MetadataConfigNested<A> withNewMetadataConfig() {
        return new MetadataConfigNested(null);
    }

    public MetadataConfigNested<A> withNewMetadataConfigLike(MetadataConfig item) {
        return new MetadataConfigNested(item);
    }

    public MetadataConfigNested<A> editMetadataConfig() {
        return this.withNewMetadataConfigLike(Optional.ofNullable(this.buildMetadataConfig()).orElse(null));
    }

    public MetadataConfigNested<A> editOrNewMetadataConfig() {
        return this.withNewMetadataConfigLike(Optional.ofNullable(this.buildMetadataConfig()).orElse(new MetadataConfigBuilder().build()));
    }

    public MetadataConfigNested<A> editOrNewMetadataConfigLike(MetadataConfig item) {
        return this.withNewMetadataConfigLike(Optional.ofNullable(this.buildMetadataConfig()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.remove("oauth2");
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get("oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get("oauth2").remove(this.oauth2);
        }
        return (A)this;
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public QueueConfig buildQueueConfig() {
        return this.queueConfig != null ? this.queueConfig.build() : null;
    }

    public A withQueueConfig(QueueConfig queueConfig) {
        this._visitables.remove("queueConfig");
        if (queueConfig != null) {
            this.queueConfig = new QueueConfigBuilder(queueConfig);
            this._visitables.get("queueConfig").add(this.queueConfig);
        } else {
            this.queueConfig = null;
            this._visitables.get("queueConfig").remove(this.queueConfig);
        }
        return (A)this;
    }

    public boolean hasQueueConfig() {
        return this.queueConfig != null;
    }

    public QueueConfigNested<A> withNewQueueConfig() {
        return new QueueConfigNested(null);
    }

    public QueueConfigNested<A> withNewQueueConfigLike(QueueConfig item) {
        return new QueueConfigNested(item);
    }

    public QueueConfigNested<A> editQueueConfig() {
        return this.withNewQueueConfigLike(Optional.ofNullable(this.buildQueueConfig()).orElse(null));
    }

    public QueueConfigNested<A> editOrNewQueueConfig() {
        return this.withNewQueueConfigLike(Optional.ofNullable(this.buildQueueConfig()).orElse(new QueueConfigBuilder().build()));
    }

    public QueueConfigNested<A> editOrNewQueueConfigLike(QueueConfig item) {
        return this.withNewQueueConfigLike(Optional.ofNullable(this.buildQueueConfig()).orElse(item));
    }

    public String getRemoteTimeout() {
        return this.remoteTimeout;
    }

    public A withRemoteTimeout(String remoteTimeout) {
        this.remoteTimeout = remoteTimeout;
        return (A)this;
    }

    public boolean hasRemoteTimeout() {
        return this.remoteTimeout != null;
    }

    public Boolean getSendExemplars() {
        return this.sendExemplars;
    }

    public A withSendExemplars(Boolean sendExemplars) {
        this.sendExemplars = sendExemplars;
        return (A)this;
    }

    public boolean hasSendExemplars() {
        return this.sendExemplars != null;
    }

    public Boolean getSendNativeHistograms() {
        return this.sendNativeHistograms;
    }

    public A withSendNativeHistograms(Boolean sendNativeHistograms) {
        this.sendNativeHistograms = sendNativeHistograms;
        return (A)this;
    }

    public boolean hasSendNativeHistograms() {
        return this.sendNativeHistograms != null;
    }

    public Sigv4 buildSigv4() {
        return this.sigv4 != null ? this.sigv4.build() : null;
    }

    public A withSigv4(Sigv4 sigv4) {
        this._visitables.remove("sigv4");
        if (sigv4 != null) {
            this.sigv4 = new Sigv4Builder(sigv4);
            this._visitables.get("sigv4").add(this.sigv4);
        } else {
            this.sigv4 = null;
            this._visitables.get("sigv4").remove(this.sigv4);
        }
        return (A)this;
    }

    public boolean hasSigv4() {
        return this.sigv4 != null;
    }

    public Sigv4Nested<A> withNewSigv4() {
        return new Sigv4Nested(null);
    }

    public Sigv4Nested<A> withNewSigv4Like(Sigv4 item) {
        return new Sigv4Nested(item);
    }

    public Sigv4Nested<A> editSigv4() {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(null));
    }

    public Sigv4Nested<A> editOrNewSigv4() {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(new Sigv4Builder().build()));
    }

    public Sigv4Nested<A> editOrNewSigv4Like(Sigv4 item) {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(item));
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToWriteRelabelConfigs(int index, RelabelConfig item) {
        if (this.writeRelabelConfigs == null) {
            this.writeRelabelConfigs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.writeRelabelConfigs.size()) {
            this._visitables.get("writeRelabelConfigs").add(builder);
            this.writeRelabelConfigs.add(builder);
        } else {
            this._visitables.get("writeRelabelConfigs").add(index, builder);
            this.writeRelabelConfigs.add(index, builder);
        }
        return (A)this;
    }

    public A setToWriteRelabelConfigs(int index, RelabelConfig item) {
        if (this.writeRelabelConfigs == null) {
            this.writeRelabelConfigs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.writeRelabelConfigs.size()) {
            this._visitables.get("writeRelabelConfigs").add(builder);
            this.writeRelabelConfigs.add(builder);
        } else {
            this._visitables.get("writeRelabelConfigs").set(index, builder);
            this.writeRelabelConfigs.set(index, builder);
        }
        return (A)this;
    }

    public A addToWriteRelabelConfigs(RelabelConfig ... items) {
        if (this.writeRelabelConfigs == null) {
            this.writeRelabelConfigs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("writeRelabelConfigs").add(builder);
            this.writeRelabelConfigs.add(builder);
        }
        return (A)this;
    }

    public A addAllToWriteRelabelConfigs(Collection<RelabelConfig> items) {
        if (this.writeRelabelConfigs == null) {
            this.writeRelabelConfigs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("writeRelabelConfigs").add(builder);
            this.writeRelabelConfigs.add(builder);
        }
        return (A)this;
    }

    public A removeFromWriteRelabelConfigs(RelabelConfig ... items) {
        if (this.writeRelabelConfigs == null) {
            return (A)this;
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("writeRelabelConfigs").remove(builder);
            this.writeRelabelConfigs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromWriteRelabelConfigs(Collection<RelabelConfig> items) {
        if (this.writeRelabelConfigs == null) {
            return (A)this;
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("writeRelabelConfigs").remove(builder);
            this.writeRelabelConfigs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromWriteRelabelConfigs(Predicate<RelabelConfigBuilder> predicate) {
        if (this.writeRelabelConfigs == null) {
            return (A)this;
        }
        Iterator<RelabelConfigBuilder> each = this.writeRelabelConfigs.iterator();
        Object visitables = this._visitables.get("writeRelabelConfigs");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RelabelConfig> buildWriteRelabelConfigs() {
        return this.writeRelabelConfigs != null ? RemoteWriteSpecFluent.build(this.writeRelabelConfigs) : null;
    }

    public RelabelConfig buildWriteRelabelConfig(int index) {
        return this.writeRelabelConfigs.get(index).build();
    }

    public RelabelConfig buildFirstWriteRelabelConfig() {
        return this.writeRelabelConfigs.get(0).build();
    }

    public RelabelConfig buildLastWriteRelabelConfig() {
        return this.writeRelabelConfigs.get(this.writeRelabelConfigs.size() - 1).build();
    }

    public RelabelConfig buildMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.writeRelabelConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.writeRelabelConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWriteRelabelConfigs(List<RelabelConfig> writeRelabelConfigs) {
        if (this.writeRelabelConfigs != null) {
            this._visitables.get("writeRelabelConfigs").clear();
        }
        if (writeRelabelConfigs != null) {
            this.writeRelabelConfigs = new ArrayList();
            for (RelabelConfig item : writeRelabelConfigs) {
                this.addToWriteRelabelConfigs(item);
            }
        } else {
            this.writeRelabelConfigs = null;
        }
        return (A)this;
    }

    public A withWriteRelabelConfigs(RelabelConfig ... writeRelabelConfigs) {
        if (this.writeRelabelConfigs != null) {
            this.writeRelabelConfigs.clear();
            this._visitables.remove("writeRelabelConfigs");
        }
        if (writeRelabelConfigs != null) {
            for (RelabelConfig item : writeRelabelConfigs) {
                this.addToWriteRelabelConfigs(item);
            }
        }
        return (A)this;
    }

    public boolean hasWriteRelabelConfigs() {
        return this.writeRelabelConfigs != null && !this.writeRelabelConfigs.isEmpty();
    }

    public WriteRelabelConfigsNested<A> addNewWriteRelabelConfig() {
        return new WriteRelabelConfigsNested(-1, null);
    }

    public WriteRelabelConfigsNested<A> addNewWriteRelabelConfigLike(RelabelConfig item) {
        return new WriteRelabelConfigsNested(-1, item);
    }

    public WriteRelabelConfigsNested<A> setNewWriteRelabelConfigLike(int index, RelabelConfig item) {
        return new WriteRelabelConfigsNested(index, item);
    }

    public WriteRelabelConfigsNested<A> editWriteRelabelConfig(int index) {
        if (this.writeRelabelConfigs.size() <= index) {
            throw new RuntimeException("Can't edit writeRelabelConfigs. Index exceeds size.");
        }
        return this.setNewWriteRelabelConfigLike(index, this.buildWriteRelabelConfig(index));
    }

    public WriteRelabelConfigsNested<A> editFirstWriteRelabelConfig() {
        if (this.writeRelabelConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first writeRelabelConfigs. The list is empty.");
        }
        return this.setNewWriteRelabelConfigLike(0, this.buildWriteRelabelConfig(0));
    }

    public WriteRelabelConfigsNested<A> editLastWriteRelabelConfig() {
        int index = this.writeRelabelConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last writeRelabelConfigs. The list is empty.");
        }
        return this.setNewWriteRelabelConfigLike(index, this.buildWriteRelabelConfig(index));
    }

    public WriteRelabelConfigsNested<A> editMatchingWriteRelabelConfig(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.writeRelabelConfigs.size(); ++i) {
            if (!predicate.test(this.writeRelabelConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching writeRelabelConfigs. No match found.");
        }
        return this.setNewWriteRelabelConfigLike(index, this.buildWriteRelabelConfig(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteWriteSpecFluent that = (RemoteWriteSpecFluent)o;
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.basicAuth, that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.bearerToken, that.bearerToken)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenFile, that.bearerTokenFile)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.metadataConfig, that.metadataConfig)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.oauth2, that.oauth2)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.queueConfig, that.queueConfig)) {
            return false;
        }
        if (!Objects.equals(this.remoteTimeout, that.remoteTimeout)) {
            return false;
        }
        if (!Objects.equals(this.sendExemplars, that.sendExemplars)) {
            return false;
        }
        if (!Objects.equals(this.sendNativeHistograms, that.sendNativeHistograms)) {
            return false;
        }
        if (!Objects.equals(this.sigv4, that.sigv4)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.writeRelabelConfigs, that.writeRelabelConfigs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authorization, this.basicAuth, this.bearerToken, this.bearerTokenFile, this.headers, this.metadataConfig, this.name, this.oauth2, this.proxyUrl, this.queueConfig, this.remoteTimeout, this.sendExemplars, this.sendNativeHistograms, this.sigv4, this.tlsConfig, this.url, this.writeRelabelConfigs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(this.basicAuth + ",");
        }
        if (this.bearerToken != null) {
            sb.append("bearerToken:");
            sb.append(this.bearerToken + ",");
        }
        if (this.bearerTokenFile != null) {
            sb.append("bearerTokenFile:");
            sb.append(this.bearerTokenFile + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.metadataConfig != null) {
            sb.append("metadataConfig:");
            sb.append(this.metadataConfig + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append(this.oauth2 + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.queueConfig != null) {
            sb.append("queueConfig:");
            sb.append(this.queueConfig + ",");
        }
        if (this.remoteTimeout != null) {
            sb.append("remoteTimeout:");
            sb.append(this.remoteTimeout + ",");
        }
        if (this.sendExemplars != null) {
            sb.append("sendExemplars:");
            sb.append(this.sendExemplars + ",");
        }
        if (this.sendNativeHistograms != null) {
            sb.append("sendNativeHistograms:");
            sb.append(this.sendNativeHistograms + ",");
        }
        if (this.sigv4 != null) {
            sb.append("sigv4:");
            sb.append(this.sigv4 + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.writeRelabelConfigs != null && !this.writeRelabelConfigs.isEmpty()) {
            sb.append("writeRelabelConfigs:");
            sb.append(this.writeRelabelConfigs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSendExemplars() {
        return this.withSendExemplars(true);
    }

    public A withSendNativeHistograms() {
        return this.withSendNativeHistograms(true);
    }

    public class WriteRelabelConfigsNested<N>
    extends RelabelConfigFluent<WriteRelabelConfigsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        WriteRelabelConfigsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.setToWriteRelabelConfigs(this.index, this.builder.build());
        }

        public N endWriteRelabelConfig() {
            return this.and();
        }
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Sigv4Nested<N>
    extends Sigv4Fluent<Sigv4Nested<N>>
    implements Nested<N> {
        Sigv4Builder builder;

        Sigv4Nested(Sigv4 item) {
            this.builder = new Sigv4Builder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.withSigv4(this.builder.build());
        }

        public N endSigv4() {
            return this.and();
        }
    }

    public class QueueConfigNested<N>
    extends QueueConfigFluent<QueueConfigNested<N>>
    implements Nested<N> {
        QueueConfigBuilder builder;

        QueueConfigNested(QueueConfig item) {
            this.builder = new QueueConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.withQueueConfig(this.builder.build());
        }

        public N endQueueConfig() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class MetadataConfigNested<N>
    extends MetadataConfigFluent<MetadataConfigNested<N>>
    implements Nested<N> {
        MetadataConfigBuilder builder;

        MetadataConfigNested(MetadataConfig item) {
            this.builder = new MetadataConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.withMetadataConfig(this.builder.build());
        }

        public N endMetadataConfig() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends AuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        AuthorizationBuilder builder;

        AuthorizationNested(Authorization item) {
            this.builder = new AuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RemoteWriteSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

