/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1.ClusterAutoscalerSpec;
import io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1.ResourceLimits;
import io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1.ResourceLimitsBuilder;
import io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1.ResourceLimitsFluent;
import io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1.ScaleDownConfig;
import io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1.ScaleDownConfigBuilder;
import io.fabric8.openshift.api.model.v6_13.clusterautoscaling.v1.ScaleDownConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterAutoscalerSpecFluent<A extends ClusterAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean balanceSimilarNodeGroups;
    private List<String> balancingIgnoredLabels = new ArrayList<String>();
    private Boolean ignoreDaemonsetsUtilization;
    private Integer logVerbosity;
    private String maxNodeProvisionTime;
    private Integer maxPodGracePeriod;
    private Integer podPriorityThreshold;
    private ResourceLimitsBuilder resourceLimits;
    private ScaleDownConfigBuilder scaleDown;
    private Boolean skipNodesWithLocalStorage;
    private Map<String, Object> additionalProperties;

    public ClusterAutoscalerSpecFluent() {
    }

    public ClusterAutoscalerSpecFluent(ClusterAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterAutoscalerSpec instance) {
        ClusterAutoscalerSpec clusterAutoscalerSpec = instance = instance != null ? instance : new ClusterAutoscalerSpec();
        if (instance != null) {
            this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
            this.withBalancingIgnoredLabels(instance.getBalancingIgnoredLabels());
            this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
            this.withLogVerbosity(instance.getLogVerbosity());
            this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
            this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
            this.withPodPriorityThreshold(instance.getPodPriorityThreshold());
            this.withResourceLimits(instance.getResourceLimits());
            this.withScaleDown(instance.getScaleDown());
            this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getBalanceSimilarNodeGroups() {
        return this.balanceSimilarNodeGroups;
    }

    public A withBalanceSimilarNodeGroups(Boolean balanceSimilarNodeGroups) {
        this.balanceSimilarNodeGroups = balanceSimilarNodeGroups;
        return (A)this;
    }

    public boolean hasBalanceSimilarNodeGroups() {
        return this.balanceSimilarNodeGroups != null;
    }

    public A addToBalancingIgnoredLabels(int index, String item) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        this.balancingIgnoredLabels.add(index, item);
        return (A)this;
    }

    public A setToBalancingIgnoredLabels(int index, String item) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        this.balancingIgnoredLabels.set(index, item);
        return (A)this;
    }

    public A addToBalancingIgnoredLabels(String ... items) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.balancingIgnoredLabels.add(item);
        }
        return (A)this;
    }

    public A addAllToBalancingIgnoredLabels(Collection<String> items) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.balancingIgnoredLabels.add(item);
        }
        return (A)this;
    }

    public A removeFromBalancingIgnoredLabels(String ... items) {
        if (this.balancingIgnoredLabels == null) {
            return (A)this;
        }
        for (String item : items) {
            this.balancingIgnoredLabels.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromBalancingIgnoredLabels(Collection<String> items) {
        if (this.balancingIgnoredLabels == null) {
            return (A)this;
        }
        for (String item : items) {
            this.balancingIgnoredLabels.remove(item);
        }
        return (A)this;
    }

    public List<String> getBalancingIgnoredLabels() {
        return this.balancingIgnoredLabels;
    }

    public String getBalancingIgnoredLabel(int index) {
        return this.balancingIgnoredLabels.get(index);
    }

    public String getFirstBalancingIgnoredLabel() {
        return this.balancingIgnoredLabels.get(0);
    }

    public String getLastBalancingIgnoredLabel() {
        return this.balancingIgnoredLabels.get(this.balancingIgnoredLabels.size() - 1);
    }

    public String getMatchingBalancingIgnoredLabel(Predicate<String> predicate) {
        for (String item : this.balancingIgnoredLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBalancingIgnoredLabel(Predicate<String> predicate) {
        for (String item : this.balancingIgnoredLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBalancingIgnoredLabels(List<String> balancingIgnoredLabels) {
        if (balancingIgnoredLabels != null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
            for (String item : balancingIgnoredLabels) {
                this.addToBalancingIgnoredLabels(item);
            }
        } else {
            this.balancingIgnoredLabels = null;
        }
        return (A)this;
    }

    public A withBalancingIgnoredLabels(String ... balancingIgnoredLabels) {
        if (this.balancingIgnoredLabels != null) {
            this.balancingIgnoredLabels.clear();
            this._visitables.remove("balancingIgnoredLabels");
        }
        if (balancingIgnoredLabels != null) {
            for (String item : balancingIgnoredLabels) {
                this.addToBalancingIgnoredLabels(item);
            }
        }
        return (A)this;
    }

    public boolean hasBalancingIgnoredLabels() {
        return this.balancingIgnoredLabels != null && !this.balancingIgnoredLabels.isEmpty();
    }

    public Boolean getIgnoreDaemonsetsUtilization() {
        return this.ignoreDaemonsetsUtilization;
    }

    public A withIgnoreDaemonsetsUtilization(Boolean ignoreDaemonsetsUtilization) {
        this.ignoreDaemonsetsUtilization = ignoreDaemonsetsUtilization;
        return (A)this;
    }

    public boolean hasIgnoreDaemonsetsUtilization() {
        return this.ignoreDaemonsetsUtilization != null;
    }

    public Integer getLogVerbosity() {
        return this.logVerbosity;
    }

    public A withLogVerbosity(Integer logVerbosity) {
        this.logVerbosity = logVerbosity;
        return (A)this;
    }

    public boolean hasLogVerbosity() {
        return this.logVerbosity != null;
    }

    public String getMaxNodeProvisionTime() {
        return this.maxNodeProvisionTime;
    }

    public A withMaxNodeProvisionTime(String maxNodeProvisionTime) {
        this.maxNodeProvisionTime = maxNodeProvisionTime;
        return (A)this;
    }

    public boolean hasMaxNodeProvisionTime() {
        return this.maxNodeProvisionTime != null;
    }

    public Integer getMaxPodGracePeriod() {
        return this.maxPodGracePeriod;
    }

    public A withMaxPodGracePeriod(Integer maxPodGracePeriod) {
        this.maxPodGracePeriod = maxPodGracePeriod;
        return (A)this;
    }

    public boolean hasMaxPodGracePeriod() {
        return this.maxPodGracePeriod != null;
    }

    public Integer getPodPriorityThreshold() {
        return this.podPriorityThreshold;
    }

    public A withPodPriorityThreshold(Integer podPriorityThreshold) {
        this.podPriorityThreshold = podPriorityThreshold;
        return (A)this;
    }

    public boolean hasPodPriorityThreshold() {
        return this.podPriorityThreshold != null;
    }

    public ResourceLimits buildResourceLimits() {
        return this.resourceLimits != null ? this.resourceLimits.build() : null;
    }

    public A withResourceLimits(ResourceLimits resourceLimits) {
        this._visitables.remove("resourceLimits");
        if (resourceLimits != null) {
            this.resourceLimits = new ResourceLimitsBuilder(resourceLimits);
            this._visitables.get("resourceLimits").add(this.resourceLimits);
        } else {
            this.resourceLimits = null;
            this._visitables.get("resourceLimits").remove(this.resourceLimits);
        }
        return (A)this;
    }

    public boolean hasResourceLimits() {
        return this.resourceLimits != null;
    }

    public ResourceLimitsNested<A> withNewResourceLimits() {
        return new ResourceLimitsNested(null);
    }

    public ResourceLimitsNested<A> withNewResourceLimitsLike(ResourceLimits item) {
        return new ResourceLimitsNested(item);
    }

    public ResourceLimitsNested<A> editResourceLimits() {
        return this.withNewResourceLimitsLike(Optional.ofNullable(this.buildResourceLimits()).orElse(null));
    }

    public ResourceLimitsNested<A> editOrNewResourceLimits() {
        return this.withNewResourceLimitsLike(Optional.ofNullable(this.buildResourceLimits()).orElse(new ResourceLimitsBuilder().build()));
    }

    public ResourceLimitsNested<A> editOrNewResourceLimitsLike(ResourceLimits item) {
        return this.withNewResourceLimitsLike(Optional.ofNullable(this.buildResourceLimits()).orElse(item));
    }

    public ScaleDownConfig buildScaleDown() {
        return this.scaleDown != null ? this.scaleDown.build() : null;
    }

    public A withScaleDown(ScaleDownConfig scaleDown) {
        this._visitables.remove("scaleDown");
        if (scaleDown != null) {
            this.scaleDown = new ScaleDownConfigBuilder(scaleDown);
            this._visitables.get("scaleDown").add(this.scaleDown);
        } else {
            this.scaleDown = null;
            this._visitables.get("scaleDown").remove(this.scaleDown);
        }
        return (A)this;
    }

    public boolean hasScaleDown() {
        return this.scaleDown != null;
    }

    public ScaleDownNested<A> withNewScaleDown() {
        return new ScaleDownNested(null);
    }

    public ScaleDownNested<A> withNewScaleDownLike(ScaleDownConfig item) {
        return new ScaleDownNested(item);
    }

    public ScaleDownNested<A> editScaleDown() {
        return this.withNewScaleDownLike(Optional.ofNullable(this.buildScaleDown()).orElse(null));
    }

    public ScaleDownNested<A> editOrNewScaleDown() {
        return this.withNewScaleDownLike(Optional.ofNullable(this.buildScaleDown()).orElse(new ScaleDownConfigBuilder().build()));
    }

    public ScaleDownNested<A> editOrNewScaleDownLike(ScaleDownConfig item) {
        return this.withNewScaleDownLike(Optional.ofNullable(this.buildScaleDown()).orElse(item));
    }

    public Boolean getSkipNodesWithLocalStorage() {
        return this.skipNodesWithLocalStorage;
    }

    public A withSkipNodesWithLocalStorage(Boolean skipNodesWithLocalStorage) {
        this.skipNodesWithLocalStorage = skipNodesWithLocalStorage;
        return (A)this;
    }

    public boolean hasSkipNodesWithLocalStorage() {
        return this.skipNodesWithLocalStorage != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterAutoscalerSpecFluent that = (ClusterAutoscalerSpecFluent)o;
        if (!Objects.equals(this.balanceSimilarNodeGroups, that.balanceSimilarNodeGroups)) {
            return false;
        }
        if (!Objects.equals(this.balancingIgnoredLabels, that.balancingIgnoredLabels)) {
            return false;
        }
        if (!Objects.equals(this.ignoreDaemonsetsUtilization, that.ignoreDaemonsetsUtilization)) {
            return false;
        }
        if (!Objects.equals(this.logVerbosity, that.logVerbosity)) {
            return false;
        }
        if (!Objects.equals(this.maxNodeProvisionTime, that.maxNodeProvisionTime)) {
            return false;
        }
        if (!Objects.equals(this.maxPodGracePeriod, that.maxPodGracePeriod)) {
            return false;
        }
        if (!Objects.equals(this.podPriorityThreshold, that.podPriorityThreshold)) {
            return false;
        }
        if (!Objects.equals(this.resourceLimits, that.resourceLimits)) {
            return false;
        }
        if (!Objects.equals(this.scaleDown, that.scaleDown)) {
            return false;
        }
        if (!Objects.equals(this.skipNodesWithLocalStorage, that.skipNodesWithLocalStorage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.balanceSimilarNodeGroups, this.balancingIgnoredLabels, this.ignoreDaemonsetsUtilization, this.logVerbosity, this.maxNodeProvisionTime, this.maxPodGracePeriod, this.podPriorityThreshold, this.resourceLimits, this.scaleDown, this.skipNodesWithLocalStorage, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.balanceSimilarNodeGroups != null) {
            sb.append("balanceSimilarNodeGroups:");
            sb.append(this.balanceSimilarNodeGroups + ",");
        }
        if (this.balancingIgnoredLabels != null && !this.balancingIgnoredLabels.isEmpty()) {
            sb.append("balancingIgnoredLabels:");
            sb.append(this.balancingIgnoredLabels + ",");
        }
        if (this.ignoreDaemonsetsUtilization != null) {
            sb.append("ignoreDaemonsetsUtilization:");
            sb.append(this.ignoreDaemonsetsUtilization + ",");
        }
        if (this.logVerbosity != null) {
            sb.append("logVerbosity:");
            sb.append(this.logVerbosity + ",");
        }
        if (this.maxNodeProvisionTime != null) {
            sb.append("maxNodeProvisionTime:");
            sb.append(this.maxNodeProvisionTime + ",");
        }
        if (this.maxPodGracePeriod != null) {
            sb.append("maxPodGracePeriod:");
            sb.append(this.maxPodGracePeriod + ",");
        }
        if (this.podPriorityThreshold != null) {
            sb.append("podPriorityThreshold:");
            sb.append(this.podPriorityThreshold + ",");
        }
        if (this.resourceLimits != null) {
            sb.append("resourceLimits:");
            sb.append(this.resourceLimits + ",");
        }
        if (this.scaleDown != null) {
            sb.append("scaleDown:");
            sb.append(this.scaleDown + ",");
        }
        if (this.skipNodesWithLocalStorage != null) {
            sb.append("skipNodesWithLocalStorage:");
            sb.append(this.skipNodesWithLocalStorage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withBalanceSimilarNodeGroups() {
        return this.withBalanceSimilarNodeGroups(true);
    }

    public A withIgnoreDaemonsetsUtilization() {
        return this.withIgnoreDaemonsetsUtilization(true);
    }

    public A withSkipNodesWithLocalStorage() {
        return this.withSkipNodesWithLocalStorage(true);
    }

    public class ScaleDownNested<N>
    extends ScaleDownConfigFluent<ScaleDownNested<N>>
    implements Nested<N> {
        ScaleDownConfigBuilder builder;

        ScaleDownNested(ScaleDownConfig item) {
            this.builder = new ScaleDownConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterAutoscalerSpecFluent.this.withScaleDown(this.builder.build());
        }

        public N endScaleDown() {
            return this.and();
        }
    }

    public class ResourceLimitsNested<N>
    extends ResourceLimitsFluent<ResourceLimitsNested<N>>
    implements Nested<N> {
        ResourceLimitsBuilder builder;

        ResourceLimitsNested(ResourceLimits item) {
            this.builder = new ResourceLimitsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterAutoscalerSpecFluent.this.withResourceLimits(this.builder.build());
        }

        public N endResourceLimits() {
            return this.and();
        }
    }
}

