/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.apps;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.v6_13.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v6_13.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.v6_13.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.v6_13.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v6_13.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v6_13.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetOrdinals;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetOrdinalsBuilder;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetOrdinalsFluent;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetPersistentVolumeClaimRetentionPolicy;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetPersistentVolumeClaimRetentionPolicyBuilder;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetPersistentVolumeClaimRetentionPolicyFluent;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetUpdateStrategy;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetUpdateStrategyBuilder;
import io.fabric8.kubernetes.api.model.v6_13.apps.StatefulSetUpdateStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StatefulSetSpecFluent<A extends StatefulSetSpecFluent<A>>
extends BaseFluent<A> {
    private Integer minReadySeconds;
    private StatefulSetOrdinalsBuilder ordinals;
    private StatefulSetPersistentVolumeClaimRetentionPolicyBuilder persistentVolumeClaimRetentionPolicy;
    private String podManagementPolicy;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private LabelSelectorBuilder selector;
    private String serviceName;
    private PodTemplateSpecBuilder template;
    private StatefulSetUpdateStrategyBuilder updateStrategy;
    private ArrayList<PersistentVolumeClaimBuilder> volumeClaimTemplates = new ArrayList();
    private Map<String, Object> additionalProperties;

    public StatefulSetSpecFluent() {
    }

    public StatefulSetSpecFluent(StatefulSetSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StatefulSetSpec instance) {
        StatefulSetSpec statefulSetSpec = instance = instance != null ? instance : new StatefulSetSpec();
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withOrdinals(instance.getOrdinals());
            this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
            this.withPodManagementPolicy(instance.getPodManagementPolicy());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSelector(instance.getSelector());
            this.withServiceName(instance.getServiceName());
            this.withTemplate(instance.getTemplate());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public StatefulSetOrdinals buildOrdinals() {
        return this.ordinals != null ? this.ordinals.build() : null;
    }

    public A withOrdinals(StatefulSetOrdinals ordinals) {
        this._visitables.remove("ordinals");
        if (ordinals != null) {
            this.ordinals = new StatefulSetOrdinalsBuilder(ordinals);
            this._visitables.get("ordinals").add(this.ordinals);
        } else {
            this.ordinals = null;
            this._visitables.get("ordinals").remove(this.ordinals);
        }
        return (A)this;
    }

    public boolean hasOrdinals() {
        return this.ordinals != null;
    }

    public A withNewOrdinals(Integer start) {
        return this.withOrdinals(new StatefulSetOrdinals(start));
    }

    public OrdinalsNested<A> withNewOrdinals() {
        return new OrdinalsNested(null);
    }

    public OrdinalsNested<A> withNewOrdinalsLike(StatefulSetOrdinals item) {
        return new OrdinalsNested(item);
    }

    public OrdinalsNested<A> editOrdinals() {
        return this.withNewOrdinalsLike(Optional.ofNullable(this.buildOrdinals()).orElse(null));
    }

    public OrdinalsNested<A> editOrNewOrdinals() {
        return this.withNewOrdinalsLike(Optional.ofNullable(this.buildOrdinals()).orElse(new StatefulSetOrdinalsBuilder().build()));
    }

    public OrdinalsNested<A> editOrNewOrdinalsLike(StatefulSetOrdinals item) {
        return this.withNewOrdinalsLike(Optional.ofNullable(this.buildOrdinals()).orElse(item));
    }

    public StatefulSetPersistentVolumeClaimRetentionPolicy buildPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null ? this.persistentVolumeClaimRetentionPolicy.build() : null;
    }

    public A withPersistentVolumeClaimRetentionPolicy(StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this._visitables.remove("persistentVolumeClaimRetentionPolicy");
        if (persistentVolumeClaimRetentionPolicy != null) {
            this.persistentVolumeClaimRetentionPolicy = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(persistentVolumeClaimRetentionPolicy);
            this._visitables.get("persistentVolumeClaimRetentionPolicy").add(this.persistentVolumeClaimRetentionPolicy);
        } else {
            this.persistentVolumeClaimRetentionPolicy = null;
            this._visitables.get("persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy);
        }
        return (A)this;
    }

    public boolean hasPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null;
    }

    public A withNewPersistentVolumeClaimRetentionPolicy(String whenDeleted, String whenScaled) {
        return this.withPersistentVolumeClaimRetentionPolicy(new StatefulSetPersistentVolumeClaimRetentionPolicy(whenDeleted, whenScaled));
    }

    public PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicy() {
        return new PersistentVolumeClaimRetentionPolicyNested(null);
    }

    public PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
        return new PersistentVolumeClaimRetentionPolicyNested(item);
    }

    public PersistentVolumeClaimRetentionPolicyNested<A> editPersistentVolumeClaimRetentionPolicy() {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(Optional.ofNullable(this.buildPersistentVolumeClaimRetentionPolicy()).orElse(null));
    }

    public PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicy() {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(Optional.ofNullable(this.buildPersistentVolumeClaimRetentionPolicy()).orElse(new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder().build()));
    }

    public PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(Optional.ofNullable(this.buildPersistentVolumeClaimRetentionPolicy()).orElse(item));
    }

    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    public A withPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
        return (A)this;
    }

    public boolean hasPodManagementPolicy() {
        return this.podManagementPolicy != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    public boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    public boolean hasServiceName() {
        return this.serviceName != null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public StatefulSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    public A withUpdateStrategy(StatefulSetUpdateStrategy updateStrategy) {
        this._visitables.remove("updateStrategy");
        if (updateStrategy != null) {
            this.updateStrategy = new StatefulSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get("updateStrategy").remove(this.updateStrategy);
        }
        return (A)this;
    }

    public boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    public UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNested(null);
    }

    public UpdateStrategyNested<A> withNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
        return new UpdateStrategyNested(item);
    }

    public UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(null));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(new StatefulSetUpdateStrategyBuilder().build()));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(item));
    }

    public A addToVolumeClaimTemplates(int index, PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= this.volumeClaimTemplates.size()) {
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        } else {
            this._visitables.get("volumeClaimTemplates").add(index, builder);
            this.volumeClaimTemplates.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumeClaimTemplates(int index, PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= this.volumeClaimTemplates.size()) {
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        } else {
            this._visitables.get("volumeClaimTemplates").set(index, builder);
            this.volumeClaimTemplates.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        if (this.volumeClaimTemplates == null) {
            return (A)this;
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
        if (this.volumeClaimTemplates == null) {
            return (A)this;
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumeClaimTemplates(Predicate<PersistentVolumeClaimBuilder> predicate) {
        if (this.volumeClaimTemplates == null) {
            return (A)this;
        }
        Iterator<PersistentVolumeClaimBuilder> each = this.volumeClaimTemplates.iterator();
        Object visitables = this._visitables.get("volumeClaimTemplates");
        while (each.hasNext()) {
            PersistentVolumeClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PersistentVolumeClaim> buildVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null ? StatefulSetSpecFluent.build(this.volumeClaimTemplates) : null;
    }

    public PersistentVolumeClaim buildVolumeClaimTemplate(int index) {
        return this.volumeClaimTemplates.get(index).build();
    }

    public PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(0).build();
    }

    public PersistentVolumeClaim buildLastVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(this.volumeClaimTemplates.size() - 1).build();
    }

    public PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        for (PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        for (PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this._visitables.get("volumeClaimTemplates").clear();
        }
        if (volumeClaimTemplates != null) {
            this.volumeClaimTemplates = new ArrayList();
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        } else {
            this.volumeClaimTemplates = null;
        }
        return (A)this;
    }

    public A withVolumeClaimTemplates(PersistentVolumeClaim ... volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this.volumeClaimTemplates.clear();
            this._visitables.remove("volumeClaimTemplates");
        }
        if (volumeClaimTemplates != null) {
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty();
    }

    public VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
        return new VolumeClaimTemplatesNested(-1, null);
    }

    public VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNested(-1, item);
    }

    public VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index, PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNested(index, item);
    }

    public VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index) {
        if (this.volumeClaimTemplates.size() <= index) {
            throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    public VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
        if (this.volumeClaimTemplates.size() == 0) {
            throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(0, this.buildVolumeClaimTemplate(0));
    }

    public VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
        int index = this.volumeClaimTemplates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    public VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeClaimTemplates.size(); ++i) {
            if (!predicate.test(this.volumeClaimTemplates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetSpecFluent that = (StatefulSetSpecFluent)o;
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.ordinals, that.ordinals)) {
            return false;
        }
        if (!Objects.equals(this.persistentVolumeClaimRetentionPolicy, that.persistentVolumeClaimRetentionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.podManagementPolicy, that.podManagementPolicy)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.serviceName, that.serviceName)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.updateStrategy, that.updateStrategy)) {
            return false;
        }
        if (!Objects.equals(this.volumeClaimTemplates, that.volumeClaimTemplates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.ordinals, this.persistentVolumeClaimRetentionPolicy, this.podManagementPolicy, this.replicas, this.revisionHistoryLimit, this.selector, this.serviceName, this.template, this.updateStrategy, this.volumeClaimTemplates, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.ordinals != null) {
            sb.append("ordinals:");
            sb.append(this.ordinals + ",");
        }
        if (this.persistentVolumeClaimRetentionPolicy != null) {
            sb.append("persistentVolumeClaimRetentionPolicy:");
            sb.append(this.persistentVolumeClaimRetentionPolicy + ",");
        }
        if (this.podManagementPolicy != null) {
            sb.append("podManagementPolicy:");
            sb.append(this.podManagementPolicy + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.serviceName != null) {
            sb.append("serviceName:");
            sb.append(this.serviceName + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append(this.updateStrategy + ",");
        }
        if (this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty()) {
            sb.append("volumeClaimTemplates:");
            sb.append(this.volumeClaimTemplates + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VolumeClaimTemplatesNested<N>
    extends PersistentVolumeClaimFluent<VolumeClaimTemplatesNested<N>>
    implements Nested<N> {
        PersistentVolumeClaimBuilder builder;
        int index;

        VolumeClaimTemplatesNested(int index, PersistentVolumeClaim item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluent.this.setToVolumeClaimTemplates(this.index, this.builder.build());
        }

        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }

    public class UpdateStrategyNested<N>
    extends StatefulSetUpdateStrategyFluent<UpdateStrategyNested<N>>
    implements Nested<N> {
        StatefulSetUpdateStrategyBuilder builder;

        UpdateStrategyNested(StatefulSetUpdateStrategy item) {
            this.builder = new StatefulSetUpdateStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluent.this.withUpdateStrategy(this.builder.build());
        }

        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class PersistentVolumeClaimRetentionPolicyNested<N>
    extends StatefulSetPersistentVolumeClaimRetentionPolicyFluent<PersistentVolumeClaimRetentionPolicyNested<N>>
    implements Nested<N> {
        StatefulSetPersistentVolumeClaimRetentionPolicyBuilder builder;

        PersistentVolumeClaimRetentionPolicyNested(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
            this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluent.this.withPersistentVolumeClaimRetentionPolicy(this.builder.build());
        }

        public N endPersistentVolumeClaimRetentionPolicy() {
            return this.and();
        }
    }

    public class OrdinalsNested<N>
    extends StatefulSetOrdinalsFluent<OrdinalsNested<N>>
    implements Nested<N> {
        StatefulSetOrdinalsBuilder builder;

        OrdinalsNested(StatefulSetOrdinals item) {
            this.builder = new StatefulSetOrdinalsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluent.this.withOrdinals(this.builder.build());
        }

        public N endOrdinals() {
            return this.and();
        }
    }
}

