/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.v6_13.Editable;
import io.fabric8.kubernetes.api.model.v6_13.ClusterBuilder;
import io.fabric8.kubernetes.api.model.v6_13.KubernetesResource;
import io.fabric8.kubernetes.api.model.v6_13.NamedExtension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"certificate-authority", "certificate-authority-data", "disable-compression", "extensions", "insecure-skip-tls-verify", "proxy-url", "server", "tls-server-name"})
public class Cluster
implements Editable<ClusterBuilder>,
KubernetesResource {
    @JsonProperty(value="certificate-authority")
    private String certificateAuthority;
    @JsonProperty(value="certificate-authority-data")
    private String certificateAuthorityData;
    @JsonProperty(value="disable-compression")
    private Boolean disableCompression;
    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<NamedExtension> extensions = new ArrayList<NamedExtension>();
    @JsonProperty(value="insecure-skip-tls-verify")
    private Boolean insecureSkipTlsVerify;
    @JsonProperty(value="proxy-url")
    private String proxyUrl;
    @JsonProperty(value="server")
    private String server;
    @JsonProperty(value="tls-server-name")
    private String tlsServerName;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public Cluster() {
    }

    public Cluster(String certificateAuthority, String certificateAuthorityData, Boolean disableCompression, List<NamedExtension> extensions, Boolean insecureSkipTlsVerify, String proxyUrl, String server, String tlsServerName) {
        this.certificateAuthority = certificateAuthority;
        this.certificateAuthorityData = certificateAuthorityData;
        this.disableCompression = disableCompression;
        this.extensions = extensions;
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        this.proxyUrl = proxyUrl;
        this.server = server;
        this.tlsServerName = tlsServerName;
    }

    @JsonProperty(value="certificate-authority")
    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    @JsonProperty(value="certificate-authority")
    public void setCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
    }

    @JsonProperty(value="certificate-authority-data")
    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    @JsonProperty(value="certificate-authority-data")
    public void setCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
    }

    @JsonProperty(value="disable-compression")
    public Boolean getDisableCompression() {
        return this.disableCompression;
    }

    @JsonProperty(value="disable-compression")
    public void setDisableCompression(Boolean disableCompression) {
        this.disableCompression = disableCompression;
    }

    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NamedExtension> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(List<NamedExtension> extensions) {
        this.extensions = extensions;
    }

    @JsonProperty(value="insecure-skip-tls-verify")
    public Boolean getInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    @JsonProperty(value="insecure-skip-tls-verify")
    public void setInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
    }

    @JsonProperty(value="proxy-url")
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @JsonProperty(value="proxy-url")
    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    @JsonProperty(value="server")
    public String getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServer(String server) {
        this.server = server;
    }

    @JsonProperty(value="tls-server-name")
    public String getTlsServerName() {
        return this.tlsServerName;
    }

    @JsonProperty(value="tls-server-name")
    public void setTlsServerName(String tlsServerName) {
        this.tlsServerName = tlsServerName;
    }

    @Override
    @JsonIgnore
    public ClusterBuilder edit() {
        return new ClusterBuilder(this);
    }

    @JsonIgnore
    public ClusterBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Cluster(certificateAuthority=" + this.getCertificateAuthority() + ", certificateAuthorityData=" + this.getCertificateAuthorityData() + ", disableCompression=" + this.getDisableCompression() + ", extensions=" + this.getExtensions() + ", insecureSkipTlsVerify=" + this.getInsecureSkipTlsVerify() + ", proxyUrl=" + this.getProxyUrl() + ", server=" + this.getServer() + ", tlsServerName=" + this.getTlsServerName() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disableCompression = this.getDisableCompression();
        Boolean other$disableCompression = other.getDisableCompression();
        if (this$disableCompression == null ? other$disableCompression != null : !((Object)this$disableCompression).equals(other$disableCompression)) {
            return false;
        }
        Boolean this$insecureSkipTlsVerify = this.getInsecureSkipTlsVerify();
        Boolean other$insecureSkipTlsVerify = other.getInsecureSkipTlsVerify();
        if (this$insecureSkipTlsVerify == null ? other$insecureSkipTlsVerify != null : !((Object)this$insecureSkipTlsVerify).equals(other$insecureSkipTlsVerify)) {
            return false;
        }
        String this$certificateAuthority = this.getCertificateAuthority();
        String other$certificateAuthority = other.getCertificateAuthority();
        if (this$certificateAuthority == null ? other$certificateAuthority != null : !this$certificateAuthority.equals(other$certificateAuthority)) {
            return false;
        }
        String this$certificateAuthorityData = this.getCertificateAuthorityData();
        String other$certificateAuthorityData = other.getCertificateAuthorityData();
        if (this$certificateAuthorityData == null ? other$certificateAuthorityData != null : !this$certificateAuthorityData.equals(other$certificateAuthorityData)) {
            return false;
        }
        List<NamedExtension> this$extensions = this.getExtensions();
        List<NamedExtension> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        String this$proxyUrl = this.getProxyUrl();
        String other$proxyUrl = other.getProxyUrl();
        if (this$proxyUrl == null ? other$proxyUrl != null : !this$proxyUrl.equals(other$proxyUrl)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$tlsServerName = this.getTlsServerName();
        String other$tlsServerName = other.getTlsServerName();
        if (this$tlsServerName == null ? other$tlsServerName != null : !this$tlsServerName.equals(other$tlsServerName)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cluster;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disableCompression = this.getDisableCompression();
        result = result * 59 + ($disableCompression == null ? 43 : ((Object)$disableCompression).hashCode());
        Boolean $insecureSkipTlsVerify = this.getInsecureSkipTlsVerify();
        result = result * 59 + ($insecureSkipTlsVerify == null ? 43 : ((Object)$insecureSkipTlsVerify).hashCode());
        String $certificateAuthority = this.getCertificateAuthority();
        result = result * 59 + ($certificateAuthority == null ? 43 : $certificateAuthority.hashCode());
        String $certificateAuthorityData = this.getCertificateAuthorityData();
        result = result * 59 + ($certificateAuthorityData == null ? 43 : $certificateAuthorityData.hashCode());
        List<NamedExtension> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        String $proxyUrl = this.getProxyUrl();
        result = result * 59 + ($proxyUrl == null ? 43 : $proxyUrl.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $tlsServerName = this.getTlsServerName();
        result = result * 59 + ($tlsServerName == null ? 43 : $tlsServerName.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

