/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.AuthInfo;
import io.fabric8.kubernetes.api.model.v6_13.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.v6_13.AuthProviderConfigBuilder;
import io.fabric8.kubernetes.api.model.v6_13.AuthProviderConfigFluent;
import io.fabric8.kubernetes.api.model.v6_13.ExecConfig;
import io.fabric8.kubernetes.api.model.v6_13.ExecConfigBuilder;
import io.fabric8.kubernetes.api.model.v6_13.ExecConfigFluent;
import io.fabric8.kubernetes.api.model.v6_13.NamedExtension;
import io.fabric8.kubernetes.api.model.v6_13.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.v6_13.NamedExtensionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AuthInfoFluent<A extends AuthInfoFluent<A>>
extends BaseFluent<A> {
    private String as;
    private List<String> asGroups = new ArrayList<String>();
    private String asUid;
    private Map<String, ArrayList<String>> asUserExtra;
    private AuthProviderConfigBuilder authProvider;
    private String clientCertificate;
    private String clientCertificateData;
    private String clientKey;
    private String clientKeyData;
    private ExecConfigBuilder exec;
    private ArrayList<NamedExtensionBuilder> extensions = new ArrayList();
    private String password;
    private String token;
    private String tokenFile;
    private String username;
    private Map<String, Object> additionalProperties;

    public AuthInfoFluent() {
    }

    public AuthInfoFluent(AuthInfo instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AuthInfo instance) {
        AuthInfo authInfo = instance = instance != null ? instance : new AuthInfo();
        if (instance != null) {
            this.withAs(instance.getAs());
            this.withAsGroups(instance.getAsGroups());
            this.withAsUid(instance.getAsUid());
            this.withAsUserExtra(instance.getAsUserExtra());
            this.withAuthProvider(instance.getAuthProvider());
            this.withClientCertificate(instance.getClientCertificate());
            this.withClientCertificateData(instance.getClientCertificateData());
            this.withClientKey(instance.getClientKey());
            this.withClientKeyData(instance.getClientKeyData());
            this.withExec(instance.getExec());
            this.withExtensions(instance.getExtensions());
            this.withPassword(instance.getPassword());
            this.withToken(instance.getToken());
            this.withTokenFile(instance.getTokenFile());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAs() {
        return this.as;
    }

    public A withAs(String as) {
        this.as = as;
        return (A)this;
    }

    public boolean hasAs() {
        return this.as != null;
    }

    public A addToAsGroups(int index, String item) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        this.asGroups.add(index, item);
        return (A)this;
    }

    public A setToAsGroups(int index, String item) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        this.asGroups.set(index, item);
        return (A)this;
    }

    public A addToAsGroups(String ... items) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.asGroups.add(item);
        }
        return (A)this;
    }

    public A addAllToAsGroups(Collection<String> items) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.asGroups.add(item);
        }
        return (A)this;
    }

    public A removeFromAsGroups(String ... items) {
        if (this.asGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.asGroups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAsGroups(Collection<String> items) {
        if (this.asGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.asGroups.remove(item);
        }
        return (A)this;
    }

    public List<String> getAsGroups() {
        return this.asGroups;
    }

    public String getAsGroup(int index) {
        return this.asGroups.get(index);
    }

    public String getFirstAsGroup() {
        return this.asGroups.get(0);
    }

    public String getLastAsGroup() {
        return this.asGroups.get(this.asGroups.size() - 1);
    }

    public String getMatchingAsGroup(Predicate<String> predicate) {
        for (String item : this.asGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAsGroup(Predicate<String> predicate) {
        for (String item : this.asGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAsGroups(List<String> asGroups) {
        if (asGroups != null) {
            this.asGroups = new ArrayList<String>();
            for (String item : asGroups) {
                this.addToAsGroups(item);
            }
        } else {
            this.asGroups = null;
        }
        return (A)this;
    }

    public A withAsGroups(String ... asGroups) {
        if (this.asGroups != null) {
            this.asGroups.clear();
            this._visitables.remove("asGroups");
        }
        if (asGroups != null) {
            for (String item : asGroups) {
                this.addToAsGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasAsGroups() {
        return this.asGroups != null && !this.asGroups.isEmpty();
    }

    public String getAsUid() {
        return this.asUid;
    }

    public A withAsUid(String asUid) {
        this.asUid = asUid;
        return (A)this;
    }

    public boolean hasAsUid() {
        return this.asUid != null;
    }

    public A addToAsUserExtra(String key, ArrayList<String> value) {
        if (this.asUserExtra == null && key != null && value != null) {
            this.asUserExtra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (key != null && value != null) {
            this.asUserExtra.put(key, value);
        }
        return (A)this;
    }

    public A addToAsUserExtra(Map<String, ArrayList<String>> map) {
        if (this.asUserExtra == null && map != null) {
            this.asUserExtra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (map != null) {
            this.asUserExtra.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAsUserExtra(String key) {
        if (this.asUserExtra == null) {
            return (A)this;
        }
        if (key != null && this.asUserExtra != null) {
            this.asUserExtra.remove(key);
        }
        return (A)this;
    }

    public A removeFromAsUserExtra(Map<String, ArrayList<String>> map) {
        if (this.asUserExtra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.asUserExtra == null) continue;
                this.asUserExtra.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, ArrayList<String>> getAsUserExtra() {
        return this.asUserExtra;
    }

    public <K, V> A withAsUserExtra(Map<String, ArrayList<String>> asUserExtra) {
        this.asUserExtra = asUserExtra == null ? null : new LinkedHashMap<String, ArrayList<String>>(asUserExtra);
        return (A)this;
    }

    public boolean hasAsUserExtra() {
        return this.asUserExtra != null;
    }

    public AuthProviderConfig buildAuthProvider() {
        return this.authProvider != null ? this.authProvider.build() : null;
    }

    public A withAuthProvider(AuthProviderConfig authProvider) {
        this._visitables.remove("authProvider");
        if (authProvider != null) {
            this.authProvider = new AuthProviderConfigBuilder(authProvider);
            this._visitables.get("authProvider").add(this.authProvider);
        } else {
            this.authProvider = null;
            this._visitables.get("authProvider").remove(this.authProvider);
        }
        return (A)this;
    }

    public boolean hasAuthProvider() {
        return this.authProvider != null;
    }

    public AuthProviderNested<A> withNewAuthProvider() {
        return new AuthProviderNested(null);
    }

    public AuthProviderNested<A> withNewAuthProviderLike(AuthProviderConfig item) {
        return new AuthProviderNested(item);
    }

    public AuthProviderNested<A> editAuthProvider() {
        return this.withNewAuthProviderLike(Optional.ofNullable(this.buildAuthProvider()).orElse(null));
    }

    public AuthProviderNested<A> editOrNewAuthProvider() {
        return this.withNewAuthProviderLike(Optional.ofNullable(this.buildAuthProvider()).orElse(new AuthProviderConfigBuilder().build()));
    }

    public AuthProviderNested<A> editOrNewAuthProviderLike(AuthProviderConfig item) {
        return this.withNewAuthProviderLike(Optional.ofNullable(this.buildAuthProvider()).orElse(item));
    }

    public String getClientCertificate() {
        return this.clientCertificate;
    }

    public A withClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return (A)this;
    }

    public boolean hasClientCertificate() {
        return this.clientCertificate != null;
    }

    public String getClientCertificateData() {
        return this.clientCertificateData;
    }

    public A withClientCertificateData(String clientCertificateData) {
        this.clientCertificateData = clientCertificateData;
        return (A)this;
    }

    public boolean hasClientCertificateData() {
        return this.clientCertificateData != null;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public A withClientKey(String clientKey) {
        this.clientKey = clientKey;
        return (A)this;
    }

    public boolean hasClientKey() {
        return this.clientKey != null;
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public A withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (A)this;
    }

    public boolean hasClientKeyData() {
        return this.clientKeyData != null;
    }

    public ExecConfig buildExec() {
        return this.exec != null ? this.exec.build() : null;
    }

    public A withExec(ExecConfig exec) {
        this._visitables.remove("exec");
        if (exec != null) {
            this.exec = new ExecConfigBuilder(exec);
            this._visitables.get("exec").add(this.exec);
        } else {
            this.exec = null;
            this._visitables.get("exec").remove(this.exec);
        }
        return (A)this;
    }

    public boolean hasExec() {
        return this.exec != null;
    }

    public ExecNested<A> withNewExec() {
        return new ExecNested(null);
    }

    public ExecNested<A> withNewExecLike(ExecConfig item) {
        return new ExecNested(item);
    }

    public ExecNested<A> editExec() {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(null));
    }

    public ExecNested<A> editOrNewExec() {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(new ExecConfigBuilder().build()));
    }

    public ExecNested<A> editOrNewExecLike(ExecConfig item) {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(item));
    }

    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get("extensions").add(index, builder);
            this.extensions.add(index, builder);
        }
        return (A)this;
    }

    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get("extensions").set(index, builder);
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    public A removeFromExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            return (A)this;
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            return (A)this;
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)this;
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        Object visitables = this._visitables.get("extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NamedExtension> buildExtensions() {
        return this.extensions != null ? AuthInfoFluent.build(this.extensions) : null;
    }

    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get("extensions").clear();
        }
        if (extensions != null) {
            this.extensions = new ArrayList();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)this;
    }

    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
            this._visitables.remove("extensions");
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNested(-1, null);
    }

    public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNested(-1, item);
    }

    public ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNested(index, item);
    }

    public ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    public ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.test(this.extensions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getToken() {
        return this.token;
    }

    public A withToken(String token) {
        this.token = token;
        return (A)this;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public String getTokenFile() {
        return this.tokenFile;
    }

    public A withTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
        return (A)this;
    }

    public boolean hasTokenFile() {
        return this.tokenFile != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthInfoFluent that = (AuthInfoFluent)o;
        if (!Objects.equals(this.as, that.as)) {
            return false;
        }
        if (!Objects.equals(this.asGroups, that.asGroups)) {
            return false;
        }
        if (!Objects.equals(this.asUid, that.asUid)) {
            return false;
        }
        if (!Objects.equals(this.asUserExtra, that.asUserExtra)) {
            return false;
        }
        if (!Objects.equals(this.authProvider, that.authProvider)) {
            return false;
        }
        if (!Objects.equals(this.clientCertificate, that.clientCertificate)) {
            return false;
        }
        if (!Objects.equals(this.clientCertificateData, that.clientCertificateData)) {
            return false;
        }
        if (!Objects.equals(this.clientKey, that.clientKey)) {
            return false;
        }
        if (!Objects.equals(this.clientKeyData, that.clientKeyData)) {
            return false;
        }
        if (!Objects.equals(this.exec, that.exec)) {
            return false;
        }
        if (!Objects.equals(this.extensions, that.extensions)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.token, that.token)) {
            return false;
        }
        if (!Objects.equals(this.tokenFile, that.tokenFile)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.as, this.asGroups, this.asUid, this.asUserExtra, this.authProvider, this.clientCertificate, this.clientCertificateData, this.clientKey, this.clientKeyData, this.exec, this.extensions, this.password, this.token, this.tokenFile, this.username, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.as != null) {
            sb.append("as:");
            sb.append(this.as + ",");
        }
        if (this.asGroups != null && !this.asGroups.isEmpty()) {
            sb.append("asGroups:");
            sb.append(this.asGroups + ",");
        }
        if (this.asUid != null) {
            sb.append("asUid:");
            sb.append(this.asUid + ",");
        }
        if (this.asUserExtra != null && !this.asUserExtra.isEmpty()) {
            sb.append("asUserExtra:");
            sb.append(this.asUserExtra + ",");
        }
        if (this.authProvider != null) {
            sb.append("authProvider:");
            sb.append(this.authProvider + ",");
        }
        if (this.clientCertificate != null) {
            sb.append("clientCertificate:");
            sb.append(this.clientCertificate + ",");
        }
        if (this.clientCertificateData != null) {
            sb.append("clientCertificateData:");
            sb.append(this.clientCertificateData + ",");
        }
        if (this.clientKey != null) {
            sb.append("clientKey:");
            sb.append(this.clientKey + ",");
        }
        if (this.clientKeyData != null) {
            sb.append("clientKeyData:");
            sb.append(this.clientKeyData + ",");
        }
        if (this.exec != null) {
            sb.append("exec:");
            sb.append(this.exec + ",");
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            sb.append("extensions:");
            sb.append(this.extensions + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(this.token + ",");
        }
        if (this.tokenFile != null) {
            sb.append("tokenFile:");
            sb.append(this.tokenFile + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExtensionsNested<N>
    extends NamedExtensionFluent<ExtensionsNested<N>>
    implements Nested<N> {
        NamedExtensionBuilder builder;
        int index;

        ExtensionsNested(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluent.this.setToExtensions(this.index, this.builder.build());
        }

        public N endExtension() {
            return this.and();
        }
    }

    public class ExecNested<N>
    extends ExecConfigFluent<ExecNested<N>>
    implements Nested<N> {
        ExecConfigBuilder builder;

        ExecNested(ExecConfig item) {
            this.builder = new ExecConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluent.this.withExec(this.builder.build());
        }

        public N endExec() {
            return this.and();
        }
    }

    public class AuthProviderNested<N>
    extends AuthProviderConfigFluent<AuthProviderNested<N>>
    implements Nested<N> {
        AuthProviderConfigBuilder builder;

        AuthProviderNested(AuthProviderConfig item) {
            this.builder = new AuthProviderConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluent.this.withAuthProvider(this.builder.build());
        }

        public N endAuthProvider() {
            return this.and();
        }
    }
}

