/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v6_13.internal;

import io.fabric8.kubernetes.api.model.v6_13.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_13.authorization.v1.SelfSubjectAccessReview;
import io.fabric8.kubernetes.clnt.v6_13.Config;
import io.fabric8.kubernetes.clnt.v6_13.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_13.http.HttpClient;
import io.fabric8.kubernetes.clnt.v6_13.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v6_13.http.HttpResponse;
import io.fabric8.kubernetes.clnt.v6_13.utils.HttpClientUtils;
import io.fabric8.kubernetes.clnt.v6_13.utils.OpenIDConnectionUtils;
import io.fabric8.kubernetes.clnt.v6_13.utils.Serialization;
import io.fabric8.kubernetes.clnt.v6_13.utils.TokenRefreshInterceptor;
import io.fabric8.kubernetes.clnt.v6_13.utils.URLUtils;
import io.fabric8.openshift.api.model.v6_13.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.v6_13.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v6_13.ResourceAccessReview;
import io.fabric8.openshift.api.model.v6_13.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.v6_13.SubjectAccessReview;
import io.fabric8.openshift.api.model.v6_13.SubjectRulesReview;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class OpenShiftOAuthInterceptor
extends TokenRefreshInterceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZATION_SERVER_PATH = ".well-known/oauth-authorization-server";
    private static final String AUTHORIZE_QUERY = "?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private static final Set<String> RETRIABLE_RESOURCES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(HasMetadata.getPlural(LocalSubjectAccessReview.class), HasMetadata.getPlural(LocalResourceAccessReview.class), HasMetadata.getPlural(ResourceAccessReview.class), HasMetadata.getPlural(SelfSubjectRulesReview.class), HasMetadata.getPlural(SubjectRulesReview.class), HasMetadata.getPlural(SubjectAccessReview.class), HasMetadata.getPlural(SelfSubjectAccessReview.class))));

    public OpenShiftOAuthInterceptor(HttpClient client, Config config) {
        super(config, Instant.now(), newestConfig -> OpenShiftOAuthInterceptor.authorize(config, client).thenApply(token -> OpenShiftOAuthInterceptor.persistNewOAuthTokenIntoKubeConfig(config, token)));
    }

    protected boolean useBasicAuth() {
        return false;
    }

    protected boolean useRemoteRefresh(Config newestConfig) {
        return this.isBasicAuth();
    }

    private static CompletableFuture<String> authorize(Config config, HttpClient client) {
        URL url;
        HttpClient.DerivedClientBuilder builder = client.newBuilder();
        builder.addOrReplaceInterceptor("TOKEN", null);
        HttpClient clone = builder.build();
        try {
            url = new URL(URLUtils.join((String[])new String[]{config.getMasterUrl(), AUTHORIZATION_SERVER_PATH}));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        CompletableFuture responseFuture = clone.sendAsync(clone.newHttpRequestBuilder().url(url).build(), String.class);
        return ((CompletableFuture)responseFuture.thenCompose(response -> {
            if (!response.isSuccessful() || response.body() == null) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + ")");
            }
            String body = (String)response.body();
            try {
                Map jsonResponse = (Map)Serialization.unmarshal((String)body, Map.class);
                String authorizationServer = String.valueOf(jsonResponse.get("authorization_endpoint"));
                URL authorizeQuery = new URL(authorizationServer + AUTHORIZE_QUERY);
                String credential = HttpClientUtils.basicCredentials((String)config.getUsername(), (String)config.getPassword());
                return clone.sendAsync(client.newHttpRequestBuilder().url(authorizeQuery).setHeader(AUTHORIZATION, credential).build(), String.class);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        })).thenApply(response -> {
            String token;
            HttpResponse responseOrPrevious = response.previousResponse().isPresent() ? (HttpResponse)response.previousResponse().get() : response;
            List location = responseOrPrevious.headers(LOCATION);
            String string = token = !location.isEmpty() ? (String)location.get(0) : null;
            if (token == null || token.isEmpty()) {
                throw new KubernetesClientException("Unexpected response (" + responseOrPrevious.code() + " " + responseOrPrevious.message() + "), to the authorization request. Missing header:[" + LOCATION + "].  More than likely the username / password are not correct.");
            }
            token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
            token = token.substring(0, token.indexOf(AFTER_TOKEN));
            return token;
        });
    }

    protected boolean shouldFail(HttpResponse<?> response) {
        HttpRequest request = response.request();
        String url = request.uri().toString();
        String method = request.method();
        if (method.equals("POST")) {
            if (RETRIABLE_RESOURCES.stream().anyMatch(url::endsWith)) {
                return false;
            }
        }
        return response.code() != 401;
    }

    private static String persistNewOAuthTokenIntoKubeConfig(Config config, String token) {
        if (token != null) {
            OpenIDConnectionUtils.persistOAuthToken((Config)config, null, (String)token);
        }
        return token;
    }
}

