/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelectorFluent;
import io.fabric8.openshift.api.model.v6_13.operatorhub.v1.OperatorGroupSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OperatorGroupSpecFluent<A extends OperatorGroupSpecFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder selector;
    private String serviceAccountName;
    private Boolean staticProvidedAPIs;
    private List<String> targetNamespaces = new ArrayList<String>();
    private String upgradeStrategy;
    private Map<String, Object> additionalProperties;

    public OperatorGroupSpecFluent() {
    }

    public OperatorGroupSpecFluent(OperatorGroupSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OperatorGroupSpec instance) {
        OperatorGroupSpec operatorGroupSpec = instance = instance != null ? instance : new OperatorGroupSpec();
        if (instance != null) {
            this.withSelector(instance.getSelector());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withStaticProvidedAPIs(instance.getStaticProvidedAPIs());
            this.withTargetNamespaces(instance.getTargetNamespaces());
            this.withUpgradeStrategy(instance.getUpgradeStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public Boolean getStaticProvidedAPIs() {
        return this.staticProvidedAPIs;
    }

    public A withStaticProvidedAPIs(Boolean staticProvidedAPIs) {
        this.staticProvidedAPIs = staticProvidedAPIs;
        return (A)this;
    }

    public boolean hasStaticProvidedAPIs() {
        return this.staticProvidedAPIs != null;
    }

    public A addToTargetNamespaces(int index, String item) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        this.targetNamespaces.add(index, item);
        return (A)this;
    }

    public A setToTargetNamespaces(int index, String item) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        this.targetNamespaces.set(index, item);
        return (A)this;
    }

    public A addToTargetNamespaces(String ... items) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetNamespaces.add(item);
        }
        return (A)this;
    }

    public A addAllToTargetNamespaces(Collection<String> items) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetNamespaces.add(item);
        }
        return (A)this;
    }

    public A removeFromTargetNamespaces(String ... items) {
        if (this.targetNamespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.targetNamespaces.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTargetNamespaces(Collection<String> items) {
        if (this.targetNamespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.targetNamespaces.remove(item);
        }
        return (A)this;
    }

    public List<String> getTargetNamespaces() {
        return this.targetNamespaces;
    }

    public String getTargetNamespace(int index) {
        return this.targetNamespaces.get(index);
    }

    public String getFirstTargetNamespace() {
        return this.targetNamespaces.get(0);
    }

    public String getLastTargetNamespace() {
        return this.targetNamespaces.get(this.targetNamespaces.size() - 1);
    }

    public String getMatchingTargetNamespace(Predicate<String> predicate) {
        for (String item : this.targetNamespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTargetNamespace(Predicate<String> predicate) {
        for (String item : this.targetNamespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetNamespaces(List<String> targetNamespaces) {
        if (targetNamespaces != null) {
            this.targetNamespaces = new ArrayList<String>();
            for (String item : targetNamespaces) {
                this.addToTargetNamespaces(item);
            }
        } else {
            this.targetNamespaces = null;
        }
        return (A)this;
    }

    public A withTargetNamespaces(String ... targetNamespaces) {
        if (this.targetNamespaces != null) {
            this.targetNamespaces.clear();
            this._visitables.remove("targetNamespaces");
        }
        if (targetNamespaces != null) {
            for (String item : targetNamespaces) {
                this.addToTargetNamespaces(item);
            }
        }
        return (A)this;
    }

    public boolean hasTargetNamespaces() {
        return this.targetNamespaces != null && !this.targetNamespaces.isEmpty();
    }

    public String getUpgradeStrategy() {
        return this.upgradeStrategy;
    }

    public A withUpgradeStrategy(String upgradeStrategy) {
        this.upgradeStrategy = upgradeStrategy;
        return (A)this;
    }

    public boolean hasUpgradeStrategy() {
        return this.upgradeStrategy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorGroupSpecFluent that = (OperatorGroupSpecFluent)o;
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.staticProvidedAPIs, that.staticProvidedAPIs)) {
            return false;
        }
        if (!Objects.equals(this.targetNamespaces, that.targetNamespaces)) {
            return false;
        }
        if (!Objects.equals(this.upgradeStrategy, that.upgradeStrategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.selector, this.serviceAccountName, this.staticProvidedAPIs, this.targetNamespaces, this.upgradeStrategy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.staticProvidedAPIs != null) {
            sb.append("staticProvidedAPIs:");
            sb.append(this.staticProvidedAPIs + ",");
        }
        if (this.targetNamespaces != null && !this.targetNamespaces.isEmpty()) {
            sb.append("targetNamespaces:");
            sb.append(this.targetNamespaces + ",");
        }
        if (this.upgradeStrategy != null) {
            sb.append("upgradeStrategy:");
            sb.append(this.upgradeStrategy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withStaticProvidedAPIs() {
        return this.withStaticProvidedAPIs(true);
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OperatorGroupSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

