/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.config.v1.DNSZone;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSZoneCondition;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSZoneConditionBuilder;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSZoneConditionFluent;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSZoneStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSZoneStatusFluent<A extends DNSZoneStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DNSZoneConditionBuilder> conditions = new ArrayList();
    private DNSZone dnsZone;
    private Map<String, Object> additionalProperties;

    public DNSZoneStatusFluent() {
    }

    public DNSZoneStatusFluent(DNSZoneStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSZoneStatus instance) {
        DNSZoneStatus dNSZoneStatus = instance = instance != null ? instance : new DNSZoneStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withDnsZone(instance.getDnsZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, DNSZoneCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, DNSZoneCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(DNSZoneCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<DNSZoneCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(DNSZoneCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<DNSZoneCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<DNSZoneConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<DNSZoneConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            DNSZoneConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DNSZoneCondition> buildConditions() {
        return this.conditions != null ? DNSZoneStatusFluent.build(this.conditions) : null;
    }

    public DNSZoneCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public DNSZoneCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public DNSZoneCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public DNSZoneCondition buildMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<DNSZoneCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (DNSZoneCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(DNSZoneCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (DNSZoneCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(DNSZoneCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, DNSZoneCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public DNSZone getDnsZone() {
        return this.dnsZone;
    }

    public A withDnsZone(DNSZone dnsZone) {
        this.dnsZone = dnsZone;
        return (A)this;
    }

    public boolean hasDnsZone() {
        return this.dnsZone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSZoneStatusFluent that = (DNSZoneStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.dnsZone, that.dnsZone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.dnsZone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.dnsZone != null) {
            sb.append("dnsZone:");
            sb.append(this.dnsZone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends DNSZoneConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        DNSZoneConditionBuilder builder;
        int index;

        ConditionsNested(int index, DNSZoneCondition item) {
            this.index = index;
            this.builder = new DNSZoneConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

