/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSCache;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSCacheBuilder;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSCacheFluent;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSNodePlacement;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSNodePlacementBuilder;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSNodePlacementFluent;
import io.fabric8.openshift.api.model.v6_13.operator.v1.DNSSpec;
import io.fabric8.openshift.api.model.v6_13.operator.v1.Server;
import io.fabric8.openshift.api.model.v6_13.operator.v1.ServerBuilder;
import io.fabric8.openshift.api.model.v6_13.operator.v1.ServerFluent;
import io.fabric8.openshift.api.model.v6_13.operator.v1.UpstreamResolvers;
import io.fabric8.openshift.api.model.v6_13.operator.v1.UpstreamResolversBuilder;
import io.fabric8.openshift.api.model.v6_13.operator.v1.UpstreamResolversFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DNSSpecFluent<A extends DNSSpecFluent<A>>
extends BaseFluent<A> {
    private DNSCacheBuilder cache;
    private String logLevel;
    private String managementState;
    private DNSNodePlacementBuilder nodePlacement;
    private String operatorLogLevel;
    private ArrayList<ServerBuilder> servers = new ArrayList();
    private UpstreamResolversBuilder upstreamResolvers;
    private Map<String, Object> additionalProperties;

    public DNSSpecFluent() {
    }

    public DNSSpecFluent(DNSSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSSpec instance) {
        DNSSpec dNSSpec = instance = instance != null ? instance : new DNSSpec();
        if (instance != null) {
            this.withCache(instance.getCache());
            this.withLogLevel(instance.getLogLevel());
            this.withManagementState(instance.getManagementState());
            this.withNodePlacement(instance.getNodePlacement());
            this.withOperatorLogLevel(instance.getOperatorLogLevel());
            this.withServers(instance.getServers());
            this.withUpstreamResolvers(instance.getUpstreamResolvers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DNSCache buildCache() {
        return this.cache != null ? this.cache.build() : null;
    }

    public A withCache(DNSCache cache) {
        this._visitables.remove("cache");
        if (cache != null) {
            this.cache = new DNSCacheBuilder(cache);
            this._visitables.get("cache").add(this.cache);
        } else {
            this.cache = null;
            this._visitables.get("cache").remove(this.cache);
        }
        return (A)this;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public CacheNested<A> withNewCache() {
        return new CacheNested(null);
    }

    public CacheNested<A> withNewCacheLike(DNSCache item) {
        return new CacheNested(item);
    }

    public CacheNested<A> editCache() {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(null));
    }

    public CacheNested<A> editOrNewCache() {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(new DNSCacheBuilder().build()));
    }

    public CacheNested<A> editOrNewCacheLike(DNSCache item) {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(item));
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public String getManagementState() {
        return this.managementState;
    }

    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    public boolean hasManagementState() {
        return this.managementState != null;
    }

    public DNSNodePlacement buildNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    public A withNodePlacement(DNSNodePlacement nodePlacement) {
        this._visitables.remove("nodePlacement");
        if (nodePlacement != null) {
            this.nodePlacement = new DNSNodePlacementBuilder(nodePlacement);
            this._visitables.get("nodePlacement").add(this.nodePlacement);
        } else {
            this.nodePlacement = null;
            this._visitables.get("nodePlacement").remove(this.nodePlacement);
        }
        return (A)this;
    }

    public boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    public NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNested(null);
    }

    public NodePlacementNested<A> withNewNodePlacementLike(DNSNodePlacement item) {
        return new NodePlacementNested(item);
    }

    public NodePlacementNested<A> editNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(null));
    }

    public NodePlacementNested<A> editOrNewNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(new DNSNodePlacementBuilder().build()));
    }

    public NodePlacementNested<A> editOrNewNodePlacementLike(DNSNodePlacement item) {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(item));
    }

    public String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    public A withOperatorLogLevel(String operatorLogLevel) {
        this.operatorLogLevel = operatorLogLevel;
        return (A)this;
    }

    public boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    public A addToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this.servers.size()) {
            this._visitables.get("servers").add(builder);
            this.servers.add(builder);
        } else {
            this._visitables.get("servers").add(index, builder);
            this.servers.add(index, builder);
        }
        return (A)this;
    }

    public A setToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this.servers.size()) {
            this._visitables.get("servers").add(builder);
            this.servers.add(builder);
        } else {
            this._visitables.get("servers").set(index, builder);
            this.servers.set(index, builder);
        }
        return (A)this;
    }

    public A addToServers(Server ... items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    public A addAllToServers(Collection<Server> items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    public A removeFromServers(Server ... items) {
        if (this.servers == null) {
            return (A)this;
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").remove(builder);
            this.servers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServers(Collection<Server> items) {
        if (this.servers == null) {
            return (A)this;
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").remove(builder);
            this.servers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
        if (this.servers == null) {
            return (A)this;
        }
        Iterator<ServerBuilder> each = this.servers.iterator();
        Object visitables = this._visitables.get("servers");
        while (each.hasNext()) {
            ServerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Server> buildServers() {
        return this.servers != null ? DNSSpecFluent.build(this.servers) : null;
    }

    public Server buildServer(int index) {
        return this.servers.get(index).build();
    }

    public Server buildFirstServer() {
        return this.servers.get(0).build();
    }

    public Server buildLastServer() {
        return this.servers.get(this.servers.size() - 1).build();
    }

    public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServers(List<Server> servers) {
        if (this.servers != null) {
            this._visitables.get("servers").clear();
        }
        if (servers != null) {
            this.servers = new ArrayList();
            for (Server item : servers) {
                this.addToServers(item);
            }
        } else {
            this.servers = null;
        }
        return (A)this;
    }

    public A withServers(Server ... servers) {
        if (this.servers != null) {
            this.servers.clear();
            this._visitables.remove("servers");
        }
        if (servers != null) {
            for (Server item : servers) {
                this.addToServers(item);
            }
        }
        return (A)this;
    }

    public boolean hasServers() {
        return this.servers != null && !this.servers.isEmpty();
    }

    public ServersNested<A> addNewServer() {
        return new ServersNested(-1, null);
    }

    public ServersNested<A> addNewServerLike(Server item) {
        return new ServersNested(-1, item);
    }

    public ServersNested<A> setNewServerLike(int index, Server item) {
        return new ServersNested(index, item);
    }

    public ServersNested<A> editServer(int index) {
        if (this.servers.size() <= index) {
            throw new RuntimeException("Can't edit servers. Index exceeds size.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public ServersNested<A> editFirstServer() {
        if (this.servers.size() == 0) {
            throw new RuntimeException("Can't edit first servers. The list is empty.");
        }
        return this.setNewServerLike(0, this.buildServer(0));
    }

    public ServersNested<A> editLastServer() {
        int index = this.servers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last servers. The list is empty.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!predicate.test(this.servers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching servers. No match found.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public UpstreamResolvers buildUpstreamResolvers() {
        return this.upstreamResolvers != null ? this.upstreamResolvers.build() : null;
    }

    public A withUpstreamResolvers(UpstreamResolvers upstreamResolvers) {
        this._visitables.remove("upstreamResolvers");
        if (upstreamResolvers != null) {
            this.upstreamResolvers = new UpstreamResolversBuilder(upstreamResolvers);
            this._visitables.get("upstreamResolvers").add(this.upstreamResolvers);
        } else {
            this.upstreamResolvers = null;
            this._visitables.get("upstreamResolvers").remove(this.upstreamResolvers);
        }
        return (A)this;
    }

    public boolean hasUpstreamResolvers() {
        return this.upstreamResolvers != null;
    }

    public UpstreamResolversNested<A> withNewUpstreamResolvers() {
        return new UpstreamResolversNested(null);
    }

    public UpstreamResolversNested<A> withNewUpstreamResolversLike(UpstreamResolvers item) {
        return new UpstreamResolversNested(item);
    }

    public UpstreamResolversNested<A> editUpstreamResolvers() {
        return this.withNewUpstreamResolversLike(Optional.ofNullable(this.buildUpstreamResolvers()).orElse(null));
    }

    public UpstreamResolversNested<A> editOrNewUpstreamResolvers() {
        return this.withNewUpstreamResolversLike(Optional.ofNullable(this.buildUpstreamResolvers()).orElse(new UpstreamResolversBuilder().build()));
    }

    public UpstreamResolversNested<A> editOrNewUpstreamResolversLike(UpstreamResolvers item) {
        return this.withNewUpstreamResolversLike(Optional.ofNullable(this.buildUpstreamResolvers()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSSpecFluent that = (DNSSpecFluent)o;
        if (!Objects.equals(this.cache, that.cache)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.managementState, that.managementState)) {
            return false;
        }
        if (!Objects.equals(this.nodePlacement, that.nodePlacement)) {
            return false;
        }
        if (!Objects.equals(this.operatorLogLevel, that.operatorLogLevel)) {
            return false;
        }
        if (!Objects.equals(this.servers, that.servers)) {
            return false;
        }
        if (!Objects.equals(this.upstreamResolvers, that.upstreamResolvers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cache, this.logLevel, this.managementState, this.nodePlacement, this.operatorLogLevel, this.servers, this.upstreamResolvers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cache != null) {
            sb.append("cache:");
            sb.append(this.cache + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState + ",");
        }
        if (this.nodePlacement != null) {
            sb.append("nodePlacement:");
            sb.append(this.nodePlacement + ",");
        }
        if (this.operatorLogLevel != null) {
            sb.append("operatorLogLevel:");
            sb.append(this.operatorLogLevel + ",");
        }
        if (this.servers != null && !this.servers.isEmpty()) {
            sb.append("servers:");
            sb.append(this.servers + ",");
        }
        if (this.upstreamResolvers != null) {
            sb.append("upstreamResolvers:");
            sb.append(this.upstreamResolvers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpstreamResolversNested<N>
    extends UpstreamResolversFluent<UpstreamResolversNested<N>>
    implements Nested<N> {
        UpstreamResolversBuilder builder;

        UpstreamResolversNested(UpstreamResolvers item) {
            this.builder = new UpstreamResolversBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluent.this.withUpstreamResolvers(this.builder.build());
        }

        public N endUpstreamResolvers() {
            return this.and();
        }
    }

    public class ServersNested<N>
    extends ServerFluent<ServersNested<N>>
    implements Nested<N> {
        ServerBuilder builder;
        int index;

        ServersNested(int index, Server item) {
            this.index = index;
            this.builder = new ServerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluent.this.setToServers(this.index, this.builder.build());
        }

        public N endServer() {
            return this.and();
        }
    }

    public class NodePlacementNested<N>
    extends DNSNodePlacementFluent<NodePlacementNested<N>>
    implements Nested<N> {
        DNSNodePlacementBuilder builder;

        NodePlacementNested(DNSNodePlacement item) {
            this.builder = new DNSNodePlacementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluent.this.withNodePlacement(this.builder.build());
        }

        public N endNodePlacement() {
            return this.and();
        }
    }

    public class CacheNested<N>
    extends DNSCacheFluent<CacheNested<N>>
    implements Nested<N> {
        DNSCacheBuilder builder;

        CacheNested(DNSCache item) {
            this.builder = new DNSCacheBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluent.this.withCache(this.builder.build());
        }

        public N endCache() {
            return this.and();
        }
    }
}

