/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.Matcher;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.MatcherBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.MatcherFluent;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1alpha1.Route;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteFluent<A extends RouteFluent<A>>
extends BaseFluent<A> {
    private List<String> activeTimeIntervals = new ArrayList<String>();
    private Boolean _continue;
    private List<String> groupBy = new ArrayList<String>();
    private String groupInterval;
    private String groupWait;
    private ArrayList<MatcherBuilder> matchers = new ArrayList();
    private List<String> muteTimeIntervals = new ArrayList<String>();
    private String receiver;
    private String repeatInterval;
    private List<JsonNode> routes = new ArrayList<JsonNode>();
    private Map<String, Object> additionalProperties;

    public RouteFluent() {
    }

    public RouteFluent(Route instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Route instance) {
        Route route = instance = instance != null ? instance : new Route();
        if (instance != null) {
            this.withActiveTimeIntervals(instance.getActiveTimeIntervals());
            this.withContinue(instance.getContinue());
            this.withGroupBy(instance.getGroupBy());
            this.withGroupInterval(instance.getGroupInterval());
            this.withGroupWait(instance.getGroupWait());
            this.withMatchers(instance.getMatchers());
            this.withMuteTimeIntervals(instance.getMuteTimeIntervals());
            this.withReceiver(instance.getReceiver());
            this.withRepeatInterval(instance.getRepeatInterval());
            this.withRoutes(instance.getRoutes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToActiveTimeIntervals(int index, String item) {
        if (this.activeTimeIntervals == null) {
            this.activeTimeIntervals = new ArrayList<String>();
        }
        this.activeTimeIntervals.add(index, item);
        return (A)this;
    }

    public A setToActiveTimeIntervals(int index, String item) {
        if (this.activeTimeIntervals == null) {
            this.activeTimeIntervals = new ArrayList<String>();
        }
        this.activeTimeIntervals.set(index, item);
        return (A)this;
    }

    public A addToActiveTimeIntervals(String ... items) {
        if (this.activeTimeIntervals == null) {
            this.activeTimeIntervals = new ArrayList<String>();
        }
        for (String item : items) {
            this.activeTimeIntervals.add(item);
        }
        return (A)this;
    }

    public A addAllToActiveTimeIntervals(Collection<String> items) {
        if (this.activeTimeIntervals == null) {
            this.activeTimeIntervals = new ArrayList<String>();
        }
        for (String item : items) {
            this.activeTimeIntervals.add(item);
        }
        return (A)this;
    }

    public A removeFromActiveTimeIntervals(String ... items) {
        if (this.activeTimeIntervals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.activeTimeIntervals.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromActiveTimeIntervals(Collection<String> items) {
        if (this.activeTimeIntervals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.activeTimeIntervals.remove(item);
        }
        return (A)this;
    }

    public List<String> getActiveTimeIntervals() {
        return this.activeTimeIntervals;
    }

    public String getActiveTimeInterval(int index) {
        return this.activeTimeIntervals.get(index);
    }

    public String getFirstActiveTimeInterval() {
        return this.activeTimeIntervals.get(0);
    }

    public String getLastActiveTimeInterval() {
        return this.activeTimeIntervals.get(this.activeTimeIntervals.size() - 1);
    }

    public String getMatchingActiveTimeInterval(Predicate<String> predicate) {
        for (String item : this.activeTimeIntervals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingActiveTimeInterval(Predicate<String> predicate) {
        for (String item : this.activeTimeIntervals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withActiveTimeIntervals(List<String> activeTimeIntervals) {
        if (activeTimeIntervals != null) {
            this.activeTimeIntervals = new ArrayList<String>();
            for (String item : activeTimeIntervals) {
                this.addToActiveTimeIntervals(item);
            }
        } else {
            this.activeTimeIntervals = null;
        }
        return (A)this;
    }

    public A withActiveTimeIntervals(String ... activeTimeIntervals) {
        if (this.activeTimeIntervals != null) {
            this.activeTimeIntervals.clear();
            this._visitables.remove("activeTimeIntervals");
        }
        if (activeTimeIntervals != null) {
            for (String item : activeTimeIntervals) {
                this.addToActiveTimeIntervals(item);
            }
        }
        return (A)this;
    }

    public boolean hasActiveTimeIntervals() {
        return this.activeTimeIntervals != null && !this.activeTimeIntervals.isEmpty();
    }

    public Boolean getContinue() {
        return this._continue;
    }

    public A withContinue(Boolean _continue) {
        this._continue = _continue;
        return (A)this;
    }

    public boolean hasContinue() {
        return this._continue != null;
    }

    public A addToGroupBy(int index, String item) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.add(index, item);
        return (A)this;
    }

    public A setToGroupBy(int index, String item) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.set(index, item);
        return (A)this;
    }

    public A addToGroupBy(String ... items) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupBy.add(item);
        }
        return (A)this;
    }

    public A addAllToGroupBy(Collection<String> items) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupBy.add(item);
        }
        return (A)this;
    }

    public A removeFromGroupBy(String ... items) {
        if (this.groupBy == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groupBy.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGroupBy(Collection<String> items) {
        if (this.groupBy == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groupBy.remove(item);
        }
        return (A)this;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public String getGroupBy(int index) {
        return this.groupBy.get(index);
    }

    public String getFirstGroupBy() {
        return this.groupBy.get(0);
    }

    public String getLastGroupBy() {
        return this.groupBy.get(this.groupBy.size() - 1);
    }

    public String getMatchingGroupBy(Predicate<String> predicate) {
        for (String item : this.groupBy) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroupBy(Predicate<String> predicate) {
        for (String item : this.groupBy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroupBy(List<String> groupBy) {
        if (groupBy != null) {
            this.groupBy = new ArrayList<String>();
            for (String item : groupBy) {
                this.addToGroupBy(item);
            }
        } else {
            this.groupBy = null;
        }
        return (A)this;
    }

    public A withGroupBy(String ... groupBy) {
        if (this.groupBy != null) {
            this.groupBy.clear();
            this._visitables.remove("groupBy");
        }
        if (groupBy != null) {
            for (String item : groupBy) {
                this.addToGroupBy(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroupBy() {
        return this.groupBy != null && !this.groupBy.isEmpty();
    }

    public String getGroupInterval() {
        return this.groupInterval;
    }

    public A withGroupInterval(String groupInterval) {
        this.groupInterval = groupInterval;
        return (A)this;
    }

    public boolean hasGroupInterval() {
        return this.groupInterval != null;
    }

    public String getGroupWait() {
        return this.groupWait;
    }

    public A withGroupWait(String groupWait) {
        this.groupWait = groupWait;
        return (A)this;
    }

    public boolean hasGroupWait() {
        return this.groupWait != null;
    }

    public A addToMatchers(int index, Matcher item) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= this.matchers.size()) {
            this._visitables.get("matchers").add(builder);
            this.matchers.add(builder);
        } else {
            this._visitables.get("matchers").add(index, builder);
            this.matchers.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchers(int index, Matcher item) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        MatcherBuilder builder = new MatcherBuilder(item);
        if (index < 0 || index >= this.matchers.size()) {
            this._visitables.get("matchers").add(builder);
            this.matchers.add(builder);
        } else {
            this._visitables.get("matchers").set(index, builder);
            this.matchers.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchers(Matcher ... items) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").add(builder);
            this.matchers.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchers(Collection<Matcher> items) {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").add(builder);
            this.matchers.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchers(Matcher ... items) {
        if (this.matchers == null) {
            return (A)this;
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").remove(builder);
            this.matchers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchers(Collection<Matcher> items) {
        if (this.matchers == null) {
            return (A)this;
        }
        for (Matcher item : items) {
            MatcherBuilder builder = new MatcherBuilder(item);
            this._visitables.get("matchers").remove(builder);
            this.matchers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchers(Predicate<MatcherBuilder> predicate) {
        if (this.matchers == null) {
            return (A)this;
        }
        Iterator<MatcherBuilder> each = this.matchers.iterator();
        Object visitables = this._visitables.get("matchers");
        while (each.hasNext()) {
            MatcherBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Matcher> buildMatchers() {
        return this.matchers != null ? RouteFluent.build(this.matchers) : null;
    }

    public Matcher buildMatcher(int index) {
        return this.matchers.get(index).build();
    }

    public Matcher buildFirstMatcher() {
        return this.matchers.get(0).build();
    }

    public Matcher buildLastMatcher() {
        return this.matchers.get(this.matchers.size() - 1).build();
    }

    public Matcher buildMatchingMatcher(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.matchers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatcher(Predicate<MatcherBuilder> predicate) {
        for (MatcherBuilder item : this.matchers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchers(List<Matcher> matchers) {
        if (this.matchers != null) {
            this._visitables.get("matchers").clear();
        }
        if (matchers != null) {
            this.matchers = new ArrayList();
            for (Matcher item : matchers) {
                this.addToMatchers(item);
            }
        } else {
            this.matchers = null;
        }
        return (A)this;
    }

    public A withMatchers(Matcher ... matchers) {
        if (this.matchers != null) {
            this.matchers.clear();
            this._visitables.remove("matchers");
        }
        if (matchers != null) {
            for (Matcher item : matchers) {
                this.addToMatchers(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchers() {
        return this.matchers != null && !this.matchers.isEmpty();
    }

    public A addNewMatcher(String matchType, String name, Boolean regex, String value) {
        return this.addToMatchers(new Matcher(matchType, name, regex, value));
    }

    public MatchersNested<A> addNewMatcher() {
        return new MatchersNested(-1, null);
    }

    public MatchersNested<A> addNewMatcherLike(Matcher item) {
        return new MatchersNested(-1, item);
    }

    public MatchersNested<A> setNewMatcherLike(int index, Matcher item) {
        return new MatchersNested(index, item);
    }

    public MatchersNested<A> editMatcher(int index) {
        if (this.matchers.size() <= index) {
            throw new RuntimeException("Can't edit matchers. Index exceeds size.");
        }
        return this.setNewMatcherLike(index, this.buildMatcher(index));
    }

    public MatchersNested<A> editFirstMatcher() {
        if (this.matchers.size() == 0) {
            throw new RuntimeException("Can't edit first matchers. The list is empty.");
        }
        return this.setNewMatcherLike(0, this.buildMatcher(0));
    }

    public MatchersNested<A> editLastMatcher() {
        int index = this.matchers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchers. The list is empty.");
        }
        return this.setNewMatcherLike(index, this.buildMatcher(index));
    }

    public MatchersNested<A> editMatchingMatcher(Predicate<MatcherBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchers.size(); ++i) {
            if (!predicate.test(this.matchers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchers. No match found.");
        }
        return this.setNewMatcherLike(index, this.buildMatcher(index));
    }

    public A addToMuteTimeIntervals(int index, String item) {
        if (this.muteTimeIntervals == null) {
            this.muteTimeIntervals = new ArrayList<String>();
        }
        this.muteTimeIntervals.add(index, item);
        return (A)this;
    }

    public A setToMuteTimeIntervals(int index, String item) {
        if (this.muteTimeIntervals == null) {
            this.muteTimeIntervals = new ArrayList<String>();
        }
        this.muteTimeIntervals.set(index, item);
        return (A)this;
    }

    public A addToMuteTimeIntervals(String ... items) {
        if (this.muteTimeIntervals == null) {
            this.muteTimeIntervals = new ArrayList<String>();
        }
        for (String item : items) {
            this.muteTimeIntervals.add(item);
        }
        return (A)this;
    }

    public A addAllToMuteTimeIntervals(Collection<String> items) {
        if (this.muteTimeIntervals == null) {
            this.muteTimeIntervals = new ArrayList<String>();
        }
        for (String item : items) {
            this.muteTimeIntervals.add(item);
        }
        return (A)this;
    }

    public A removeFromMuteTimeIntervals(String ... items) {
        if (this.muteTimeIntervals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.muteTimeIntervals.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMuteTimeIntervals(Collection<String> items) {
        if (this.muteTimeIntervals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.muteTimeIntervals.remove(item);
        }
        return (A)this;
    }

    public List<String> getMuteTimeIntervals() {
        return this.muteTimeIntervals;
    }

    public String getMuteTimeInterval(int index) {
        return this.muteTimeIntervals.get(index);
    }

    public String getFirstMuteTimeInterval() {
        return this.muteTimeIntervals.get(0);
    }

    public String getLastMuteTimeInterval() {
        return this.muteTimeIntervals.get(this.muteTimeIntervals.size() - 1);
    }

    public String getMatchingMuteTimeInterval(Predicate<String> predicate) {
        for (String item : this.muteTimeIntervals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMuteTimeInterval(Predicate<String> predicate) {
        for (String item : this.muteTimeIntervals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMuteTimeIntervals(List<String> muteTimeIntervals) {
        if (muteTimeIntervals != null) {
            this.muteTimeIntervals = new ArrayList<String>();
            for (String item : muteTimeIntervals) {
                this.addToMuteTimeIntervals(item);
            }
        } else {
            this.muteTimeIntervals = null;
        }
        return (A)this;
    }

    public A withMuteTimeIntervals(String ... muteTimeIntervals) {
        if (this.muteTimeIntervals != null) {
            this.muteTimeIntervals.clear();
            this._visitables.remove("muteTimeIntervals");
        }
        if (muteTimeIntervals != null) {
            for (String item : muteTimeIntervals) {
                this.addToMuteTimeIntervals(item);
            }
        }
        return (A)this;
    }

    public boolean hasMuteTimeIntervals() {
        return this.muteTimeIntervals != null && !this.muteTimeIntervals.isEmpty();
    }

    public String getReceiver() {
        return this.receiver;
    }

    public A withReceiver(String receiver) {
        this.receiver = receiver;
        return (A)this;
    }

    public boolean hasReceiver() {
        return this.receiver != null;
    }

    public String getRepeatInterval() {
        return this.repeatInterval;
    }

    public A withRepeatInterval(String repeatInterval) {
        this.repeatInterval = repeatInterval;
        return (A)this;
    }

    public boolean hasRepeatInterval() {
        return this.repeatInterval != null;
    }

    public A addToRoutes(int index, JsonNode item) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        this.routes.add(index, item);
        return (A)this;
    }

    public A setToRoutes(int index, JsonNode item) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        this.routes.set(index, item);
        return (A)this;
    }

    public A addToRoutes(JsonNode ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.routes.add(item);
        }
        return (A)this;
    }

    public A addAllToRoutes(Collection<JsonNode> items) {
        if (this.routes == null) {
            this.routes = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.routes.add(item);
        }
        return (A)this;
    }

    public A removeFromRoutes(JsonNode ... items) {
        if (this.routes == null) {
            return (A)this;
        }
        for (JsonNode item : items) {
            this.routes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRoutes(Collection<JsonNode> items) {
        if (this.routes == null) {
            return (A)this;
        }
        for (JsonNode item : items) {
            this.routes.remove(item);
        }
        return (A)this;
    }

    public List<JsonNode> getRoutes() {
        return this.routes;
    }

    public JsonNode getRoute(int index) {
        return this.routes.get(index);
    }

    public JsonNode getFirstRoute() {
        return this.routes.get(0);
    }

    public JsonNode getLastRoute() {
        return this.routes.get(this.routes.size() - 1);
    }

    public JsonNode getMatchingRoute(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.routes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRoute(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.routes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoutes(List<JsonNode> routes) {
        if (routes != null) {
            this.routes = new ArrayList<JsonNode>();
            for (JsonNode item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)this;
    }

    public A withRoutes(JsonNode ... routes) {
        if (this.routes != null) {
            this.routes.clear();
            this._visitables.remove("routes");
        }
        if (routes != null) {
            for (JsonNode item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)this;
    }

    public boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteFluent that = (RouteFluent)o;
        if (!Objects.equals(this.activeTimeIntervals, that.activeTimeIntervals)) {
            return false;
        }
        if (!Objects.equals(this._continue, that._continue)) {
            return false;
        }
        if (!Objects.equals(this.groupBy, that.groupBy)) {
            return false;
        }
        if (!Objects.equals(this.groupInterval, that.groupInterval)) {
            return false;
        }
        if (!Objects.equals(this.groupWait, that.groupWait)) {
            return false;
        }
        if (!Objects.equals(this.matchers, that.matchers)) {
            return false;
        }
        if (!Objects.equals(this.muteTimeIntervals, that.muteTimeIntervals)) {
            return false;
        }
        if (!Objects.equals(this.receiver, that.receiver)) {
            return false;
        }
        if (!Objects.equals(this.repeatInterval, that.repeatInterval)) {
            return false;
        }
        if (!Objects.equals(this.routes, that.routes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.activeTimeIntervals, this._continue, this.groupBy, this.groupInterval, this.groupWait, this.matchers, this.muteTimeIntervals, this.receiver, this.repeatInterval, this.routes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeTimeIntervals != null && !this.activeTimeIntervals.isEmpty()) {
            sb.append("activeTimeIntervals:");
            sb.append(this.activeTimeIntervals + ",");
        }
        if (this._continue != null) {
            sb.append("_continue:");
            sb.append(this._continue + ",");
        }
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            sb.append("groupBy:");
            sb.append(this.groupBy + ",");
        }
        if (this.groupInterval != null) {
            sb.append("groupInterval:");
            sb.append(this.groupInterval + ",");
        }
        if (this.groupWait != null) {
            sb.append("groupWait:");
            sb.append(this.groupWait + ",");
        }
        if (this.matchers != null && !this.matchers.isEmpty()) {
            sb.append("matchers:");
            sb.append(this.matchers + ",");
        }
        if (this.muteTimeIntervals != null && !this.muteTimeIntervals.isEmpty()) {
            sb.append("muteTimeIntervals:");
            sb.append(this.muteTimeIntervals + ",");
        }
        if (this.receiver != null) {
            sb.append("receiver:");
            sb.append(this.receiver + ",");
        }
        if (this.repeatInterval != null) {
            sb.append("repeatInterval:");
            sb.append(this.repeatInterval + ",");
        }
        if (this.routes != null && !this.routes.isEmpty()) {
            sb.append("routes:");
            sb.append(this.routes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withContinue() {
        return this.withContinue(true);
    }

    public class MatchersNested<N>
    extends MatcherFluent<MatchersNested<N>>
    implements Nested<N> {
        MatcherBuilder builder;
        int index;

        MatchersNested(int index, Matcher item) {
            this.index = index;
            this.builder = new MatcherBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteFluent.this.setToMatchers(this.index, this.builder.build());
        }

        public N endMatcher() {
            return this.and();
        }
    }
}

