/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.v6_13.monitoring.v1.SecretOrConfigMapFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SafeTLSConfigFluent<A extends SafeTLSConfigFluent<A>>
extends BaseFluent<A> {
    private SecretOrConfigMapBuilder ca;
    private SecretOrConfigMapBuilder cert;
    private Boolean insecureSkipVerify;
    private SecretKeySelector keySecret;
    private String serverName;
    private Map<String, Object> additionalProperties;

    public SafeTLSConfigFluent() {
    }

    public SafeTLSConfigFluent(SafeTLSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SafeTLSConfig instance) {
        SafeTLSConfig safeTLSConfig = instance = instance != null ? instance : new SafeTLSConfig();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withCert(instance.getCert());
            this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
            this.withKeySecret(instance.getKeySecret());
            this.withServerName(instance.getServerName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretOrConfigMap buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(SecretOrConfigMap ca) {
        this._visitables.remove("ca");
        if (ca != null) {
            this.ca = new SecretOrConfigMapBuilder(ca);
            this._visitables.get("ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get("ca").remove(this.ca);
        }
        return (A)this;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(SecretOrConfigMap item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(SecretOrConfigMap item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public SecretOrConfigMap buildCert() {
        return this.cert != null ? this.cert.build() : null;
    }

    public A withCert(SecretOrConfigMap cert) {
        this._visitables.remove("cert");
        if (cert != null) {
            this.cert = new SecretOrConfigMapBuilder(cert);
            this._visitables.get("cert").add(this.cert);
        } else {
            this.cert = null;
            this._visitables.get("cert").remove(this.cert);
        }
        return (A)this;
    }

    public boolean hasCert() {
        return this.cert != null;
    }

    public CertNested<A> withNewCert() {
        return new CertNested(null);
    }

    public CertNested<A> withNewCertLike(SecretOrConfigMap item) {
        return new CertNested(item);
    }

    public CertNested<A> editCert() {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(null));
    }

    public CertNested<A> editOrNewCert() {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(item));
    }

    public Boolean getInsecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
        this.insecureSkipVerify = insecureSkipVerify;
        return (A)this;
    }

    public boolean hasInsecureSkipVerify() {
        return this.insecureSkipVerify != null;
    }

    public SecretKeySelector getKeySecret() {
        return this.keySecret;
    }

    public A withKeySecret(SecretKeySelector keySecret) {
        this.keySecret = keySecret;
        return (A)this;
    }

    public boolean hasKeySecret() {
        return this.keySecret != null;
    }

    public A withNewKeySecret(String key, String name, Boolean optional) {
        return this.withKeySecret(new SecretKeySelector(key, name, optional));
    }

    public String getServerName() {
        return this.serverName;
    }

    public A withServerName(String serverName) {
        this.serverName = serverName;
        return (A)this;
    }

    public boolean hasServerName() {
        return this.serverName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SafeTLSConfigFluent that = (SafeTLSConfigFluent)o;
        if (!Objects.equals(this.ca, that.ca)) {
            return false;
        }
        if (!Objects.equals(this.cert, that.cert)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipVerify, that.insecureSkipVerify)) {
            return false;
        }
        if (!Objects.equals(this.keySecret, that.keySecret)) {
            return false;
        }
        if (!Objects.equals(this.serverName, that.serverName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ca, this.cert, this.insecureSkipVerify, this.keySecret, this.serverName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.cert != null) {
            sb.append("cert:");
            sb.append(this.cert + ",");
        }
        if (this.insecureSkipVerify != null) {
            sb.append("insecureSkipVerify:");
            sb.append(this.insecureSkipVerify + ",");
        }
        if (this.keySecret != null) {
            sb.append("keySecret:");
            sb.append(this.keySecret + ",");
        }
        if (this.serverName != null) {
            sb.append("serverName:");
            sb.append(this.serverName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecureSkipVerify() {
        return this.withInsecureSkipVerify(true);
    }

    public class CertNested<N>
    extends SecretOrConfigMapFluent<CertNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        CertNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SafeTLSConfigFluent.this.withCert(this.builder.build());
        }

        public N endCert() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends SecretOrConfigMapFluent<CaNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        CaNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SafeTLSConfigFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

